/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel.view;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.panel.view.IPanelViewState;
import com.yy.hiyo.channel.plugins.ktv.panel.view.IPanelVisibleListener;

public class KTVLoadingPanelView
extends YYFrameLayout
implements IPanelViewState {
    private ImageView mIvClosePanel;
    private YYImageView mIvLoadingIcon;
    private ObjectAnimator mRotationAnimator;
    private OnLoadingPanelListener mListener;
    private boolean mIsShowing;

    public KTVLoadingPanelView(Context context) {
        this(context, null);
    }

    public KTVLoadingPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_ktv_loading_panel_channel, (ViewGroup)this, true);
        this.mIvLoadingIcon = (YYImageView)this.findViewById(R.id.iv_loading_icon);
        this.mIvClosePanel = (ImageView)this.findViewById(R.id.iv_close_panel);
        this.mIvClosePanel.setOnClickListener(v -> {
            if (this.mListener != null) {
                this.mListener.clickClosePanelBtn(v);
            }
        });
    }

    private void playLoadingAnimator() {
        if (this.mRotationAnimator == null) {
            this.mRotationAnimator = ObjectAnimator.ofFloat((Object)this.mIvLoadingIcon, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
            this.mRotationAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mRotationAnimator.setDuration(800L);
            this.mRotationAnimator.setRepeatCount(-1);
            this.mRotationAnimator.setRepeatMode(1);
        }
        this.mRotationAnimator.start();
    }

    @Override
    public void onPanelViewShow(boolean isSinger, boolean isPause) {
        this.mIsShowing = true;
        this.playLoadingAnimator();
        if (this.mListener != null) {
            YYTaskExecutor.postToMainThread(() -> this.mListener.onChangedVisible());
        }
    }

    @Override
    public void onPanelViewHide() {
        this.mIsShowing = false;
        if (this.mRotationAnimator != null) {
            this.mRotationAnimator.end();
            this.mRotationAnimator = null;
        }
    }

    @Override
    public void onIsPauseState(boolean isPause) {
    }

    @Override
    public boolean isShowing() {
        return this.mIsShowing;
    }

    @Override
    public Point getAvatarPoint() {
        return null;
    }

    public void setOnLoadinganelListener(OnLoadingPanelListener listener) {
        this.mListener = listener;
    }

    public void setCloseVisible(boolean showClose) {
        this.mIvClosePanel.setVisibility(showClose ? 0 : 8);
    }

    public static interface OnLoadingPanelListener
    extends IPanelVisibleListener {
        public void clickClosePanelBtn(View var1);
    }
}

