/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.widget;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.wallet.base.giftbox.GiftSweepImageView;

public class KTVPanelButton
extends YYFrameLayout {
    private YYFrameLayout mLayoutParent;
    private RecycleImageView mIvLoading;
    private View mViewSpace;
    private YYTextView mTvText;
    private GiftSweepImageView mKtvSweepImageView;
    private ObjectAnimator mRotationAnimator;

    public KTVPanelButton(Context context) {
        this(context, null);
    }

    public KTVPanelButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.view_ktv_panel_btn_channel, (ViewGroup)this);
        this.mLayoutParent = (YYFrameLayout)this.findViewById(R.id.rlyt_btn_parent);
        this.mIvLoading = (RecycleImageView)this.findViewById(R.id.iv_loading);
        this.mViewSpace = this.findViewById(R.id.view_space);
        this.mTvText = (YYTextView)this.findViewById(R.id.tv_text);
        this.mKtvSweepImageView = (GiftSweepImageView)this.findViewById(R.id.ktv_sweep_img);
    }

    private void hideAllViews() {
        this.mIvLoading.setVisibility(8);
        this.mTvText.setVisibility(8);
        this.mViewSpace.setVisibility(8);
        this.removeSweepAnim();
        if (this.mRotationAnimator != null) {
            this.mRotationAnimator.end();
            this.mRotationAnimator = null;
        }
    }

    public void setChooseSongEnable() {
        this.hideAllViews();
        this.mIvLoading.setVisibility(0);
        this.mTvText.setVisibility(0);
        this.mViewSpace.setVisibility(0);
        this.mIvLoading.setImageResource(R.drawable.ico_ktv_panel_btn_mic);
        this.mTvText.setTextSize(2, 16.0f);
        this.mTvText.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_choose_a_song));
        this.mLayoutParent.setBackgroundResource(R.drawable.ktv_btn_bg_horiz);
        this.startSweepTransAnim();
    }

    public void setChooseSongUnable() {
        this.hideAllViews();
        this.mIvLoading.setVisibility(0);
        this.mTvText.setVisibility(0);
        this.mViewSpace.setVisibility(0);
        this.mIvLoading.setImageResource(R.drawable.ico_ktv_panel_btn_mic);
        this.mTvText.setTextSize(2, 16.0f);
        this.mTvText.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_choose_a_song));
        this.mLayoutParent.setBackgroundResource(R.drawable.ktv_btn_bg_horiz);
        this.startSweepTransAnim();
    }

    public void setSingState() {
        this.hideAllViews();
        this.mTvText.setVisibility(0);
        this.mTvText.setTextSize(2, 18.0f);
        this.mTvText.setText((CharSequence)ResourceUtils.getString((int)R.string.start_capital));
        this.mLayoutParent.setBackgroundResource(R.drawable.ktv_btn_bg_horiz);
        this.removeSweepAnim();
    }

    public void setLoadingState() {
        this.hideAllViews();
        this.mIvLoading.setVisibility(0);
        this.mTvText.setVisibility(0);
        this.mViewSpace.setVisibility(0);
        this.mTvText.setText((CharSequence)ResourceUtils.getString((int)R.string.short_summary_downloading));
        this.mTvText.setTextSize(2, 16.0f);
        this.mIvLoading.setImageResource(R.drawable.ico_ktv_btn_loading);
        this.mLayoutParent.setBackgroundResource(R.drawable.ktv_btn_bg_horiz);
        if (this.mRotationAnimator == null) {
            this.mRotationAnimator = ObjectAnimator.ofFloat((Object)this.mIvLoading, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
            this.mRotationAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mRotationAnimator.setDuration(800L);
            this.mRotationAnimator.setRepeatCount(-1);
            this.mRotationAnimator.setRepeatMode(1);
        }
        this.mRotationAnimator.start();
        this.removeSweepAnim();
    }

    public void setAudienceEndingState() {
        this.hideAllViews();
        this.mIvLoading.setVisibility(0);
        this.mIvLoading.setImageResource(R.drawable.ktv_ending_gift_btn);
        this.mViewSpace.setVisibility(0);
        this.mTvText.setVisibility(0);
        this.mTvText.setTextSize(2, 18.0f);
        this.mTvText.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_ktv_ending_audience_btn));
        this.mLayoutParent.setBackgroundResource(R.drawable.ktv_ending_gift_btn_bg);
        this.setVisibility(0);
        this.removeSweepAnim();
    }

    public void setSingerEndingState() {
        this.hideAllViews();
        this.setVisibility(8);
    }

    public void clearAnimator() {
        if (this.mRotationAnimator != null) {
            this.mRotationAnimator.end();
            this.mRotationAnimator = null;
        }
    }

    private void startSweepTransAnim() {
    }

    private void removeSweepAnim() {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mRotationAnimator != null) {
            this.mRotationAnimator.end();
            this.mRotationAnimator = null;
        }
    }
}

