/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel.view;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.KtvWorksEntranceConfig;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.panel.view.IPanelViewState;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import java.util.Calendar;
import java.util.Date;

public class KTVEndingPanelView
extends YYConstraintLayout
implements IPanelViewState,
View.OnClickListener {
    private YYTextView countdownTv;
    private YYTextView songTv;
    private YYTextView nameTv;
    private CircleImageView avatarIv;
    private YYLinearLayout guideLayout;
    private SVGAImageView clapSvga;
    private View mShareContainer;
    private YYTextView mSaveBtn;
    private YYTextView mShareBtn;
    private View mGiftLayout;
    private RecycleImageView mGiftIv;
    private YYTextView mGiftTv;
    private IEndingPanelListner mListener;
    private KTVRoomSongInfo mSongInfo;
    private AnimatorSet guideAnim;
    private static final int COUNTDOWN = 10;
    private int mLeftTime = 0;
    private boolean isShowing = false;
    private GiftItemInfo mGiftInfo;
    private Runnable countdownTask = new Runnable(){

        @Override
        public void run() {
            if (0 >= KTVEndingPanelView.this.mLeftTime) {
                KTVEndingPanelView.this.isShowing = false;
                if (null != KTVEndingPanelView.this.mListener) {
                    KTVEndingPanelView.this.mListener.onIdleStateEnd();
                }
                return;
            }
            KTVEndingPanelView.this.countdownTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_ktv_ending_coundown, (Object[])new Object[]{KTVEndingPanelView.this.mLeftTime}));
            KTVEndingPanelView.this.mLeftTime--;
            YYTaskExecutor.postToMainThread((Runnable)KTVEndingPanelView.this.countdownTask, (long)1000L);
        }
    };

    public KTVEndingPanelView(Context context) {
        this(context, null);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public KTVEndingPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_ktv_ending_panel_channel, (ViewGroup)this, true);
        this.countdownTv = (YYTextView)this.findViewById(R.id.tv_countdown);
        this.songTv = (YYTextView)this.findViewById(R.id.tv_song_name);
        this.nameTv = (YYTextView)this.findViewById(R.id.tv_nick);
        this.avatarIv = (CircleImageView)this.findViewById(R.id.civ_avatar);
        this.guideLayout = (YYLinearLayout)this.findViewById(R.id.layout_guide);
        this.clapSvga = (SVGAImageView)this.findViewById(R.id.svga_clap);
        this.mShareContainer = this.findViewById(R.id.layout_share_container);
        this.mShareBtn = (YYTextView)this.findViewById(R.id.btn_song_share);
        this.mGiftLayout = this.findViewById(R.id.giftLayout);
        this.mGiftIv = (RecycleImageView)this.findViewById(R.id.giftIv);
        this.mGiftTv = (YYTextView)this.findViewById(R.id.giftTv);
        this.mShareBtn.setOnClickListener((View.OnClickListener)this);
        this.setBackgroundResource(R.drawable.shape_ktv_panel_bg);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.setLayoutParams(lp);
        if (this.isKtvWorksSaveShow()) {
            this.mSaveBtn = (YYTextView)this.findViewById(R.id.btn_song_save);
            this.mSaveBtn.setVisibility(0);
            this.mSaveBtn.setOnTouchListener((v, event) -> {
                if (event.getAction() == 0) {
                    this.mSaveBtn.setAlpha(0.6f);
                }
                if (event.getAction() == 3) {
                    this.mSaveBtn.setAlpha(1.0f);
                }
                if (event.getAction() == 1) {
                    this.mSaveBtn.setAlpha(1.0f);
                    if (null != this.mListener && RepeatClickUtils.canRepeatClick((String)"ktv_works_save_click")) {
                        this.mListener.clickSave();
                    }
                }
                return true;
            });
        }
    }

    public void setShareAndSaveShow(boolean isShow) {
        if (this.mShareContainer == null) {
            return;
        }
        if (this.mSongInfo == null || !this.mSongInfo.isSinger()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"KTVEndingPanelView", (String)"setShareAndSaveShow is not singer", (Object[])new Object[0]);
            }
            return;
        }
        if (isShow) {
            this.mShareContainer.setVisibility(0);
        } else {
            this.mShareContainer.setVisibility(8);
            this.startClapAnim();
        }
    }

    public void setOnEndingPanelListner(IEndingPanelListner listner) {
        this.mListener = listner;
    }

    @Override
    public void onPanelViewShow(boolean isSinger, boolean isPause) {
        if (null == this.mSongInfo) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"show KTVEndingPanelView songInfo=null", (Object[])new Object[0]);
            return;
        }
        this.isShowing = true;
        if (null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)) {
            ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).play("ktv_song_ending_show");
        }
        if (this.mSongInfo.isSinger()) {
            this.guideLayout.setVisibility(8);
            this.mGiftLayout.setVisibility(8);
            this.mShareContainer.setVisibility(0);
        } else {
            this.mShareContainer.setVisibility(8);
            if (this.mGiftLayout.getTag() != null) {
                this.mGiftLayout.setVisibility(0);
            } else {
                this.mGiftLayout.setVisibility(8);
            }
            String guideShowedDay = SettingFlags.getStringValue((String)"key_ktv_ending_gift_guide", (String)"");
            String today = DateUtils.dateToString((Date)Calendar.getInstance().getTime(), (String)"yyyy-MM-dd");
            if (!StringUtils.equal((String)guideShowedDay, (String)today) && this.mGiftLayout.getTag() != null) {
                this.startGuideAnim();
                SettingFlags.setStringValue((String)"key_ktv_ending_gift_guide", (String)today);
            } else {
                this.guideLayout.setVisibility(8);
            }
            this.startClapAnim();
        }
        this.songTv.setText((CharSequence)this.mSongInfo.getSongName());
        this.nameTv.setText((CharSequence)StringUtils.getHtmlText((int)R.string.tips_ktv_ending_singer, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)this.mSongInfo.getNick(), (int)9)}));
        ImageLoader.loadImage((RecycleImageView)this.avatarIv, (String)(this.mSongInfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (Drawable)ResourceUtils.getDrawable((int)R.drawable.profile_default_header));
        this.mLeftTime = 10;
        YYTaskExecutor.postToMainThread((Runnable)this.countdownTask);
    }

    private void startClapAnim() {
        SvgaLoader.load((SVGAImageView)this.clapSvga, (String)"ktv_ending_clap.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
                if (null != KTVEndingPanelView.this.clapSvga) {
                    KTVEndingPanelView.this.clapSvga.startAnimation();
                }
            }

            public void onFailed(Exception e) {
            }
        });
    }

    private void startGuideAnim() {
        if (null == this.guideAnim) {
            this.guideAnim = new AnimatorSet();
            ObjectAnimator translationAnim = ObjectAnimator.ofFloat((Object)this.guideLayout, (String)"translationY", (float[])new float[]{0.0f, 15.0f, 0.0f, -15.0f, 0.0f});
            translationAnim.setDuration(2000L);
            translationAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translationAnim.setRepeatCount(-1);
            PropertyValuesHolder holder1 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
            PropertyValuesHolder holder2 = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.0f, 1.0f});
            PropertyValuesHolder holder3 = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator scaleAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.guideLayout, (PropertyValuesHolder[])new PropertyValuesHolder[]{holder1, holder2, holder3});
            scaleAnim.setDuration(500L);
            this.guideAnim.play((Animator)translationAnim).with((Animator)scaleAnim);
        }
        this.guideAnim.start();
        this.guideLayout.setVisibility(0);
        if (null != this.mListener) {
            this.mListener.guideShow();
        }
    }

    @Override
    public void onPanelViewHide() {
        this.mLeftTime = 0;
        this.isShowing = false;
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.countdownTask);
        if (null != this.guideAnim) {
            this.guideAnim.cancel();
        }
    }

    @Override
    public void onIsPauseState(boolean isPause) {
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_song_share) {
            if (null != this.mListener) {
                this.mListener.clickShare();
            }
        } else if (v.getId() == R.id.giftLayout && null != this.mListener && v.getTag() instanceof GiftItemInfo && this.mSongInfo != null) {
            this.mListener.clickGift(this.mSongInfo, (GiftItemInfo)v.getTag());
        }
    }

    private boolean isKtvWorksSaveShow() {
        KtvWorksEntranceConfig config = (KtvWorksEntranceConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.KTV_WORKS_SAVE_ENTRANCE);
        return config != null && config.getKtvWorksEntranceData() != null && config.getKtvWorksEntranceData().isShow();
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    public void setKTVRoomSongInfo(KTVRoomSongInfo mSongInfo) {
        this.mSongInfo = mSongInfo;
    }

    public void setGiftInfo(@Nullable GiftItemInfo giftInfo) {
        if (giftInfo == null) {
            this.mGiftLayout.setTag(null);
            this.mGiftLayout.setOnClickListener(null);
            this.mGiftLayout.setVisibility(8);
        } else {
            this.mGiftLayout.setTag((Object)giftInfo);
            ImageLoader.loadImage((RecycleImageView)this.mGiftIv, (String)(giftInfo.getStaticIcon() + YYImageUtils.getThumbnailPostfix((int)75)));
            this.mGiftTv.setText((CharSequence)String.valueOf(GiftUtils.giftPrice((GiftItemInfo)giftInfo)));
            this.mGiftLayout.setOnClickListener((View.OnClickListener)this);
        }
    }

    public static interface IEndingPanelListner {
        public void onIdleStateEnd();

        public void clickSendGift(long var1);

        public void guideShow();

        public void clickSave();

        public void clickShare();

        public void clickGift(KTVRoomSongInfo var1, GiftItemInfo var2);
    }
}

