/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.history;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.IPanelHideListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ISelectSongListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.history.KTVHistoryMvp;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.history.KTVHistoryView;
import com.yy.hiyo.channel.plugins.ktv.model.songList.KTVMusicListProvider;
import com.yy.hiyo.mvp.base.BasePresenter;
import java.util.List;

public class KTVHistoryPresenter
extends BasePresenter
implements KTVHistoryMvp.IPresenter,
IPanelHideListener {
    private Context mContext;
    private ViewGroup mWrapper;
    private KTVHistoryView mView;
    private IKTVHandler mKtvHandler;
    private ISelectSongListener mSelectSongListener;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public KTVHistoryPresenter(Context context, IKTVHandler ktvHandler, ViewGroup wrapper) {
        this.mContext = context;
        this.mWrapper = wrapper;
        this.mKtvHandler = ktvHandler;
    }

    @Override
    public void showView() {
        this.mView = new KTVHistoryView(this.mContext);
        this.mView.setPresenter(this);
        this.mView.setOnSelectSongListener(this.mSelectSongListener);
        this.mWrapper.addView((View)this.mView);
        this.mBinder.singleBindSourceTo((KvoSource)((KTVMusicListProvider)this.mKtvHandler.getKTVManager().getKTVMusicListProvider()));
    }

    @Override
    public void onPanelHiden() {
        if (null != this.mWrapper && null != this.mView) {
            this.mWrapper.removeView((View)this.mView);
            this.mView = null;
        }
        this.mBinder.clearAllKvoConnections();
    }

    @KvoMethodAnnotation(sourceClass=KTVMusicListProvider.class, name="historyDataChanged")
    public void onHistoryChanged(KvoEventIntent data) {
        final List<KTVMusicInfo> list = ((KTVMusicListProvider)data.source()).getMusicHistoryList();
        if (YYTaskExecutor.isMainThread()) {
            if (this.mView != null) {
                this.mView.updateHistory(list);
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (KTVHistoryPresenter.this.mView != null) {
                        KTVHistoryPresenter.this.mView.updateHistory(list);
                    }
                }
            });
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mBinder.clearAllKvoConnections();
    }

    public void setOnSelectSongListener(ISelectSongListener listener) {
        this.mSelectSongListener = listener;
    }
}

