/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.songlist;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.list.songlist.KTVSongListDiffCallback;
import java.util.ArrayList;
import java.util.List;

public class KTVSongListAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private Context mContext;
    private IKTVHandler mHandler;
    private OnItemClickListener mListener;
    private List<KTVRoomSongInfo> mData;

    public KTVSongListAdapter(Context context, @NonNull IKTVHandler handler) {
        this.mContext = context;
        this.mHandler = handler;
        this.mData = new ArrayList<KTVRoomSongInfo>();
    }

    public void setOnClickListener(OnItemClickListener listener) {
        this.mListener = listener;
    }

    public void setData(List<KTVRoomSongInfo> list) {
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new KTVSongListDiffCallback(this.mData, list), (boolean)true);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
        this.mData = list;
    }

    public int getItemCount() {
        if (!FP.empty(this.mData)) {
            return this.mData.size();
        }
        return 0;
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_song_list_channel, parent, false);
        MyViewHolder viewHolder = new MyViewHolder(view);
        return viewHolder;
    }

    public void onBindViewHolder(final @NonNull MyViewHolder holder, int position) {
        final KTVRoomSongInfo songInfo = this.mData.get(position);
        if (position == this.mData.size() - 1) {
            holder.tvBottom.setVisibility(0);
        } else {
            holder.tvBottom.setVisibility(8);
        }
        if (songInfo != null) {
            holder.tvNumber.setText((CharSequence)String.valueOf(position + 1));
            ImageLoader.loadImage((RecycleImageView)holder.civAvatar, (String)(songInfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)));
            StringBuilder title = new StringBuilder(songInfo.getSongName() == null ? "" : songInfo.getSongName()).append(" - ").append(songInfo.getOriginalSinger());
            holder.tvSongTitle.setText((CharSequence)title.toString());
            holder.tvSinger.setText((CharSequence)songInfo.getNick());
            if ((songInfo.getStatus() == 1 || songInfo.getStatus() == 2 || songInfo.getStatus() == 0) && position == 0) {
                holder.svgaPlaying.setVisibility(0);
                holder.clBtnContainer.setVisibility(0);
                holder.ivDelete.setVisibility(8);
                holder.ivSetTop.setVisibility(8);
                SvgaLoader.load((SVGAImageView)holder.svgaPlaying, (String)"playing_wave.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity entity) {
                        if (holder.svgaPlaying != null) {
                            holder.svgaPlaying.startAnimation();
                        }
                    }

                    public void onFailed(Exception e) {
                    }
                });
            } else if (this.mHandler.getmRoomDataContainer().isPlayManager(AccountUtil.getUid())) {
                holder.svgaPlaying.setVisibility(8);
                holder.svgaPlaying.stopAnimation();
                holder.clBtnContainer.setVisibility(0);
                holder.ivDelete.setVisibility(0);
                if (position == 1) {
                    holder.ivSetTop.setVisibility(8);
                } else {
                    holder.ivSetTop.setVisibility(0);
                }
            } else if (songInfo.getUid() == AccountUtil.getUid()) {
                holder.svgaPlaying.setVisibility(8);
                holder.svgaPlaying.stopAnimation();
                holder.clBtnContainer.setVisibility(0);
                holder.ivDelete.setVisibility(0);
                holder.ivSetTop.setVisibility(8);
            } else {
                holder.svgaPlaying.stopAnimation();
                holder.clBtnContainer.setVisibility(8);
            }
            holder.ivSetTop.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (KTVSongListAdapter.this.mListener != null) {
                        KTVSongListAdapter.this.mListener.onItemSetTop(songInfo);
                    }
                }
            });
            holder.ivDelete.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (KTVSongListAdapter.this.mListener != null) {
                        KTVSongListAdapter.this.mListener.onItemDelete(songInfo);
                    }
                }
            });
        }
    }

    static interface OnItemClickListener {
        public void onItemDelete(KTVRoomSongInfo var1);

        public void onItemSetTop(KTVRoomSongInfo var1);
    }

    class MyViewHolder
    extends RecyclerView.ViewHolder {
        public YYTextView tvBottom;
        public YYTextView tvNumber;
        public YYTextView tvSongTitle;
        public YYTextView tvSinger;
        public YYImageView ivDelete;
        public YYImageView ivSetTop;
        public SVGAImageView svgaPlaying;
        public CircleImageView civAvatar;
        public ConstraintLayout clBtnContainer;

        public MyViewHolder(View view) {
            super(view);
            this.tvBottom = (YYTextView)view.findViewById(R.id.tv_bottom);
            this.tvNumber = (YYTextView)view.findViewById(R.id.tv_number);
            this.ivDelete = (YYImageView)view.findViewById(R.id.iv_delete);
            this.ivSetTop = (YYImageView)view.findViewById(R.id.iv_set_top);
            this.civAvatar = (CircleImageView)view.findViewById(R.id.civ_cover);
            this.tvSinger = (YYTextView)view.findViewById(R.id.tv_singer);
            this.tvSongTitle = (YYTextView)view.findViewById(R.id.tv_song_title);
            this.svgaPlaying = (SVGAImageView)view.findViewById(R.id.svga_playing);
            this.clBtnContainer = (ConstraintLayout)view.findViewById(R.id.cl_btn_container);
            FontUtils.setFontType((TextView)this.tvNumber, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        }
    }
}

