/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.web;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import java.util.List;

public class SendLikeJsEvent
implements JsEvent {
    private static final String TAG = "SendLikeJsEvent";
    private final JsEventControllerCallback mControllerCallback;

    public SendLikeJsEvent(@NonNull JsEventControllerCallback callback) {
        this.mControllerCallback = callback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.IM.sendIMLikeMessage;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            this.callbackErr(callback, 0, "paramJson is null");
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                SendLikeJsEvent.this.sendLike(param, callback);
            }
        });
    }

    private void sendLike(@NonNull String paramJson, final @Nullable IJsEventCallback callback) {
        final LikeParam param = (LikeParam)JsonParser.parseJsonObject((String)paramJson, LikeParam.class);
        if (param != null) {
            final long uid = param.uid;
            if (uid <= 0L) {
                this.callbackErr(callback, 0, "uid is illegal");
                return;
            }
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    UserInfoKS userInfo;
                    if (FP.empty(userInfoKSList) || (userInfo = userInfoKSList.get(0)) == null || userInfo.uid != uid) {
                        SendLikeJsEvent.this.callbackErr(callback, 0, "request user info failed with uid " + uid);
                        return;
                    }
                    YYTaskExecutor.execute(() -> {
                        Pair pair = ImDataFactory.INSTANCE.emojiLikeMsg(param2.content, uid, userInfo.avatar, userInfo.nick, param2.gameId);
                        ((ImService)SendLikeJsEvent.this.mControllerCallback.getService().getService(ImService.class)).getSendService().sendOldIMToDbMsg((ImMsgReqParam)pair.first, (ImMessageDBBean)pair.second, null);
                    });
                    ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("send_message"));
                }

                public void onFail(int id2, String msg, String response) {
                    SendLikeJsEvent.this.callbackErr(callback, 0, "request user info failed with uid " + uid + ", response: " + response);
                }

                public int id() {
                    return 0;
                }
            });
        } else {
            this.callbackErr(callback, 0, "paramJson is illegal");
        }
    }

    private void callbackErr(@Nullable IJsEventCallback callback, int code, String msg) {
        if (callback != null) {
            BaseJsParam err = BaseJsParam.errorParam((int)code, (String)msg);
            callback.callJs((IJsParam)err);
        }
    }

    static class LikeParam {
        @SerializedName(value="uid")
        long uid;
        @SerializedName(value="gameId")
        String gameId;
        @SerializedName(value="content")
        String content;

        LikeParam() {
        }
    }
}

