/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.window;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.im.R;
import com.yy.im.interfaces.OnItemDataClickListener;
import com.yy.im.interfaces.OnItemDataLongClickListener;
import com.yy.im.model.ChatSession;
import com.yy.im.model.GamePublicEntranceSession;
import com.yy.im.model.OfficialAccountEntranceSession;
import com.yy.im.ui.component.ChatSessionListComponent;
import java.util.List;

public class GamePublicSessionWindow
extends DefaultWindow {
    private ChatSessionListComponent viewComponent;
    private MutableLiveData<List<ChatSession>> mSessions;
    private YYFrameLayout container;
    private ChatSession mChatSession;
    private Observer<List<ChatSession>> mObserver = new Observer<List<ChatSession>>(){

        public void onChanged(@Nullable List<ChatSession> chatSessions) {
            if (GamePublicSessionWindow.this.container == null) {
                return;
            }
            GamePublicSessionWindow.this.container.removeAllViews();
            if (chatSessions != null && !chatSessions.isEmpty()) {
                GamePublicSessionWindow.this.container.addView(GamePublicSessionWindow.this.viewComponent.getRoot());
            }
        }
    };

    public GamePublicSessionWindow(Context context, final UICallBacks callBacks, OnItemDataClickListener listener, MutableLiveData<List<ChatSession>> sessions, ChatSession chatSession, OnItemDataLongClickListener longClickListener) {
        super(context, callBacks, "GamePublicSession");
        LayoutInflater.from((Context)context).inflate(R.layout.im_stranger_session_window, this.getBaseLayer());
        SimpleTitleBar stb = (SimpleTitleBar)this.findViewById(R.id.stb);
        stb.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                if (callBacks != null) {
                    callBacks.onWindowExitEvent(true);
                }
            }
        });
        this.mChatSession = chatSession;
        if (chatSession instanceof GamePublicEntranceSession) {
            stb.setLeftTitle(ResourceUtils.getString((int)R.string.title_subscribe_official_msg_dialog));
        } else if (chatSession instanceof OfficialAccountEntranceSession) {
            stb.setLeftTitle(ResourceUtils.getString((int)R.string.title_activity_account));
        }
        this.mSessions = sessions;
        this.container = (YYFrameLayout)this.findViewById(R.id.fl_container);
        this.viewComponent = new ChatSessionListComponent(context, (ViewGroup)this.container, listener, (LiveData<List<ChatSession>>)this.mSessions, longClickListener, ((ImModule)KvoModuleManager.getModule(ImModule.class)).getSessionMsgUIMapper(1), 1);
        this.mSessions.observe((LifecycleOwner)context, this.mObserver);
    }

    public void onShown() {
        super.onShown();
    }

    public void onDetached() {
        super.onDetached();
        if (this.mSessions != null) {
            this.mSessions.removeObserver(this.mObserver);
            this.mSessions = null;
        }
        if (this.viewComponent != null) {
            this.viewComponent.onWindowDetach();
        }
        this.container = null;
        if (this.mChatSession instanceof GamePublicEntranceSession) {
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_CLEAR_AUTO_DOWNLOAD_GAMEID);
        }
    }

    public void onAttach() {
        super.onAttach();
        if (this.viewComponent != null) {
            this.viewComponent.onWindowAttach();
        }
    }
}

