/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.component;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import androidx.databinding.DataBindingUtil;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.logger.MLog;
import com.yy.im.R;
import com.yy.im.databinding.ImFriendListComponentBinding;
import com.yy.im.interfaces.IComponent;
import com.yy.im.model.ContactQuizEntranceItem;
import com.yy.im.model.IContact;
import com.yy.im.ui.adapter.ContactAdapter;
import com.yy.im.viewmodel.FriendListViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class FriendListComponent
implements IComponent {
    private View mRoot;
    private PullToRefreshListView mFriendList;
    private ContactAdapter mAdapter;

    public FriendListComponent(Context context, ViewGroup root2, FriendListViewModel vm) {
        ImFriendListComponentBinding binding = (ImFriendListComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.im_friend_list_component, (ViewGroup)root2, (boolean)false);
        this.mRoot = binding.getRoot();
        this.mFriendList = binding.lvFriends;
        this.mFriendList.setMode(PullToRefreshBase.Mode.DISABLED);
        this.mAdapter = new ContactAdapter(vm.getFriends());
        binding.setAdapter(this.mAdapter);
        ((ListView)this.mFriendList.getRefreshableView()).setSelector(17170445);
    }

    @Override
    public View getRoot() {
        return this.mRoot;
    }

    @Override
    public void onWindowAttach() {
        AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (aConfigData != null && aConfigData instanceof CommonConfig) {
            CommonConfig contactQuizConfig = (CommonConfig)aConfigData;
            CommonConfigData commonConfigData = contactQuizConfig.getData();
            if (commonConfigData != null && commonConfigData.contactQuizSwitch == 1) {
                if (this.mAdapter != null && this.mAdapter.getDatas() != null) {
                    int count = this.mAdapter.getDatas().size();
                    if (count == 1) {
                        this.mAdapter.getDatas().add(1, (Object)new ContactQuizEntranceItem());
                        this.mAdapter.notifyDataSetChanged();
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028337").put("function_id", "ent_show").put("ent_id", "2"));
                    } else if (count > 1) {
                        IContact iContact = (IContact)this.mAdapter.getDatas().get(1);
                        if (!(iContact instanceof ContactQuizEntranceItem)) {
                            this.mAdapter.getDatas().add(1, (Object)new ContactQuizEntranceItem());
                            this.mAdapter.notifyDataSetChanged();
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028337").put("function_id", "ent_show").put("ent_id", "2"));
                        } else {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028337").put("function_id", "ent_show").put("ent_id", "2"));
                        }
                    }
                }
            } else if (commonConfigData == null) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"FriendListComponent", (String)"commonConfigData is null", (Object[])new Object[0]);
                }
            } else if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"FriendListComponent", (String)("commonConfigData.contactQuizSwitchcommon" + commonConfigData.contactQuizSwitch), (Object[])new Object[0]);
            }
        } else if (aConfigData == null) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"FriendListComponent", (String)"aConfigData is null", (Object[])new Object[0]);
            }
        } else if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"FriendListComponent", (String)"aConfigData is not CommonConfig", (Object[])new Object[0]);
        }
    }

    @Override
    public void onWindowDetach() {
        if (this.mAdapter != null) {
            this.mAdapter.onDestroy();
        }
    }
}

