/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.widget.GameDownloadingView;
import com.yy.im.R;
import com.yy.im.interfaces.IGameInviteListener;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImDrawerGameListAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private static final String TAG = "ImDrawerGameListAdapter";
    private List<GameInfo> mDatas = new ArrayList<GameInfo>(0);
    private long lastTimeMillis;
    private static final long MIN_CLICK_INTERVAL = 1000L;
    private boolean mIsSlidingOpen;
    protected int mItemLayoutId = this.getLayoutId();
    public static final int TYPE_OLD = 0;
    public static final int TYPE_NEW = 1;
    private int mType = 0;
    protected Pair<Integer, Integer> mExpectImageSize = new Pair((Object)ResolutionUtils.dip2Px((float)100.0f), (Object)ResolutionUtils.dip2Px((float)80.0f));
    private IGameInviteListener mGameInviteListener;
    private HashMap<String, Boolean> mDownloadingMap = new HashMap();
    private HashMap<String, Boolean> mSendGameInviteMap = new HashMap();

    public ImDrawerGameListAdapter(List<GameInfo> data2) {
        this(data2, 0);
    }

    public ImDrawerGameListAdapter(List<GameInfo> data2, int type) {
        if (data2 == null || data2.isEmpty()) {
            return;
        }
        this.mDatas.addAll(data2);
        this.mType = type;
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(this.mItemLayoutId, viewGroup, false);
        return new MyViewHolder(view);
    }

    public void onBindViewHolder(@NonNull MyViewHolder myViewHolder, final int position) {
        GameInfo gameInfo = this.mDatas.get(position);
        if (gameInfo == null) {
            return;
        }
        if (!this.isNewType() && myViewHolder.mLeftSpace != null && myViewHolder.mRightSpace != null && myViewHolder.mTopSpace != null) {
            if (position == 0 || position == 1) {
                myViewHolder.mTopSpace.setVisibility(0);
            } else {
                myViewHolder.mTopSpace.setVisibility(8);
            }
            if (position % 2 == 0) {
                myViewHolder.mLeftSpace.setVisibility(0);
                myViewHolder.mRightSpace.setVisibility(8);
            } else {
                myViewHolder.mLeftSpace.setVisibility(8);
                myViewHolder.mRightSpace.setVisibility(0);
            }
        }
        ImageLoader.loadImage((ImageView)myViewHolder.mGameIcon, (String)(gameInfo.getImIconUrl() + YYImageUtils.getThumbnailPostfixPx((int)((Integer)this.mExpectImageSize.first), (int)((Integer)this.mExpectImageSize.second), (boolean)true)));
        myViewHolder.mTvGamename.setText((CharSequence)gameInfo.getGname());
        myViewHolder.setSendingInvite(gameInfo, this.isSendingInvite(gameInfo.getGid()));
        myViewHolder.setDownloadState(gameInfo, this.isDownloading(gameInfo.getGid()));
        myViewHolder.mRlytGameIcon.setTag((Object)position);
        myViewHolder.mRlytGameIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(final View v) {
                if (!ImDrawerGameListAdapter.this.isTimeEnabled()) {
                    return;
                }
                GameInfo gameInfo = (GameInfo)ImDrawerGameListAdapter.this.mDatas.get((Integer)v.getTag());
                if (gameInfo == null) {
                    return;
                }
                MLog.info((Object)ImDrawerGameListAdapter.TAG, (String)"on pk click! gameId=%s", (Object[])new Object[]{gameInfo.getGid()});
                if (gameInfo.isBetaTest()) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_beta_test_game), (int)1);
                } else {
                    if (gameInfo.isFull()) {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)1);
                        return;
                    }
                    if (gameInfo.isFixing()) {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)1);
                        return;
                    }
                }
                if (ImDrawerGameListAdapter.this.isDownloading(gameInfo.getGid())) {
                    return;
                }
                if (ImDrawerGameListAdapter.this.isSendingInvite(gameInfo.getGid())) {
                    return;
                }
                v.setEnabled(false);
                v.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        v.setEnabled(true);
                    }
                }, 1000L);
                int rowId = 0;
                int columnId = 0;
                if (ImDrawerGameListAdapter.this.mGameInviteListener != null) {
                    if (ImDrawerGameListAdapter.this.isNewType()) {
                        rowId = position / 4 + 1;
                        columnId = position % 4 + 1;
                    } else {
                        rowId = position / 2 + 1;
                        columnId = position % 2 == 0 ? 1 : 2;
                    }
                    ImDrawerGameListAdapter.this.mGameInviteListener.sendInvite(gameInfo, rowId, columnId, 2);
                }
                if (!ImDrawerGameListAdapter.this.isNewType()) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "sliding_game_invite_click").put("gid", gameInfo.getGid()).put("more_show_type", ImDrawerGameListAdapter.this.mIsSlidingOpen ? "2" : "1"));
                }
            }
        });
    }

    protected boolean isTimeEnabled() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastTimeMillis > 1000L) {
            this.lastTimeMillis = currentTimeMillis;
            return true;
        }
        return false;
    }

    public int getItemCount() {
        return this.mDatas == null ? 10 : this.mDatas.size();
    }

    public void updateData(List<GameInfo> data2) {
        if (data2 == null || data2.isEmpty()) {
            return;
        }
        this.mDatas.clear();
        this.mDatas.addAll(data2);
        this.notifyDataSetChanged();
    }

    public void setGameInviteListener(IGameInviteListener listener) {
        this.mGameInviteListener = listener;
    }

    public void setDrawerOpenWay(boolean isLeftSlidingOpen) {
        this.mIsSlidingOpen = isLeftSlidingOpen;
    }

    private boolean isDownloading(String gid) {
        boolean ret = false;
        if (this.mDownloadingMap.containsKey(gid) && this.mDownloadingMap.get(gid).booleanValue()) {
            ret = true;
        }
        return ret;
    }

    private boolean isSendingInvite(String gid) {
        boolean ret = false;
        if (this.mSendGameInviteMap.containsKey(gid) && this.mSendGameInviteMap.get(gid).booleanValue()) {
            ret = true;
        }
        return ret;
    }

    public void startDownloadGame(GameInfo gameInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid())) {
            return;
        }
        int index = this.getGameInfo(gameInfo.getGid());
        if (index == -1) {
            return;
        }
        this.mDownloadingMap.put(gameInfo.getGid(), true);
        this.notifyItemChanged(index, 1);
    }

    public void gameDownloadFailed(BasicGameInfo gameInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid())) {
            return;
        }
        int index = this.getGameInfo(gameInfo.getGid());
        if (index == -1) {
            return;
        }
        this.mDownloadingMap.put(gameInfo.getGid(), false);
        this.notifyItemChanged(index, 1);
    }

    public void gameDownloadSucceed(GameInfo gameInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid())) {
            return;
        }
        int index = this.getGameInfo(gameInfo.getGid());
        if (index == -1) {
            return;
        }
        this.mDownloadingMap.put(gameInfo.getGid(), false);
        this.notifyItemChanged(index, 1);
    }

    public void setSendingInviteState(String gameId, boolean sendingInvite) {
        if (StringUtils.isEmpty((String)gameId)) {
            return;
        }
        int index = this.getGameInfo(gameId);
        if (index == -1) {
            return;
        }
        this.mSendGameInviteMap.put(gameId, sendingInvite);
        this.notifyItemChanged(index, 1);
    }

    private int getGameInfo(String gid) {
        int index = -1;
        for (int i = 0; i < this.mDatas.size(); ++i) {
            if (this.mDatas.get(i) == null || TextUtils.isEmpty((CharSequence)this.mDatas.get(i).getGid()) || !this.mDatas.get(i).getGid().equals(gid)) continue;
            index = i;
            break;
        }
        return index;
    }

    private boolean isNewType() {
        return this.mType == 1;
    }

    protected int getLayoutId() {
        return R.layout.item_drawer_game_list;
    }

    protected boolean isImBottomGameList() {
        return false;
    }

    protected Pair<Integer, Integer> getImageExpectSize() {
        return this.mExpectImageSize;
    }

    class MyViewHolder
    extends RecyclerView.ViewHolder {
        public View mRlytGameIcon;
        public RecycleImageView mGameIcon;
        public YYTextView mTvGamename;
        public YYTextView mTvGameStatus;
        private ProgressBar mProgressBar;
        private GameDownloadingView mDownloadingView;
        private View mTopSpace;
        private View mLeftSpace;
        private View mRightSpace;

        MyViewHolder(View itemView) {
            super(itemView);
            this.mRlytGameIcon = itemView.findViewById(R.id.rlyt_game_icon);
            this.mGameIcon = (RecycleImageView)itemView.findViewById(R.id.rciv_icon);
            this.mTvGamename = (YYTextView)itemView.findViewById(R.id.tv_game_name);
            this.mTvGameStatus = (YYTextView)itemView.findViewById(R.id.tv_game_status);
            this.mProgressBar = (ProgressBar)itemView.findViewById(R.id.loading_pb);
            this.mDownloadingView = (GameDownloadingView)itemView.findViewById(R.id.game_download_view);
            if (!ImDrawerGameListAdapter.this.isNewType()) {
                this.mTopSpace = itemView.findViewById(R.id.view_top_space);
                this.mLeftSpace = itemView.findViewById(R.id.view_left_space);
                this.mRightSpace = itemView.findViewById(R.id.view_right_space);
            }
            this.mProgressBar.setIndeterminateDrawable(ResourceUtils.getDrawable((int)R.drawable.im_send_game_invite_loading_pb));
            if (ImDrawerGameListAdapter.this.isImBottomGameList()) {
                int width = ResolutionUtils.dip2Px((float)42.0f);
                this.mDownloadingView.setMarkBackground(-1291845632);
                this.mDownloadingView.setType(2);
                this.mDownloadingView.setProgressBarWidth(width);
                this.mDownloadingView.setDefaultProgressBarWidth(width);
                this.mDownloadingView.setDefaultLightWidth(width);
                this.mDownloadingView.setProgressShow(false);
            } else {
                int width = ResolutionUtils.dip2Px((float)75.0f);
                this.mDownloadingView.setProgressTextSize(10.0f);
                this.mDownloadingView.setProgressSizeTextSize(10.0f);
                this.mDownloadingView.setType(2);
                this.mDownloadingView.setProgressBarWidth(width);
                this.mDownloadingView.setDefaultProgressBarWidth(width);
                this.mDownloadingView.setMarkBackground(-1291845632);
                this.mDownloadingView.setSimpleProgressSize(true);
                this.mDownloadingView.setDefaultLightWidth(ResolutionUtils.dip2Px((float)195.0f));
            }
        }

        public void setDownloadState(GameInfo gameInfo, boolean downloading) {
            this.mDownloadingView.setGameInfo(gameInfo);
        }

        public void setSendingInvite(GameInfo gameInfo, boolean sendingInvite) {
            if (gameInfo.isFixing()) {
                this.mTvGameStatus.setVisibility(0);
                this.mTvGameStatus.setText((CharSequence)ResourceUtils.getString((int)R.string.maintaining));
            } else if (gameInfo.isFull()) {
                this.mTvGameStatus.setVisibility(0);
                this.mTvGameStatus.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_full));
            } else {
                this.mTvGameStatus.setVisibility(8);
            }
            this.mProgressBar.setVisibility(sendingInvite ? 0 : 8);
        }
    }
}

