/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.SubAccountDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameOfficialMsgService;
import com.yy.hiyo.game.service.callback.IGameOfficialUnsubscribeListener;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.im.ImEventReporter;
import com.yy.im.ImModuleData;
import com.yy.im.R;
import com.yy.im.hiido.OfficialDataReportManager;
import com.yy.im.model.ChatSession;
import com.yy.im.model.GamePublicChatSession;
import com.yy.im.model.GamePublicEntranceSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.oas.AosConfig;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.ImOasSessionBean;
import com.yy.im.session.bean.ImOasSessionBeanKt;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import java.util.ArrayList;
import java.util.List;
import net.ihago.base.api.subaccount.GetMySubAccountsResp;
import net.ihago.base.api.subaccount.SAInfoStatus;
import net.ihago.base.api.subaccount.SAType;
import net.ihago.base.api.subaccount.SubAccountInfo;

public class GamePublicSessionPresenter
extends BaseSessionPresenter
implements IGameOfficialUnsubscribeListener {
    private static final String TAG = "GamePublicSessionPresenter";
    private SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(7, ImMessageDBBean.class, GamePublicChatSession.class);

    @Override
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    public long getUserUid(ChatSession temp) {
        return 0L;
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
        GamePublicChatSession gamePublicChatSession = (GamePublicChatSession)chatSession;
        ImMessageDBBean msg = (ImMessageDBBean)gamePublicChatSession.getLastMessage();
        if (msg == null) {
            return;
        }
        boolean entryPage = this.mISessionCallback.isShowGamePublicEntrance();
        int page2 = entryPage ? 2 : 1;
        OfficialDataReportManager.INSTANCE.reportMsgClick(msg.getReserve1(), msg.getReserve3(), "1", entryPage, page2, msg.getJumpType(), chatSession.getUnReadCounts());
        if (msg.getJumpType() == 2) {
            Message message = Message.obtain();
            message.what = ImBaseMsgDef.MSG_OPEN_OFFICIAL_ACCOUNT_WINDOW;
            AosConfig config = AosConfig.fromGame(msg);
            if (config != null) {
                message.obj = config;
                MsgDispatcher.getInstance().sendMessage(message);
            } else {
                MLog.error((Object)TAG, (String)"config is null", (Object[])new Object[0]);
            }
        } else {
            this.joinGame(gamePublicChatSession);
        }
    }

    @Override
    public void handleLongClickItem(ChatSession chatSession, View v, int position, int from) {
        this.showDialogBottom(chatSession);
    }

    private void showDialogBottom(ChatSession session) {
        ArrayList<ButtonItem> buttonList = new ArrayList<ButtonItem>();
        ButtonItem deleteButton2 = this.getCommonDeleteBtnItem(() -> {
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "1");
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
            this.clearAutoDownloadFlag(session);
            this.reportDeleteClick(session);
            this.deleteMsg(session);
        });
        ButtonItem ignoreButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.button_ignore_unread), () -> {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (Object)session.getSessionId()));
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "2");
        });
        if (session instanceof SingleChatSession) {
            buttonList.add(deleteButton2);
            if (session.getUnReadCounts() > 0) {
                buttonList.add(ignoreButton2);
            }
        } else if (session instanceof GamePublicChatSession) {
            GamePublicChatSession gamePublicChatSession = (GamePublicChatSession)session;
            String gameId = ((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getReserve1();
            String subAccountId = ((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getReserve2();
            ButtonItem joinGameButton = new ButtonItem(ResourceUtils.getString((int)R.string.tips_short_join_game), () -> {
                ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "3");
                this.joinGame((GamePublicChatSession)session);
                ImEventReporter.INSTANCE.reportEnterGameClick(gameId);
            });
            ButtonItem unFollowButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.tips_short_unfollow), () -> {
                ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "7");
                ((IGameOfficialMsgService)ServiceManagerProxy.getServiceManager().getService(IGameOfficialMsgService.class)).unSubscribe(subAccountId, gameId, null);
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
                this.clearAutoDownloadFlag(session);
                OfficialDataReportManager.INSTANCE.reportMsgBackClick(gameId, ((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getReserve3(), "1");
                ImEventReporter.INSTANCE.reportUnFollowClick(gameId);
                this.deleteMsg(session);
            });
            ButtonItem feedbackButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.tips_short_qus_fb), () -> {
                ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "6");
                MsgDispatcher.getInstance().sendMessage(MixBaseMsgDef.SHOW_WINDOW_FEEDBACK, 2, 11, null);
                ImEventReporter.INSTANCE.reportFeedbackClick(gameId);
            });
            ButtonItem msgNotifyButton2 = new ButtonItem(this.getGameMsgNotifySwitch(session), () -> {
                if (session.getUnReadType() == 0) {
                    ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "4");
                    session.setUnReadType(1);
                } else {
                    session.setUnReadType(0);
                    ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "5");
                }
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession(session.getSessionId());
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateGamePublicSession((Object)session);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
                ImEventReporter.INSTANCE.reportTurnOffNotificationClick(gameId);
            });
            buttonList.add(joinGameButton);
            buttonList.add(deleteButton2);
            buttonList.add(msgNotifyButton2);
            buttonList.add(feedbackButton2);
            buttonList.add(unFollowButton2);
        } else if (session.getUnReadCounts() > 0) {
            buttonList.add(ignoreButton2);
        } else {
            return;
        }
        this.mDialogLinkManager.showCommonPopupDialog(DialogId.GamePublicSessonButtonDialog, buttonList, true, true);
    }

    private void reportDeleteClick(ChatSession session) {
        if (session instanceof GamePublicChatSession) {
            GamePublicChatSession chatSession = (GamePublicChatSession)session;
            ImEventReporter.INSTANCE.reportDeleteClick(((ImMessageDBBean)chatSession.getLastMessage()).getReserve1());
        }
    }

    private void deleteMsg(ChatSession session) {
        if (session instanceof GamePublicChatSession) {
            GamePublicChatSession chatSession = (GamePublicChatSession)session;
            Message message = Message.obtain();
            message.what = ImBaseMsgDef.MSG_REMOVE_OFFICIAL_ACCOUNT_MSG;
            message.obj = ((ImMessageDBBean)chatSession.getLastMessage()).getReserve2();
            MsgDispatcher.getInstance().sendMessage(message);
        }
    }

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_ENTER_GAME_PUBLIC_SESSION, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_EXIT_GAME_PUBLIC_SESSION, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_OFFICIAL_ACCOUNT_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GamePublicSessionPresenter.this.requestSubAccountInfo();
            }
        }, (long)2000L);
        ServiceManagerProxy.getServiceManager().observeService(IGameOfficialMsgService.class, service2 -> service2.addUnSubscribeListener((IGameOfficialUnsubscribeListener)this));
    }

    @Override
    public void notify(Notification notification) {
        if (notification.id == ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE) {
            List list;
            Object msgs = notification.extObj;
            if (msgs instanceof ImMessageDBBean) {
                this.onReceiveImMessage((ImMessageDBBean)msgs);
            } else if (msgs instanceof List && !(list = (List)msgs).isEmpty()) {
                for (ImMessageDBBean msg : list) {
                    this.onReceiveImMessage(msg);
                }
            }
        } else if (notification.id == ImNotificationDef.IM_ENTER_GAME_PUBLIC_SESSION) {
            KvoSource moduleData = KvoModuleManager.getModuleData(ImModule.class);
            if (moduleData instanceof ImModuleData) {
                ((ImModuleData)moduleData).mGamePublicSessionUnread.setSuperUnread(false);
            }
        } else if (notification.id == ImNotificationDef.IM_EXIT_GAME_PUBLIC_SESSION) {
            ChatSession session = this.getTargetSession("-6");
            if (session instanceof GamePublicEntranceSession) {
                KvoSource moduleData = KvoModuleManager.getModuleData(ImModule.class);
                if (moduleData instanceof ImModuleData) {
                    session.setUnReadCounts(((ImModuleData)moduleData).mGamePublicSessionUnread.getCount());
                }
                this.mISessionCallback.updateNormalSession(session);
            }
        } else if (notification.id == ImNotificationDef.IM_RECEIVE_OFFICIAL_ACCOUNT_MSG) {
            ImMessageDBBean msgDb = ImOasSessionBeanKt.transOasToMsgDb((ImOasSessionBean)notification.extObj);
            this.onReceiveImMessage(msgDb);
        } else if (notification.id == ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD) {
            ChatSession session = this.getTargetSession("-6");
            if (session != null) {
                session.setUnReadCounts(0);
            }
        } else if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED && AccountUtil.getUid() > 0L) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GamePublicSessionPresenter.this.requestSubAccountInfo();
                }
            }, (long)2000L);
        }
    }

    private void onReceiveImMessage(ImMessageDBBean msg) {
        if (this.messageFilter(msg)) {
            return;
        }
        ImMessageDBBean transformBean = this.transformBean(msg);
        ImMessageDBBean copy = ImMessageDBBean.copy((ImMessageDBBean)transformBean);
        if (TextUtils.isEmpty((CharSequence)copy.getSessionId())) {
            return;
        }
        OfficialDataReportManager.INSTANCE.reportMsgUp(copy.getReserve1(), copy.getReserve3(), "1", this.mISessionCallback.isShowGamePublicEntrance(), 0);
        String oldSessionId = Utils.appendGameSessionId((String)copy.getSessionId(), (String)copy.getReserve1());
        ChatSession oldSession = this.getTargetSession(oldSessionId);
        if (oldSession != null) {
            this.mISessionCallback.deleteSession(oldSession, true);
        }
        String sessionId2 = Utils.appendGameSessionId((String)copy.getSessionId(), (String)copy.getReserve2());
        ChatSession session = this.getTargetSession(sessionId2);
        boolean isSendByMe = copy.isSendByMe();
        if (session == null) {
            if (!isSendByMe) {
                session = new GamePublicChatSession(copy);
                this.mISessionCallback.updateGamePublicSession(session);
            }
        } else {
            session.update(copy);
            this.mISessionCallback.updateGamePublicSession(session);
        }
        ChatSessionEventReporter.INSTANCE.addReportMessageTimeArrived(session);
    }

    private boolean messageFilter(Object msg) {
        if (msg instanceof ImMessageDBBean) {
            ImMessageDBBean bean = (ImMessageDBBean)msg;
            return bean.getMsgType() != 37 && (bean.getMsgType() != 45 || bean.getReserveInt1() != SAType.GAME.getValue());
        }
        return true;
    }

    private ImMessageDBBean transformBean(ImMessageDBBean oaBean) {
        if (oaBean != null && oaBean.getMsgType() == 45 && oaBean.getReserveInt1() == SAType.GAME.getValue()) {
            String gameId = oaBean.getReserve5();
            String said = oaBean.getReserve1();
            String msgId = oaBean.getExtra();
            String text = oaBean.getReserve4();
            String throughParam = oaBean.getReserve3();
            ImMessageDBBean newBean = ImMessageDBBean.copy((ImMessageDBBean)oaBean);
            newBean.setReserve1(gameId);
            newBean.setReserve2(said);
            newBean.setReserve3(msgId);
            newBean.setContent(text);
            newBean.setReserve4(throughParam);
            return newBean;
        }
        return oaBean;
    }

    private void joinGame(GamePublicChatSession gamePublicChatSession) {
        GameInfo mGameInfo;
        String gameId = ((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getReserve1();
        String extend = ((ImMessageDBBean)gamePublicChatSession.getLastMessage()).getTag();
        if (!StringUtils.isEmpty((String)gameId) && (mGameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId)) != null) {
            if (mGameInfo.downloadInfo.isDownloading()) {
                mGameInfo.downloadInfo.pause();
            } else {
                Message msg = Message.obtain();
                msg.what = BaseMsgDef.MSG_GAME_JUMP_MAIN_PAGE;
                Bundle bundle = new Bundle();
                if (!TextUtils.isEmpty((CharSequence)extend)) {
                    bundle.putString("extend", extend);
                }
                bundle.putBoolean("jumpHome", false);
                bundle.putString("gameSource", "ludo");
                msg.setData(bundle);
                msg.obj = gameId;
                MsgDispatcher.getInstance().sendMessage(msg);
            }
        }
    }

    private String getGameMsgNotifySwitch(ChatSession session) {
        boolean isOpen = session.getUnReadType() == 0;
        return isOpen ? ResourceUtils.getString((int)R.string.tips_short_close_msg_notify) : ResourceUtils.getString((int)R.string.tips_short_open_msg_notify);
    }

    private void clearAutoDownloadFlag(ChatSession session) {
        GamePublicChatSession gamePublicChatSession;
        String gameId;
        if (session instanceof GamePublicChatSession && !StringUtils.isEmpty((String)(gameId = ((ImMessageDBBean)(gamePublicChatSession = (GamePublicChatSession)session).getLastMessage()).getReserve1()))) {
            GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_CLEAR_AUTO_DOWNLOAD_GAMEID, (Object)gameInfo);
        }
    }

    private void requestSubAccountInfo() {
        ((IGameOfficialMsgService)ServiceManagerProxy.getServiceManager().getService(IGameOfficialMsgService.class)).getMySubAccounts((ICommonCallback)new ICommonCallback<GetMySubAccountsResp>(){

            public void onSuccess(GetMySubAccountsResp resp, Object ... ext) {
                GamePublicSessionPresenter.this.deleteUnsubscribeSession(resp.infos);
            }

            public void onFail(int errCode, String msg, Object ... ext) {
            }
        });
    }

    private void deleteUnsubscribeSession(List<SubAccountInfo> subAccountInfoList) {
        if (!FP.empty(subAccountInfoList)) {
            MLog.info((Object)TAG, (String)"deleteUnsubscribeSession size=%s", (Object[])new Object[]{subAccountInfoList.size()});
            for (SubAccountInfo subAccountInfo : subAccountInfoList) {
                if (subAccountInfo.status.intValue() != SAInfoStatus.OFFLINE.getValue()) continue;
                this.deleteUnsubscribeSessionInner(subAccountInfo);
            }
            this.mISessionCallback.deleteUnsubscribeSession(SubAccountDBBean.from(subAccountInfoList));
        }
    }

    private void deleteUnsubscribeSessionInner(SubAccountInfo subAccountInfo) {
        String sessionId2 = "";
        String gameSessionId = "";
        if (subAccountInfo.sub_account_type.intValue() == SAType.GAME.getValue()) {
            sessionId2 = Utils.getMyGamePublicSessionId((String)subAccountInfo.owner_id);
            gameSessionId = Utils.getOfficialAccountSessionId((String)subAccountInfo.sub_account_id);
        } else {
            sessionId2 = Utils.getOfficialAccountSessionId((String)subAccountInfo.sub_account_id);
        }
        this.deleteChatSession(sessionId2);
        this.deleteChatSession(gameSessionId);
    }

    private void deleteChatSession(String sessionId2) {
        if (!StringUtils.isEmpty((String)sessionId2)) {
            MLog.info((Object)TAG, (String)"deleteChatSession sessionId=%s", (Object[])new Object[]{sessionId2});
            ChatSession session = this.getTargetSession(sessionId2);
            if (session != null) {
                this.mISessionCallback.deleteSession(session, true);
            }
        }
    }

    public void onUnsubscribe(String subAccountId, String gameId) {
        ChatSession session;
        String sessionId2;
        if (!StringUtils.isEmpty((String)gameId)) {
            sessionId2 = Utils.getMyGamePublicSessionId((String)gameId);
            MLog.info((Object)TAG, (String)"onUnsubscribe gameId=%s, sessionId=%s", (Object[])new Object[]{gameId, sessionId2});
            session = this.getTargetSession(sessionId2);
            if (session != null) {
                this.mISessionCallback.deleteSession(session, true);
                this.clearAutoDownloadFlag(session);
                this.deleteMsg(session);
            }
        }
        if (!StringUtils.isEmpty((String)subAccountId)) {
            sessionId2 = Utils.getOfficialAccountSessionId((String)subAccountId);
            MLog.info((Object)TAG, (String)"onUnsubscribe sessionId=%s", (Object[])new Object[]{sessionId2});
            session = this.getTargetSession(sessionId2);
            if (session != null) {
                this.mISessionCallback.deleteSession(session, true);
                this.clearAutoDownloadFlag(session);
                this.deleteMsg(session);
            }
        }
    }
}

