/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.BbsNoticeDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.bbs.base.BBSBaseUtils;
import com.yy.im.model.BbsNoticeEntranceSession;
import com.yy.im.model.ChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.BbsNoticeBean;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collection;
import java.util.List;

public class BbsNoticeSessionPresenter
extends BaseSessionPresenter {
    private static final String TAG = "BbsNoticeSessionPresenter";
    private SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(10, BbsNoticeBean.class, BbsNoticeEntranceSession.class);
    private BbsNoticeDBBean mPushBbsNoticeDBBean;

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.BBS_NOTICE_READ_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.BBS_NOTICE_READ_ALL_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.BBS_NOTICE_ENTER_FROM_PUSH_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.BBS_NOTICE_UNLOCK_POST_ABILITY_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.BBS_NOTICE_UPDATE_UNREAD_COUNT, (INotify)this);
    }

    @Override
    public void notify(Notification notification) {
        Object obj;
        if (notification.id == ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE) {
            List list;
            Object msgs = notification.extObj;
            MLog.info((Object)TAG, (String)"receive single msg", (Object[])new Object[0]);
            if (msgs instanceof ImMessageDBBean) {
                this.onReceiveImMessage((ImMessageDBBean)msgs);
            } else if (msgs instanceof List && !(list = (List)msgs).isEmpty()) {
                for (ImMessageDBBean msg : list) {
                    this.onReceiveImMessage(msg);
                }
            }
        } else if (notification.id == NotificationIdDef.BBS_NOTICE_READ_MSG) {
            ChatSession session = this.getTargetSession("-7");
            if (session instanceof BbsNoticeEntranceSession && this.mISessionCallback != null) {
                int unReadCount = session.getUnReadCounts();
                MLog.info((Object)TAG, (String)"BBS_NOTICE_READ_MSG getUnReadCounts=%s", (Object[])new Object[]{unReadCount});
                if (unReadCount - 1 < 0) {
                    session.setUnReadCounts(0);
                } else {
                    session.setUnReadCounts(unReadCount - 1);
                }
                this.mISessionCallback.updateNormalSession(session);
            }
        } else if (notification.id == NotificationIdDef.BBS_NOTICE_READ_ALL_MSG) {
            ChatSession session = this.getTargetSession("-7");
            if (session instanceof BbsNoticeEntranceSession && this.mISessionCallback != null) {
                int unReadCount = session.getUnReadCounts();
                MLog.info((Object)TAG, (String)"BBS_NOTICE_READ_ALL_MSG getUnReadCounts=%s", (Object[])new Object[]{unReadCount});
                session.setUnReadCounts(0);
                this.mISessionCallback.updateNormalSession(session);
            }
        } else if (notification.id == NotificationIdDef.BBS_NOTICE_ENTER_FROM_PUSH_MSG) {
            Object bean = notification.extObj;
            if (bean instanceof BbsNoticeDBBean) {
                this.setReadedFromPush((BbsNoticeDBBean)bean);
            }
        } else if (notification.id == NotificationIdDef.BBS_NOTICE_UNLOCK_POST_ABILITY_MSG) {
            Object bean = notification.extObj;
            if (bean instanceof BbsNoticeDBBean) {
                BbsNoticeDBBean bbsNoticeDBBean = (BbsNoticeDBBean)bean;
                MyBox messageBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(BbsNoticeDBBean.class);
                if (messageBox != null) {
                    messageBox.addItem((BaseDBBean)((BbsNoticeDBBean)bean));
                } else {
                    MLog.error((Object)TAG, (String)"unlock_post_ability_msg messageBox==null", (Object[])new Object[0]);
                }
                this.showNoticeChatSession(bbsNoticeDBBean);
            }
        } else if (notification.id == NotificationIdDef.BBS_NOTICE_UPDATE_UNREAD_COUNT && (obj = notification.extObj) instanceof Integer) {
            int count = (Integer)obj;
            ChatSession session = this.getTargetSession("-7");
            if (session instanceof BbsNoticeEntranceSession && this.mISessionCallback != null) {
                MLog.info((Object)TAG, (String)"unread_count count=%s", (Object[])new Object[]{count});
            }
        }
    }

    private void onReceiveImMessage(ImMessageDBBean msg) {
        ImMessageDBBean copy;
        if (msg == null) {
            return;
        }
        if (this.messageFilter(msg)) {
            return;
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"msg=%s", (Object[])new Object[]{msg});
        }
        if (TextUtils.isEmpty((CharSequence)(copy = ImMessageDBBean.copy((ImMessageDBBean)msg)).getContent())) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            BbsNoticeDBBean bbsNoticeDBBean = BBSBaseUtils.from((ImMessageDBBean)copy);
            if (this.mPushBbsNoticeDBBean != null && this.mPushBbsNoticeDBBean.getPpostId().equals(bbsNoticeDBBean.getPpostId()) && this.mPushBbsNoticeDBBean.getPostId().equals(bbsNoticeDBBean.getPostId()) && this.mPushBbsNoticeDBBean.getType() == bbsNoticeDBBean.getType() && this.mPushBbsNoticeDBBean.getPostType() == bbsNoticeDBBean.getPostType()) {
                bbsNoticeDBBean.setReaded(true);
                this.mPushBbsNoticeDBBean = null;
                MLog.info((Object)TAG, (String)"mPushBbsNoticeDBBean ", (Object[])new Object[0]);
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20036879").put("function_id", "receive_push").put("push_source", String.valueOf(msg.getSource())));
            MyBox messageBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(BbsNoticeDBBean.class);
            if (messageBox != null) {
                messageBox.addItem((BaseDBBean)bbsNoticeDBBean);
            } else {
                MLog.error((Object)TAG, (String)"onReceiveImMessage messageBox==null", (Object[])new Object[0]);
            }
            YYTaskExecutor.postToMainThread(() -> {
                this.showNoticeChatSession(bbsNoticeDBBean);
                if (!bbsNoticeDBBean.isReaded()) {
                    Notification notification = Notification.obtain((int)NotificationIdDef.BBS_NOTICE_RECEIVE);
                    notification.extObj = bbsNoticeDBBean;
                    NotificationCenter.getGlobalInstance().notify(notification);
                }
            });
            YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.BBS_NOTICE_UPDATE)), (long)500L);
        });
    }

    private void showNoticeChatSession(BbsNoticeDBBean bbsNoticeDBBean) {
        BbsNoticeBean newBbsNoticeBean = BbsNoticeBean.from(bbsNoticeDBBean);
        ChatSession session = this.getTargetSession("-7");
        if (session == null) {
            session = new BbsNoticeEntranceSession(newBbsNoticeBean);
            if (bbsNoticeDBBean.isReaded()) {
                session.setUnReadCounts(0);
            } else {
                session.setUnReadCounts(1);
            }
            this.mISessionCallback.updateBbsNoticeSession(session);
        } else {
            BbsNoticeBean eBbsNoticeBean = (BbsNoticeBean)session.getLastMessage();
            eBbsNoticeBean.setContent(newBbsNoticeBean.getContent());
            eBbsNoticeBean.setTs(newBbsNoticeBean.getTs());
            eBbsNoticeBean.setNick(newBbsNoticeBean.getNick());
            eBbsNoticeBean.setType(newBbsNoticeBean.getType());
            if (!bbsNoticeDBBean.isReaded()) {
                session.setUnReadCounts(session.getUnReadCounts() + 1);
            }
            session.update(eBbsNoticeBean);
            this.mISessionCallback.updateBbsNoticeSession(session);
        }
        ChatSessionEventReporter.INSTANCE.addReportMessageTimeArrived(session);
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    public long getUserUid(ChatSession temp) {
        return 0L;
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
        MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_WINDOW_BBS_NOTICE_LIST);
        BbsNoticeBean eBbsNoticeBean = (BbsNoticeBean)chatSession.getLastMessage();
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20036879").put("function_id", "notice_click").put("notice_type", String.valueOf(eBbsNoticeBean.getType())));
    }

    private boolean messageFilter(Object msg) {
        if (msg instanceof ImMessageDBBean) {
            ImMessageDBBean bean = (ImMessageDBBean)msg;
            return bean.getMsgType() != 42;
        }
        return true;
    }

    private void setReadedFromPush(BbsNoticeDBBean bean) {
        MLog.info((Object)TAG, (String)"setReaded bean.getPostId=%s", (Object[])new Object[]{bean.getPostId()});
        this.mPushBbsNoticeDBBean = BbsNoticeDBBean.copy((BbsNoticeDBBean)bean);
        YYTaskExecutor.execute(() -> {
            MyBox myBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(BbsNoticeDBBean.class);
            myBox.getAll(datas -> {
                if (!FP.empty((Collection)datas)) {
                    BbsNoticeDBBean updateBean = null;
                    for (BbsNoticeDBBean curBean : datas) {
                        if (!FP.nonNull((Object[])new Object[]{curBean, curBean.getPpostId(), curBean.getPostId()}) || !curBean.getPpostId().equals(bean.getPpostId()) || !curBean.getPostId().equals(bean.getPostId()) || curBean.getType() != bean.getType() || curBean.getPostType() != bean.getPostType()) continue;
                        updateBean = BbsNoticeDBBean.copy((BbsNoticeDBBean)curBean);
                        break;
                    }
                    if (updateBean != null && !updateBean.isReaded()) {
                        MLog.info((Object)TAG, (String)"setReaded updateBean.getPostId=%s", (Object[])new Object[]{bean.getPostId()});
                        updateBean.setReaded(true);
                        myBox.updateItem(updateBean, false);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChatSession session = BbsNoticeSessionPresenter.this.getTargetSession("-7");
                                if (session instanceof BbsNoticeEntranceSession && session != null) {
                                    session.setUnReadCounts(Math.max(0, session.getUnReadCounts() - 1));
                                    BbsNoticeSessionPresenter.this.mISessionCallback.updateBbsNoticeSession(session);
                                }
                            }
                        });
                    }
                }
            });
        });
    }
}

