/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.os.Bundle;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.R;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerVoiceChatInvite
extends IImMsgParse {
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerVoiceChatInvite(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(final MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        JSONObject vchatObject = msgJson.optJSONObject("vchat");
        JSONObject familyObject = msgJson.optJSONObject("family");
        String roomSource = "";
        if (null != vchatObject) {
            messageBuilder.content(vchatObject.optString("content", ResourceUtils.getString((int)R.string.tips_channel_invite_im_content))).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).msgType(23).uid(item.getFromUid()).roomId(vchatObject.optString("roomid")).roomName(vchatObject.optString("room_title")).roomHostAvatar(vchatObject.optString("owner_avatar")).roomPwdToken(vchatObject.optString("room_token")).invitedId(vchatObject.optString("invited_id")).isSameCity(vchatObject.optBoolean("same_city")).sameCityLatLng(vchatObject.optString("same_city_latlng")).reserve2(familyObject != null ? familyObject.optString("inviteUrl", "") : "").reserve3(vchatObject.optString("gid", ""));
            String pushSource = "10";
            String game_trans_key = vchatObject.optString("game_trans_key", "");
            String game_trans_value = vchatObject.optString("game_trans_value", "");
            SharedPreferencesUtils.getDefaultPrf().edit().putString(game_trans_key, game_trans_value).apply();
            if (StringUtils.isNotEmpty((String)item.getPushPayload())) {
                try {
                    JSONObject pushPayload = JsonParser.obtainJSONObject((String)item.getPushPayload());
                    if (StringUtils.isNotEmpty((String)pushPayload.optString("push_source"))) {
                        pushSource = pushPayload.optString("push_source");
                    }
                    if (pushPayload.optJSONObject("vchat") != null) {
                        JSONObject vchat = pushPayload.optJSONObject("vchat");
                        roomSource = vchat.optString("room_source");
                        messageBuilder.roomSource(roomSource);
                    }
                }
                catch (JSONException e) {
                    MLog.error((Object)this.TAG, (String)"parse push payload error", (Object[])new Object[0]);
                }
            }
            String roomId = vchatObject.optString("roomid");
            final String roomTitle = vchatObject.optString("room_title");
            if (StringUtils.isNotEmpty((String)roomId)) {
                IChannelCenterService channelCenterService = (IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class);
                if (channelCenterService != null) {
                    final String finalPushSource = pushSource;
                    channelCenterService.getChannel(roomId).getDataService().getChannelBaseInfo(new IDataService.IGetGroupBaseInfoCallBack(){

                        public void onSuccess(String channelId, final ChannelInfo info) {
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    MsgInnerVoiceChatInvite.this.showNotification(item, info.name, finalPushSource);
                                }
                            });
                        }

                        public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    MsgInnerVoiceChatInvite.this.showNotification(item, roomTitle, finalPushSource);
                                }
                            });
                        }
                    });
                } else {
                    this.showNotification(item, roomTitle, pushSource);
                }
            } else {
                this.showNotification(item, roomTitle, pushSource);
            }
            if (RuntimeContext.sIsForeground) {
                Message msg = Message.obtain();
                msg.what = BaseMsgDef.VOICE_ROOM_INVITE_TOAST;
                Bundle bundle = new Bundle();
                bundle.putString("roomId", vchatObject.optString("roomid"));
                bundle.putLong("fromUid", item.getFromUid());
                bundle.putString("roomPwdToken", vchatObject.has("room_token") ? vchatObject.optString("room_token") : "");
                bundle.putString("source", String.valueOf(msgJson.optInt("source")));
                bundle.putString("push_source", pushSource);
                bundle.putString("room_source", roomSource);
                bundle.putString("inviteUrl", familyObject != null ? familyObject.optString("inviteUrl", "") : "");
                msg.obj = bundle;
                MsgDispatcher.getInstance().sendMessage(msg);
            }
        }
        return messageBuilder;
    }

    private void showNotification(MsgData item, String roomTitle, String pushSource) {
        this.ctlCallback.showDefaultNotification(item, String.format(ResourceUtils.getString((int)R.string.tips_channel_invite_push_content), roomTitle), "", pushSource);
    }
}

