/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.os.Bundle;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.appbase.notify.NotifyPushToastInfo;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.UidUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.R;
import com.yy.im.module.room.utils.IMTrack;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import java.io.Serializable;
import org.json.JSONObject;

public class MsgInnerTxtPic
extends IImMsgParse {
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerTxtPic(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        if (msgJson != null) {
            MLog.info((Object)"MsgInnerTxtPic", (String)"parseMsg msgJson = :%s", (Object[])new Object[]{msgJson.toString()});
            JSONObject contentJson = msgJson.optJSONObject("pictxt");
            if (contentJson != null) {
                String content = contentJson.optString("txt");
                String imageUrl = contentJson.optString("url");
                String jumpUrl = contentJson.optString("jump_url");
                if (payloadJson != null) {
                    MLog.info((Object)"MsgInnerTxtPic", (String)"parseMsg payloadJson = :%s", (Object[])new Object[]{payloadJson.toString()});
                    boolean isFloat = payloadJson.optBoolean("is_float");
                    if (isFloat) {
                        YYTaskExecutor.postToMainThread(() -> this.showFloatNotify(content, imageUrl, jumpUrl));
                    }
                }
                messageBuilder.content(content).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).contentType(7).uid(item.getFromUid()).imageUrl(imageUrl).jumpUrl(jumpUrl);
                if (UidUtils.isSpecialUid((long)item.getFromUid())) {
                    messageBuilder.msgType(1);
                    this.ctlCallback.showDefaultNotification(item, item.getPushContent(), "", "10");
                } else {
                    messageBuilder.msgType(29);
                }
            }
        }
        return messageBuilder;
    }

    private void showFloatNotify(String content, String imgUrl, String jumpUlr) {
        Message pushMsg = Message.obtain();
        pushMsg.what = BaseMsgDef.MSG_SHOW_NOTIFY_TOAST;
        NotifyPushToastInfo info = new NotifyPushToastInfo();
        info.setJumpType(10000);
        info.setPushType(10000);
        info.setJumpUri(jumpUlr);
        info.setImgUrl(imgUrl);
        info.setPushTittle(content);
        info.setButtonText(ResourceUtils.getString((int)R.string.join));
        Bundle bundle = new Bundle();
        bundle.putSerializable("base_toast_info_type", (Serializable)info);
        pushMsg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(pushMsg);
        IMTrack.INSTANCE.handleChannelActivityMsgReport("push_message_show", jumpUlr);
    }
}

