/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONObject;

public class MsgInnerSmallShare
extends IImMsgParse {
    private IMsgParseCtlCallback mCtlCallback;

    public MsgInnerSmallShare(IMsgParseCtlCallback callback) {
        this.mCtlCallback = callback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        JSONObject contentJson;
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        if (msgJson != null && (contentJson = msgJson.optJSONObject("share")) != null) {
            String url = contentJson.optString("url");
            String id2 = contentJson.optString("id");
            String type = contentJson.optString("type");
            String jumpUrl = contentJson.optString("jump_url");
            String title = contentJson.optString("title");
            String subTitle = contentJson.optString("subtitle");
            String content = contentJson.optString("content");
            String smallUrl = contentJson.optString("smallUrl");
            int source = contentJson.optInt("source", 0);
            boolean isCircleIcon = contentJson.optBoolean("is_circle");
            String pluginId = contentJson.optString("plugin_id", "");
            boolean isMultiVideo = contentJson.optBoolean("is_multi_video");
            int msgType = isMultiVideo ? 63 : 54;
            boolean isCircle = isMultiVideo ? false : isCircleIcon;
            MLog.info((Object)this.TAG, (String)("IImMsgParse isMultiVideo:" + isMultiVideo), (Object[])new Object[0]);
            messageBuilder.content(content).gameId(id2).imageUrl(url).jumpUrl(jumpUrl).reserve1(title).reserve2(subTitle).reserve3(type).reserve4(pluginId).reverse5(smallUrl).isSameCity(isCircle).fromType(source).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).contentType(1).uid(item.getFromUid()).msgType(msgType);
        }
        if (payloadJson != null && payloadJson.has("set_id")) {
            String setId = payloadJson.optString("set_id");
            messageBuilder.setId(setId);
        }
        this.mCtlCallback.showNotification(item, "1017", false);
        return messageBuilder;
    }
}

