/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.ImResourceManager;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.location.LocationUtils;

@DontProguardClass
public class ChatVoiceRoomInviteReceiveHolder
extends ChatBaseHolder
implements View.OnClickListener {
    private HeadFrameImageView ivAvatar;
    private YYTextView tvTxtMsg;
    private YYTextView tvContent;
    private YYTextView tvTime;
    private View contentView;
    private YYTextView distanceTv;

    public ChatVoiceRoomInviteReceiveHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.ivAvatar = (HeadFrameImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.tvTxtMsg = (YYTextView)itemView.findViewById(R.id.tv_txt_msg);
        this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_content);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.contentView = itemView.findViewById(R.id.content);
        this.distanceTv = (YYTextView)itemView.findViewById(R.id.tv_distance);
        itemView.findViewById(R.id.llyt_voice_item_bg).setBackgroundResource(ImResourceManager.INSTANCE.getImOtherBackground());
    }

    public static BaseItemBinder<ChatMessageData, ChatVoiceRoomInviteReceiveHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatVoiceRoomInviteReceiveHolder>(){

            @NonNull
            protected ChatVoiceRoomInviteReceiveHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatVoiceRoomInviteReceiveHolder(inflater.inflate(R.layout.layout_item_im_voice_room_invite_receive, parent, false), context);
            }
        };
    }

    public void setData(final ChatMessageData data2) {
        block17: {
            super.setData((Object)data2);
            if (data2.message.getUid() == 10L || data2.message.getUid() == 14L) {
                this.ivAvatar.getCircleImageView().setImageResource(R.drawable.icon_public_msg_avatar);
            } else {
                this.showAvatar((RecycleImageView)this.ivAvatar.getCircleImageView(), this.getUserInfo(data2.message.getUid()));
            }
            this.setFormatTimeInfo((TextView)this.tvTime, data2);
            this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
            this.ivAvatar.setOnClickListener((View.OnClickListener)this);
            this.tvTxtMsg.setText((CharSequence)data2.message.getRoomName());
            if (!StringUtils.isEmpty((String)data2.message.getContent())) {
                this.tvContent.setText((CharSequence)data2.message.getContent());
            }
            this.contentView.setTag(R.id.chat_message_data, (Object)data2);
            this.contentView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ChatVoiceRoomInviteReceiveHolder.this.getEventCallback() != null) {
                        ChatVoiceRoomInviteReceiveHolder.this.getEventCallback().onVoiceRoomInviteClick(data2.message.getRoomeId(), data2.message.getRoomPwdToken(), false, data2.message.getReserve2(), data2.message.getUid(), data2.message.getRoomSource());
                    }
                }
            });
            this.contentView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (ChatVoiceRoomInviteReceiveHolder.this.getEventCallback() != null) {
                        ChatVoiceRoomInviteReceiveHolder.this.getEventCallback().onVoiceRoomInviteLongClick(v, data2);
                    }
                    return false;
                }
            });
            HeadFrameType otherHeadFrameType = this.getOtherHeadFrameType();
            if (otherHeadFrameType != null) {
                Kvo.addKvoBinding((KvoSource)otherHeadFrameType, (Object)((Object)this), (String)"onOtherHeadFrameTypeUpdate");
            }
            if (data2.message.isSameCity()) {
                this.distanceTv.setVisibility(0);
                if (PermissionHelper.hasLocationPermission((Activity)((FragmentActivity)this.getContext()))) {
                    UserInfoKS userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
                    String tude1 = userInfo.locationTude;
                    String tude2 = data2.message.getSameCityLatLng();
                    String[] locationArr1 = null;
                    String[] locationArr2 = null;
                    if (!FP.empty((CharSequence)tude1)) {
                        locationArr1 = tude1.split("_");
                    }
                    if (!FP.empty((CharSequence)tude2)) {
                        locationArr2 = tude2.split("_");
                    }
                    if (locationArr1 != null && locationArr1.length == 2 && locationArr2 != null && locationArr2.length == 2) {
                        try {
                            double lgd1 = Double.valueOf(locationArr1[0]);
                            double lat1 = Double.valueOf(locationArr1[1]);
                            double lgd2 = Double.valueOf(locationArr2[0]);
                            double lat2 = Double.valueOf(locationArr2[1]);
                            double distance = LocationUtils.getDistance((double)lat1, (double)lgd1, (double)lat2, (double)lgd2);
                            if (distance < 0.1) {
                                this.distanceTv.setText((CharSequence)"<100m");
                                break block17;
                            }
                            if (distance < 1.0) {
                                double newDistance = (double)Math.round(distance * 1000.0) / 1000.0;
                                this.distanceTv.setText((CharSequence)String.format("%sm", (int)(newDistance * 1000.0)));
                                break block17;
                            }
                            if (distance < 20.0) {
                                this.distanceTv.setText((CharSequence)String.format("%skm", Math.round(distance)));
                                break block17;
                            }
                            this.distanceTv.setText(R.string.tips_samecity_im);
                        }
                        catch (NumberFormatException e) {
                            this.distanceTv.setText(R.string.tips_samecity_im);
                        }
                    } else {
                        this.distanceTv.setText(R.string.tips_samecity_im);
                    }
                } else {
                    this.distanceTv.setText(R.string.tips_samecity_im);
                }
            } else {
                this.distanceTv.setVisibility(8);
            }
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onOtherHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.ivAvatar != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame));
        }
    }

    public void onClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && this.getEventCallback() != null) {
            this.getEventCallback().onUserAvatarClick(((ChatMessageData)v.getTag((int)R.id.chat_message_data)).message.getUid(), 8);
        }
    }
}

