/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.im.UidUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.ImResourceManager;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;

@DontProguardClass
public class ChatRevokedRevHolder
extends ChatBaseHolder
implements View.OnClickListener {
    private HeadFrameImageView ivAvatar;
    private YYTextView tvTxtMsg;
    private YYTextView tvTime;

    public ChatRevokedRevHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.ivAvatar = (HeadFrameImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.tvTxtMsg = (YYTextView)itemView.findViewById(R.id.tv_txt_msg);
        this.tvTxtMsg.setBackgroundResource(ImResourceManager.INSTANCE.getImOtherBackground());
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
    }

    public static BaseItemBinder<ChatMessageData, ChatRevokedRevHolder> getBinder(final IMvpContext provider) {
        return new BaseItemBinder<ChatMessageData, ChatRevokedRevHolder>(){

            @NonNull
            protected ChatRevokedRevHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatRevokedRevHolder(inflater.inflate(R.layout.layout_item_im_chat_received_revoked, parent, false), provider);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        if (UidUtils.isSpecialUid((long)data2.message.getUid())) {
            this.ivAvatar.getCircleImageView().setImageResource(R.drawable.icon_public_msg_avatar);
        } else {
            this.showAvatar((RecycleImageView)this.ivAvatar.getCircleImageView(), this.getUserInfo(data2.message.getUid()));
        }
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
        this.ivAvatar.setOnClickListener((View.OnClickListener)this);
        this.tvTxtMsg.setVisibility(0);
        this.tvTxtMsg.setText((CharSequence)ResourceUtils.getString((int)R.string.im_revoked_message_rev));
        HeadFrameType otherHeadFrameType = this.getOtherHeadFrameType();
        if (otherHeadFrameType != null) {
            Kvo.addKvoBinding((KvoSource)otherHeadFrameType, (Object)((Object)this), (String)"onOtherHeadFrameTypeUpdate");
        }
    }

    public void onClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && this.getEventCallback() != null) {
            this.getEventCallback().onUserAvatarClick(((ChatMessageData)v.getTag((int)R.id.chat_message_data)).message.getUid(), 8);
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onOtherHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.ivAvatar != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame));
        }
    }
}

