/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.im.module.room.utils.ChatMessageEventHandler;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Locale;

public class ChatRechargeResultHolder
extends ChatBaseHolder {
    private static String TAG = "ChatRechargeResultHolder";
    private YYTextView mTvPayStatus;
    private YYTextView mTvRechargeNumber;
    private YYTextView mTvOrderType;
    private YYTextView mTvOrderId;
    private YYTextView mTvGpOrderId;
    private YYTextView mTvOrderTime;
    private YYTextView mTvFeedback;
    private YYTextView mTvOrderStatus;
    private YYTextView mTvGoods;
    private YYTextView mPayChannel;
    private YYTextView mPayChannelTitle;
    private YYTextView mTvPayAgain;
    private YYView mGiftBagDivide;
    private String mCountry;
    private DecimalFormat df;
    ChatMessageData data;
    private String mOrderId;
    private String gpOrderIdText;
    private String mOrderTime;
    private String price;
    private String mPayStatus;

    public ChatRechargeResultHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.mTvPayStatus = (YYTextView)itemView.findViewById(R.id.tv_pay_result);
        this.mTvRechargeNumber = (YYTextView)itemView.findViewById(R.id.tv_recharge_number);
        this.mTvOrderType = (YYTextView)itemView.findViewById(R.id.tv_order_type);
        this.mTvOrderId = (YYTextView)itemView.findViewById(R.id.tv_order_id);
        this.mTvGpOrderId = (YYTextView)itemView.findViewById(R.id.tv_gp_order_id);
        this.mTvOrderTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.mTvFeedback = (YYTextView)itemView.findViewById(R.id.tv_feedback);
        this.mTvOrderStatus = (YYTextView)itemView.findViewById(R.id.tv_order_status);
        this.mTvGoods = (YYTextView)itemView.findViewById(R.id.tv_goods);
        this.mPayChannel = (YYTextView)itemView.findViewById(R.id.tv_pay_channel);
        this.mPayChannelTitle = (YYTextView)itemView.findViewById(R.id.tv_title_pay_channel);
        this.mTvPayAgain = (YYTextView)itemView.findViewById(R.id.tv_pay_again);
        this.mGiftBagDivide = (YYView)itemView.findViewById(R.id.gift_bag_divide);
        this.mTvPayAgain.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatRechargeResultHolder.this.onOptionBtnClick();
            }
        });
        this.mTvFeedback.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ResourceUtils.getString((int)R.string.short_tip_order_id) + ": ");
                stringBuffer.append(StringUtils.isEmpty((String)ChatRechargeResultHolder.this.gpOrderIdText) ? ChatRechargeResultHolder.this.mOrderId : ChatRechargeResultHolder.this.gpOrderIdText + "\n");
                stringBuffer.append(ResourceUtils.getString((int)R.string.short_tip_order_state) + ": ");
                stringBuffer.append(ChatRechargeResultHolder.this.mPayStatus + "\n");
                stringBuffer.append(ResourceUtils.getString((int)R.string.short_tip_payment_amount) + ": ");
                stringBuffer.append(ChatRechargeResultHolder.this.price + "\n");
                stringBuffer.append(ResourceUtils.getString((int)R.string.short_tip_order_time) + ": ");
                stringBuffer.append(ChatRechargeResultHolder.this.mOrderTime);
                ChatMessageEventHandler.onJumpHelpCenterOrFeedback(v, stringBuffer.toString(), StringUtils.isEmpty((String)ChatRechargeResultHolder.this.gpOrderIdText) ? ChatRechargeResultHolder.this.mOrderId : ChatRechargeResultHolder.this.gpOrderIdText);
            }
        });
        FontUtils.setFontType((TextView)this.mTvRechargeNumber, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
    }

    private void payAgain() {
        Message msg = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putInt("fromType", 107);
        msg.setData(bundle);
        msg.what = AppbaseMsgDef.SHOW_WINDOW_RECHARGE;
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    public static BaseItemBinder<ChatMessageData, ChatRechargeResultHolder> getBinder(final IMvpContext provider) {
        return new BaseItemBinder<ChatMessageData, ChatRechargeResultHolder>(){

            @NonNull
            protected ChatRechargeResultHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatRechargeResultHolder(inflater.inflate(R.layout.item_recharge_result_msg, parent, false), provider);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        this.data = data2;
        ImMessageDBBean message = data2.message;
        if (message == null) {
            MLog.error((Object)TAG, (String)"updateItem message is null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"state = %s", (Object[])new Object[]{message.toString()});
        this.setPaymentStatusColor(message);
        this.mOrderTime = DateUtils.getTimeFromMillisecond((Long)message.getOrderTime(), (SimpleDateFormat)CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss"));
        this.mTvOrderTime.setText((CharSequence)this.mOrderTime);
        this.mOrderId = message.getOrderId();
        this.mTvOrderId.setText((CharSequence)this.mOrderId);
        String goods = String.format(ResourceUtils.getString((int)R.string.short_tips_msg_recharge_goods), message.getDiamondNum());
        if (TextUtils.isEmpty((CharSequence)message.getGpOrderId())) {
            this.setGpOrderStatusGroup(8);
        } else {
            this.mTvGpOrderId.setText((CharSequence)message.getGpOrderId());
            this.setGpOrderStatusGroup(0);
        }
        this.mTvPayAgain.setTextColor(ResourceUtils.getColor((int)R.color.color_ffc102));
        this.mTvPayAgain.setTag((Object)0);
        this.gpOrderIdText = message.getGpOrderId();
        this.mPayStatus = this.getPaymentState(message);
        this.mTvPayStatus.setText((CharSequence)this.mPayStatus);
        String orderStatus = this.getOrderStatus(message);
        this.mTvOrderStatus.setText((CharSequence)orderStatus);
        this.handleBottom(message);
        String currency = TextUtils.isEmpty((CharSequence)message.getSrcCurrencySymbol()) ? Currency.getInstance(Locale.US).getSymbol(Locale.US) : message.getSrcCurrencySymbol();
        this.price = String.format(Locale.getDefault(), "%s%s", currency, this.transformNumFormat(message.getPrice()));
        this.mTvRechargeNumber.setText((CharSequence)this.price);
        this.mTvOrderType.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tip_payment_amount));
        this.setFeedback(message);
        if (!TextUtils.isEmpty((CharSequence)message.getChannelId())) {
            this.mPayChannel.setVisibility(0);
            this.mPayChannelTitle.setVisibility(0);
            this.mPayChannel.setText((CharSequence)message.getChannelId());
        } else {
            this.mPayChannel.setVisibility(8);
            this.mPayChannelTitle.setVisibility(8);
        }
        this.checkoutShowAmount();
        if (!TextUtils.isEmpty((CharSequence)message.getPostId())) {
            String name = TextUtils.isEmpty((CharSequence)message.getToUserName()) ? ResourceUtils.getString((int)R.string.tips_recharge_gift_bag_name) : message.getToUserName();
            this.mTvGoods.setText((CharSequence)name);
            this.setOrderStatusGroup(8);
            this.mGiftBagDivide.setVisibility(0);
        } else {
            this.mGiftBagDivide.setVisibility(8);
            this.mTvGoods.setText((CharSequence)goods);
        }
        this.itemView.requestLayout();
    }

    private void checkoutShowAmount() {
        if (this.data == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.data.message.getReserve1()) || StringUtils.parseBoolean((String)this.data.message.getReserve1())) {
            this.mTvRechargeNumber.setVisibility(0);
            this.mTvOrderType.setVisibility(0);
        } else {
            this.mTvRechargeNumber.setVisibility(8);
            this.mTvOrderType.setVisibility(8);
        }
    }

    private String transformNumFormat(double num) {
        String country = AccountUtil.realCountry();
        if (!StringUtils.equalsIgnoreCase((String)country, (String)this.mCountry)) {
            this.df = null;
        }
        this.mCountry = country;
        String numText = "";
        if (this.df == null) {
            this.df = StringUtils.equalsIgnoreCase((String)"ID", (String)this.mCountry) || StringUtils.equalsIgnoreCase((String)"IN", (String)this.mCountry) || StringUtils.equalsIgnoreCase((String)"VN", (String)this.mCountry) ? new DecimalFormat("###,###", new DecimalFormatSymbols(this.getLocale(this.mCountry))) : new DecimalFormat("###,##0.00", new DecimalFormatSymbols(this.getLocale(this.mCountry)));
        }
        numText = this.df.format(num);
        return numText;
    }

    private Locale getLocale(String country) {
        if (StringUtils.equalsIgnoreCase((String)"id", (String)country)) {
            return new Locale("in", country);
        }
        if (StringUtils.equalsIgnoreCase((String)"BR", (String)country)) {
            return new Locale("pt", country);
        }
        return new Locale("", country);
    }

    private void setPaymentStatusColor(ImMessageDBBean message) {
        if (message.getReserveInt1() == 2) {
            switch (message.getOrderState()) {
                case 2: 
                case 4: {
                    this.mTvPayStatus.setTextColor(ColorUtils.parseColor((String)"#ff4a00"));
                    break;
                }
                default: {
                    this.mTvPayStatus.setTextColor(ColorUtils.parseColor((String)"#00a479"));
                    break;
                }
            }
        } else {
            this.setPaymentStatusColorLocal(message);
        }
    }

    private void setPaymentStatusColorLocal(ImMessageDBBean message) {
        switch (message.getOrderState()) {
            case 12: {
                this.mTvPayStatus.setTextColor(ColorUtils.parseColor((String)"#ff4a00"));
                break;
            }
            case 10: {
                this.mTvPayStatus.setTextColor(ColorUtils.parseColor((String)"#4a4a4a"));
                break;
            }
            default: {
                this.mTvPayStatus.setTextColor(ColorUtils.parseColor((String)"#00a479"));
            }
        }
    }

    private String getPaymentState(ImMessageDBBean message) {
        if (message.getReserveInt1() == 2) {
            return this.getPayPaymentStateService(message);
        }
        return this.getPaymentStateLocal(message);
    }

    private String getPayPaymentStateService(ImMessageDBBean message) {
        if (3 == message.getOrderState()) {
            return ResourceUtils.getString((int)R.string.short_tip_recharge_result_wait);
        }
        if (2 == message.getOrderState() || 4 == message.getOrderState()) {
            return ResourceUtils.getString((int)R.string.short_tip_recharge_result_fail);
        }
        if (1 == message.getOrderState()) {
            return ResourceUtils.getString((int)R.string.short_tip_recharge_result_success);
        }
        return "";
    }

    private String getPaymentStateLocal(ImMessageDBBean message) {
        if (1 == message.getOrderState()) {
            return ResourceUtils.getString((int)R.string.short_tip_recharge_result_wait);
        }
        if (12 == message.getOrderState()) {
            return ResourceUtils.getString((int)R.string.short_tip_recharge_result_fail);
        }
        if (10 == message.getOrderState()) {
            return ResourceUtils.getString((int)R.string.short_tip_recharge_result_cancel);
        }
        if (11 == message.getOrderState() || 2 == message.getOrderState()) {
            return ResourceUtils.getString((int)R.string.short_tip_recharge_result_success);
        }
        return "";
    }

    private String getOrderStatus(ImMessageDBBean message) {
        if (message.getReserveInt1() == 2) {
            return this.getOrderStatusService(message);
        }
        return this.getOrderStatusLocal(message);
    }

    private String getOrderStatusService(ImMessageDBBean message) {
        if (1 == message.getOrderState()) {
            return ResourceUtils.getString((int)R.string.short_tips_msg_recharge_completed);
        }
        return ResourceUtils.getString((int)R.string.short_tip_recharge_result_wait);
    }

    private String getOrderStatusLocal(ImMessageDBBean message) {
        if (2 == message.getOrderState()) {
            return ResourceUtils.getString((int)R.string.short_tips_msg_recharge_completed);
        }
        return ResourceUtils.getString((int)R.string.short_tip_recharge_result_wait);
    }

    private void setFeedback(ImMessageDBBean message) {
        if (message.getReserveInt1() == 2) {
            if (message.getOrderState() == 3 || message.getOrderState() == 4 || message.getOrderState() == 2) {
                this.mTvFeedback.setVisibility(0);
                this.mTvOrderStatus.setTextColor(ColorUtils.parseColor((String)"#ff4a00"));
            } else if (message.getOrderState() == 1) {
                this.mTvFeedback.setVisibility(8);
                this.mTvOrderStatus.setTextColor(ColorUtils.parseColor((String)"#00a479"));
            }
        } else {
            this.setFeedbackLocal(message);
        }
    }

    private void setFeedbackLocal(ImMessageDBBean message) {
        if (message.getOrderState() == 1 || message.getOrderState() == 12 || message.getOrderState() == 10 || message.getOrderState() == 11) {
            this.mTvFeedback.setVisibility(0);
            this.mTvOrderStatus.setTextColor(ColorUtils.parseColor((String)"#ff4a00"));
        } else if (message.getOrderState() == 2) {
            this.mTvFeedback.setVisibility(8);
            this.mTvOrderStatus.setTextColor(ColorUtils.parseColor((String)"#00a479"));
        }
    }

    private void handleBottom(ImMessageDBBean message) {
        ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)this.mPayChannel.getLayoutParams();
        layoutParams2.bottomToBottom = -1;
        layoutParams2.bottomMargin = 0;
        if (message.getReserveInt1() == 2) {
            this.handleBottomService(message, layoutParams2);
        } else {
            this.handleBottomLocal(message, layoutParams2);
        }
    }

    private void handleBottomService(ImMessageDBBean message, ConstraintLayout.LayoutParams layoutParams2) {
        switch (message.getOrderState()) {
            case 0: 
            case 2: 
            case 4: {
                MLog.info((Object)TAG, (String)"handleBottomLocal 11 GONE %s, %s", (Object[])new Object[]{message.getOrderId(), this});
                this.setPayAgainGroup(8);
                this.setOrderStatusGroup(8);
                layoutParams2.bottomToBottom = 0;
                layoutParams2.bottomMargin = ResolutionUtils.dip2Px((float)18.0f);
                break;
            }
            case 1: {
                this.setPayAgainGroup(8);
                this.setOrderStatusGroup(0);
                break;
            }
            default: {
                MLog.info((Object)TAG, (String)"handleBottomLocal 22  GONE %s, %s", (Object[])new Object[]{message.getOrderId(), this});
                this.setUpdateStateOption(message);
                this.setOrderStatusGroup(8);
            }
        }
    }

    private void handleBottomLocal(ImMessageDBBean message, ConstraintLayout.LayoutParams layoutParams2) {
        switch (message.getOrderState()) {
            case 10: {
                MLog.info((Object)TAG, (String)"handleBottomLocal 33 VISIBLE %s, %s", (Object[])new Object[]{message.getOrderId(), this});
                this.setOptionBtnText(R.string.short_tips_msg_recharge_pay_again);
                this.setOrderStatusGroup(8);
                break;
            }
            case 12: {
                MLog.info((Object)TAG, (String)"handleBottomLocal 44 GONE %s, %s", (Object[])new Object[]{message.getOrderId(), this});
                this.setPayAgainGroup(8);
                this.setOrderStatusGroup(8);
                layoutParams2.bottomToBottom = 0;
                layoutParams2.bottomMargin = ResolutionUtils.dip2Px((float)18.0f);
                break;
            }
            case 2: {
                this.setPayAgainGroup(8);
                this.setOrderStatusGroup(0);
                break;
            }
            default: {
                MLog.info((Object)TAG, (String)"handleBottomLocal 55 GONE %s, %s", (Object[])new Object[]{message.getOrderId(), this});
                this.setUpdateStateOption(message);
                this.setOrderStatusGroup(8);
            }
        }
    }

    private void onOptionBtnClick() {
        int res = (Integer)this.mTvPayAgain.getTag();
        if (res == R.string.im_btn_had_update_pay_state) {
            if (this.isUseSdk()) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.im_tips_update_fail_sdk);
            } else {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.im_tips_update_fail_hago);
            }
        } else if (res == R.string.im_btn_update_pay_state) {
            this.retryReport();
        } else {
            this.payAgain();
        }
    }

    private void retryReport() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.network_error);
            return;
        }
        String orderId = this.data.message.getOrderId();
        MLog.info((Object)TAG, (String)"retryReport orderId: %s", (Object[])new Object[]{orderId});
        ((IPayService)ServiceManagerProxy.getService(IPayService.class)).retryUpdateState(orderId);
        this.data.message.setReserve1("1");
        this.setData(this.data);
        this.updateDb();
    }

    private void updateDb() {
        MyBox msgBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class);
        msgBox.updateItem((BaseDBBean)this.data.message, false);
    }

    private boolean hadRetry(ImMessageDBBean message) {
        return StringUtils.parseInt((String)message.getReserve1()) == 1;
    }

    private boolean isUseSdk() {
        return ((IPayService)ServiceManagerProxy.getService(IPayService.class)).isUseRevenueSdk();
    }

    private void setUpdateStateOption(ImMessageDBBean message) {
        if (this.hadRetry(message)) {
            this.setOptionBtnText(R.string.im_btn_had_update_pay_state);
            this.mTvPayAgain.setTextColor(ResourceUtils.getColor((int)R.color.color_dedede));
        } else {
            this.setOptionBtnText(R.string.im_btn_update_pay_state);
            this.mTvPayAgain.setTextColor(ResourceUtils.getColor((int)R.color.color_ffc102));
        }
    }

    private void setOptionBtnText(int res) {
        this.mTvPayAgain.setText(res);
        this.mTvPayAgain.setTag((Object)res);
        this.setPayAgainGroup(0);
    }

    private void setPayAgainGroup(int visible) {
        if (visible == 8) {
            this.mTvPayAgain.setTag((Object)0);
        }
        this.mTvPayAgain.setVisibility(visible);
        this.itemView.findViewById(R.id.divider).setVisibility(visible);
    }

    private void setOrderStatusGroup(int visible) {
        this.itemView.findViewById(R.id.tv_order_status).setVisibility(visible);
        this.itemView.findViewById(R.id.tv_title_order_status).setVisibility(visible);
    }

    private void setGpOrderStatusGroup(int visible) {
        this.itemView.findViewById(R.id.tv_gp_order_id).setVisibility(visible);
        this.itemView.findViewById(R.id.tv_title_gp_order_id).setVisibility(visible);
    }
}

