/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.UnderlineSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.CustomImageSpan;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;

@DontProguardClass
public class ChatPushNoticeHolder
extends ChatBaseHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private YYTextView tvContent;

    public ChatPushNoticeHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.tvContent = (YYTextView)itemView;
    }

    public static BaseItemBinder<ChatMessageData, ChatPushNoticeHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatPushNoticeHolder>(){

            @NonNull
            protected ChatPushNoticeHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatPushNoticeHolder(inflater.inflate(R.layout.layout_item_im_push_notice, parent, false), context);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        String click = this.getContext().getString(R.string.push_pemission_click_text);
        String content = data2.message.getContent();
        String s = " " + content + " " + click;
        SpannableString span = new SpannableString((CharSequence)s);
        int clickStart = s.length() - click.length();
        int clickEnd = s.length();
        Drawable drawable2 = ResourceUtils.getDrawable((int)R.drawable.im_chat_icon);
        drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
        span.setSpan((Object)new CustomImageSpan(drawable2, 2, 0.0f, (float)ResolutionUtils.dip2Px((float)3.0f)), 0, 1, 33);
        span.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#666666")), 1, 1 + content.length(), 33);
        span.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#42a4ff")), clickStart, clickEnd, 33);
        span.setSpan((Object)new UnderlineSpan(), clickStart, clickEnd, 33);
        this.tvContent.setText((CharSequence)span);
        this.tvContent.setTag(R.id.chat_message_data, (Object)data2);
        this.tvContent.setOnClickListener((View.OnClickListener)this);
        this.tvContent.setOnLongClickListener((View.OnLongClickListener)this);
    }

    public void onClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && this.getEventCallback() != null) {
            this.getEventCallback().onContentClick(v, (ChatMessageData)v.getTag(R.id.chat_message_data));
        }
    }

    public boolean onLongClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData) {
            if (this.getEventCallback() != null) {
                this.getEventCallback().onChatMessageItemLongClick((ChatMessageData)v.getTag(R.id.chat_message_data), v);
            }
            return true;
        }
        return false;
    }
}

