/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.ImResourceManager;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;

@DontProguardClass
public class ChatFavorMessageHolder
extends ChatBaseHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private HeadFrameImageView ivAvatar;
    private YYTextView tvTxtMsg;
    private YYTextView tvTime;
    private ImageView ivFavor;
    private View contentView;

    public ChatFavorMessageHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.ivAvatar = (HeadFrameImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.tvTxtMsg = (YYTextView)itemView.findViewById(R.id.tv_txt_msg);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.ivFavor = (ImageView)itemView.findViewById(R.id.iv_favor);
        this.contentView = itemView.findViewById(R.id.content);
        this.contentView.setBackgroundResource(ImResourceManager.INSTANCE.getImOtherBackground());
    }

    public static BaseItemBinder<ChatMessageData, ChatFavorMessageHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatFavorMessageHolder>(){

            @NonNull
            protected ChatFavorMessageHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatFavorMessageHolder(inflater.inflate(R.layout.layout_item_im_chat_favor, parent, false), context);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        UserInfoKS bean = this.getUserInfo(data2.message.getUid());
        this.showAvatar((RecycleImageView)this.ivAvatar.getCircleImageView(), bean);
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        ImMessageDBBean imMessageDBBean = data2.message;
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
        this.ivAvatar.setOnClickListener((View.OnClickListener)this);
        if (imMessageDBBean.getMsgType() == 13) {
            this.tvTxtMsg.setText(R.string.team_game_flavor_msg);
            this.ivFavor.setBackgroundResource(R.drawable.result_im_like);
        } else if (imMessageDBBean.getMsgType() == 5) {
            this.tvTxtMsg.setText(R.string.like_profile_msg);
            this.ivFavor.setBackgroundResource(R.drawable.ic_favor);
        }
        this.contentView.setTag(R.id.chat_message_data, (Object)data2);
        this.contentView.setOnLongClickListener((View.OnLongClickListener)this);
        HeadFrameType otherHeadFrameType = this.getOtherHeadFrameType();
        if (otherHeadFrameType != null) {
            Kvo.addKvoBinding((KvoSource)otherHeadFrameType, (Object)((Object)this), (String)"onOtherHeadFrameTypeUpdate");
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onOtherHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.ivAvatar != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame));
        }
    }

    public void onClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && this.getEventCallback() != null) {
            this.getEventCallback().onUserAvatarClick(((ChatMessageData)v.getTag((int)R.id.chat_message_data)).message.getUid(), 8);
        }
    }

    public boolean onLongClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData) {
            if (this.getEventCallback() != null) {
                this.getEventCallback().onChatMessageItemLongClick((ChatMessageData)v.getTag(R.id.chat_message_data), v);
            }
            return true;
        }
        return false;
    }
}

