/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.hiyo.emotion.base.emoji.EmojiEntity;
import com.yy.im.R;
import java.util.ArrayList;
import java.util.List;

public class EmotionAdapter
extends BaseAdapter {
    private Context mContext;
    private List<EmojiEntity> mEmotionArray = new ArrayList<EmojiEntity>();

    public EmotionAdapter(Context context) {
        this.mContext = context;
    }

    public void setDatas(List<EmojiEntity> list) {
        if (list != null && list.size() > 0) {
            this.mEmotionArray.clear();
            this.mEmotionArray.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        return this.mEmotionArray.size();
    }

    public Object getItem(int i) {
        return this.mEmotionArray.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int position, View convertView, ViewGroup viewGroup) {
        Holder holder = null;
        if (null == convertView) {
            holder = new Holder();
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_msg_emotion_item, null);
            holder.tvEmotion = (RecycleImageView)convertView.findViewById(R.id.emotion);
            convertView.setTag((Object)holder);
        } else {
            holder = (Holder)convertView.getTag();
        }
        EmojiEntity emojiEntity = this.mEmotionArray.get(position);
        if (emojiEntity.getId() == 0) {
            holder.tvEmotion.setImageResource(R.drawable.ww_emotion_del);
        } else {
            holder.tvEmotion.setImageResource(emojiEntity.getId());
        }
        return convertView;
    }

    private static final class Holder {
        RecycleImageView tvEmotion;

        private Holder() {
        }
    }
}

