/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.core.util.Pair;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.PlatformPermissionModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ISocialMediaService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.IQueryOnlineCallBack;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.popmenu.OnItemClickListener;
import com.yy.hiyo.emotion.base.gif.bean.Gif;
import com.yy.hiyo.emotion.base.gif.bean.GifSet;
import com.yy.hiyo.game.base.streakwin.StreakWinData;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.data.IIMdata;
import com.yy.hiyo.login.base.IBindThirdPartyAccountCallBack;
import com.yy.im.R;
import com.yy.im.chatim.OfficialEventHandler;
import com.yy.im.chatim.OfficialModule;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.BaseMessageController;
import com.yy.im.module.room.ExpiredMsgFilter;
import com.yy.im.module.room.IMessageOperationListener;
import com.yy.im.module.room.IUserOperationListener;
import com.yy.im.module.room.OfficialMessageWindow;
import com.yy.im.module.room.callback.Callback;
import com.yy.im.module.room.callback.IOfficialMsgUiCallback;
import com.yy.im.module.room.data.OfficialGamePushInfo;
import com.yy.im.module.room.utils.ChatMessageEventHandler;
import com.yy.im.msg.ImNotificationDef;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.msg.PullType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressLint(value={"LoopUsage"})
public class OfficialMessageController
extends BaseMessageController
implements IUserOperationListener,
IOfficialMsgUiCallback {
    private static final String TAG = "OfficialMessageControll";
    private Context mContext;
    private OfficialMessageWindow mOfficialMessageWindow;
    private PopupWindow mPopupWindow;
    private boolean mIsFromPush = false;
    private OfficialModule mOfficialModule;
    private int type = 0;
    private IBindThirdPartyAccountCallBack mBindThirdPartyAccountCallBack = new IBindThirdPartyAccountCallBack(){

        public void onSuccess() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)OfficialMessageController.this.mContext, (int)R.string.bind_fb_success, (int)1);
                }
            });
        }

        public void onCancel() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)OfficialMessageController.this.mContext, (int)R.string.fb_bind_cancel, (int)1);
                }
            });
        }

        public void onError(int errorCode, Exception e) {
            if (OfficialMessageController.this.type == 0) {
                OfficialMessageController.this.handleFBBindError(errorCode);
            } else if (OfficialMessageController.this.type == 1) {
                // empty if block
            }
        }
    };

    public OfficialMessageController(Environment env) {
        super(env);
        this.mContext = env.getContext();
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_NEW_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_ADD_NEW_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_UPDATE_MSG, (INotify)this);
    }

    public void handleMessage(Message msg) {
        Bundle bundle = msg.getData();
        if (bundle != null) {
            if (bundle.containsKey("target_uid")) {
                this.setMTargetUid(bundle.getLong("target_uid"));
            }
            if (bundle.containsKey("xiaolang_from_push")) {
                this.mIsFromPush = bundle.getBoolean("xiaolang_from_push");
            }
        }
        if (msg.what == AppbaseMsgDef.GOTO_OFFICIAL_MESSAGE_PAGE) {
            this.showOfficialMessageWindow();
        }
    }

    public void notify(Notification notification) {
        ImMessageDBBean imMessage;
        super.notify(notification);
        if (notification.id == ImNotificationDef.IM_RECEIVE_NEW_MSG) {
            MLog.info((Object)TAG, (String)"\u6536\u5230\u5b98\u65b9\u53f7\u6d88\u606f:", (Object[])new Object[0]);
            if (this.mOfficialMessageWindow != null) {
                this.mOfficialMessageWindow.getPager().onReceiveMessage();
            }
        } else if (notification.id == ImNotificationDef.IM_ADD_NEW_MSG) {
            ImMessageDBBean imMessage2 = (ImMessageDBBean)notification.extObj;
            if (imMessage2 != null && this.mOfficialMessageWindow != null && imMessage2.getSessionId() != null && imMessage2.getSessionId().equals(Utils.getSessionId((long)AccountUtil.getUid(), (long)this.getMTargetUid()))) {
                this.mOfficialMessageWindow.getPager().onSendingMessage(imMessage2);
            }
        } else if (notification.id == ImNotificationDef.IM_UPDATE_MSG && (imMessage = (ImMessageDBBean)notification.extObj) != null && this.mOfficialMessageWindow != null && imMessage.getToUserId() == this.getMTargetUid()) {
            this.mOfficialMessageWindow.getPager().onUpdateMessage(imMessage);
        }
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        if (this.mOfficialModule != null) {
            this.mOfficialModule.onWindowHidden();
        }
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_EXIT_CHAT_PAGE, (Object)this.getMTargetUid()));
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (this.mOfficialModule != null) {
            this.mOfficialModule.onWindowResume();
        }
        MLog.info((Object)TAG, (String)"onWindowShown", (Object[])new Object[0]);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ENTER_CHAT_PAGE, (Object)this.getMTargetUid()));
        if (this.getServiceManager() != null && this.getServiceManager().getService(ImService.class) != null) {
            ((ImService)this.getServiceManager().getService(ImService.class)).getReceiveMsg().pullMsg(PullType.Default.getValue());
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "official_show"));
    }

    protected boolean onWindowBackKeyEvent() {
        if (this.mOfficialMessageWindow != null && this.mOfficialMessageWindow.getPager().onBackPressed()) {
            return true;
        }
        if (this.mPopupWindow != null && this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
            return true;
        }
        return false;
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mOfficialModule != null) {
            this.mOfficialModule.onWindowDestroy();
            this.mOfficialModule = null;
        }
        if (this.mPopupWindow != null) {
            this.mPopupWindow.dismiss();
            this.mPopupWindow = null;
        }
        if (this.mOfficialMessageWindow != null) {
            this.mOfficialMessageWindow = null;
        }
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        if (this.mOfficialModule != null) {
            this.mOfficialModule.onWindowAttach();
        }
    }

    private void showOfficialMessageWindow() {
        OfficialMessageWindow window = this.mOfficialMessageWindow;
        if (window != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)window);
        }
        ((ISocialMediaService)this.getServiceManager().getService(ISocialMediaService.class)).sendOfficialIM();
        this.mOfficialModule = new OfficialModule((DefaultController)this, new OfficialEventHandler(this));
        this.mOfficialMessageWindow = new OfficialMessageWindow(this.mContext, (UICallBacks)this, this, this, this.getMTargetUid(), this.mOfficialModule.getOfficialContext());
        this.mWindowMgr.pushWindow((AbstractWindow)this.mOfficialMessageWindow, true);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "show_offical_im").put("push_position", "1"));
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035545").put("function_id", "show"));
        NotificationCenter.getGlobalInstance().notify(NotificationCenter.getGlobalInstance().obtainNotification(NotificationIdDef.N_OFFICIAL_MSG_WINDOW_OPENED, (Object)this.getMTargetUid()));
    }

    @Override
    public void requestUserInfo(List<Long> uids, OnKSProfileListCallback callback) {
        YYTaskExecutor.execute(() -> ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).requestUserInfosFromServer(uids, callback));
    }

    @Override
    public void getOnlineStatus(ArrayList<Long> uidList, IQueryOnlineCallBack callback) {
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getOnlineStatus(uidList, callback);
    }

    @Override
    public void onBackButtonPressed(View v) {
        if (this.mOfficialMessageWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mOfficialMessageWindow);
            this.mOfficialMessageWindow = null;
        }
    }

    @Override
    public void onSelectedImageButtonClick() {
        super.onSelectedImageButtonClick();
    }

    @Override
    public void onSendingImageMsg(ChatMessageData data2) {
        if (this.mOfficialMessageWindow != null) {
            this.mOfficialMessageWindow.getPager().onSendingImageMsg(data2);
        }
    }

    @Override
    public void onUpdateMessage(ImMessageDBBean imMessage) {
        if (this.mOfficialMessageWindow != null) {
            this.mOfficialMessageWindow.getPager().onUpdateMessage(imMessage);
        }
    }

    @Override
    public void onUserAvatarClick(long uid) {
    }

    @Override
    public void onJumpToWebClick(String url, String title) {
        ChatMessageEventHandler.onJumpToWebClick(url, title);
    }

    @Override
    public void onStreakWinMsgClick(String data2) {
        ChatMessageEventHandler.onStreakWinMsgClick(data2);
    }

    @Override
    public void onChatMessageItemLongClick(View v, final ChatMessageData item) {
        String[] items = new String[]{ResourceUtils.getString((int)R.string.im_copy_message), ResourceUtils.getString((int)R.string.im_delete_message)};
        int[] txtColors = new int[]{-16055035, -16055035};
        this.mPopupWindow = this.mDialogLinkManager.showPopupMenuDialog(v, items, txtColors, false, new OnItemClickListener(){

            public void onItemClick(PopupWindow popupWindow, int position) {
                switch (position) {
                    case 0: {
                        SystemUtils.initialize((Context)OfficialMessageController.this.mContext);
                        if (item.message.getContentType() == 2) {
                            String url = item.message.getContent();
                            int[] size = item.message.getImageSize();
                            if (size != null) {
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("width", size[0] + "");
                                params.put("height", size[1] + "");
                                url = Utils.appendParamsToUrl((String)url, params);
                            }
                            SystemUtils.setClipboardTextToSystem((String)("[image]" + url + "[/image]"));
                            break;
                        }
                        SystemUtils.setClipboardTextToSystem((String)item.message.getContent());
                        break;
                    }
                    case 1: {
                        MyBox box2;
                        if (OfficialMessageController.this.mOfficialMessageWindow != null) {
                            OfficialMessageController.this.mOfficialMessageWindow.getPager().notifyChatMessageDataDelete(item);
                        }
                        if ((box2 = ((IDBService)OfficialMessageController.this.getServiceManager().getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class)) == null) {
                            return;
                        }
                        box2.getAll(new MyBox.IGetItemsCallBack(){

                            public void onLoaded(ArrayList dbList) {
                                if (dbList != null && dbList.size() > 0) {
                                    for (Object data2 : dbList) {
                                        ImMessageDBBean msg = (ImMessageDBBean)data2;
                                        if (msg == null || msg.getSendTime() != item.message.getSendTime()) continue;
                                        box2.deleteItem((BaseDBBean)msg);
                                    }
                                }
                            }
                        });
                        break;
                    }
                }
            }
        });
        if (this.mOfficialMessageWindow != null && this.mPopupWindow != null) {
            int touchY = this.mOfficialMessageWindow.getTouchDownY();
            int touchX = this.mOfficialMessageWindow.getTouchDownX();
            this.mPopupWindow.showAtLocation((View)this.mOfficialMessageWindow, 0, touchX - ResolutionUtils.dip2Px((float)150.0f), touchY - ResolutionUtils.dip2Px((float)140.0f));
        }
    }

    @Override
    public void onChatMessageImageClick(View v, ChatMessageData data2) {
        ChatMessageEventHandler.onChatMessageImageClick(v, data2);
    }

    @Override
    public void onLoadHistoryMessageData(final String sessionId2, final IMessageOperationListener.IMessageDbOperationListener listener) {
        if (listener == null) {
            return;
        }
        final MyBox msgBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class);
        if (msgBox == null) {
            return;
        }
        msgBox.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<ImMessageDBBean>(){

            public void onLoaded(ArrayList<ImMessageDBBean> originList) {
                if (originList == null || originList.size() <= 0) {
                    listener.onQueryHistorySuccess(new ArrayList<ChatMessageData>(1));
                    OfficialMessageController.this.pullAutoMsg();
                    return;
                }
                boolean hasUnreadMsg = false;
                boolean itemHasChanged = false;
                ArrayList<ImMessageDBBean> dbList = new ExpiredMsgFilter().filterExpired(originList);
                final ArrayList<ImMessageDBBean> itemsNeedUpdateDb = new ArrayList<ImMessageDBBean>(dbList.size());
                final ArrayList<ChatMessageData> results = new ArrayList<ChatMessageData>(dbList.size());
                for (ImMessageDBBean data2 : dbList) {
                    ImMessageDBBean msg = data2;
                    if (!msg.isRead()) {
                        hasUnreadMsg = true;
                        msg.setRead(true);
                        itemHasChanged = true;
                    }
                    if (msg != null && msg.getSessionId() != null && msg.getSessionId().equals(sessionId2)) {
                        if (msg.getStatus() == 2) {
                            msg.setStatus(1);
                            itemHasChanged = true;
                        }
                        if (msg.getMsgType() == 20) {
                            OfficialGamePushInfo officialGamePushInfo = (OfficialGamePushInfo)JsonParser.parseJsonObject((String)msg.getReserve3(), OfficialGamePushInfo.class);
                            msg.setExtObj((Object)officialGamePushInfo);
                        }
                        results.add(new ChatMessageData(msg));
                        OfficialMessageController.this.reportReceiveMsg(msg);
                    }
                    if (!itemHasChanged) continue;
                    itemsNeedUpdateDb.add(msg);
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (itemsNeedUpdateDb.size() > 0) {
                            msgBox.updateItems((List)itemsNeedUpdateDb, true);
                        }
                    }
                });
                Collections.sort(results, ChatMessageData.getIdAscComparator());
                listener.onQueryHistorySuccess(results);
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        OfficialMessageController.this.reportOfficialMsgGameToChannelGuide(results);
                        OfficialMessageController.this.reportStreakWinData(results);
                    }
                });
                if (!hasUnreadMsg && !OfficialMessageController.this.mIsFromPush) {
                    MLog.info((Object)OfficialMessageController.TAG, (String)"\u62c9\u53d6\u81ea\u52a8\u56de\u590d", (Object[])new Object[0]);
                    OfficialMessageController.this.pullAutoMsg();
                }
            }
        });
    }

    private void pullAutoMsg() {
        if (this.getServiceManager() != null && this.getServiceManager().getService(ImService.class) != null) {
            ((ImService)this.getServiceManager().getService(ImService.class)).getReceiveMsg().pullMsg(PullType.AutoBack.getValue());
        }
    }

    private void reportStreakWinData(List<ChatMessageData> results) {
        if (results == null) {
            return;
        }
        ArrayList<String> reportMsgId = new ArrayList<String>(results.size());
        ArrayList<String> reportJumpUrlList = new ArrayList<String>(results.size());
        for (ChatMessageData chatMessageData : results) {
            if (chatMessageData == null) continue;
            if (chatMessageData.message != null && chatMessageData.message.getMsgType() == 15 && !FP.empty((CharSequence)chatMessageData.message.getReserve1())) {
                try {
                    StreakWinData streakWinData = (StreakWinData)JsonParser.parseJsonObject((String)chatMessageData.message.getReserve1(), StreakWinData.class);
                    if (streakWinData != null) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024413").put("function_id", "msg_show").put("win_times", String.valueOf(streakWinData.getCount())));
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)"reportStreakWinData", (Throwable)e, (Object[])new Object[0]);
                }
            } else if (chatMessageData.message != null && chatMessageData.message.getMsgType() == 1) {
                try {
                    Uri uri = Uri.parse((String)chatMessageData.message.getJumpUrl());
                    if (uri == null) continue;
                    String type = uri.getQueryParameter("type");
                    String gid = uri.getQueryParameter("gameid");
                    if ("Single".equalsIgnoreCase(type)) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025737").put("function_id", "msg_show").put("page_id", "middle_page").put("gid", gid));
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)"reportStreakWinData", (Throwable)e, (Object[])new Object[0]);
                }
            }
            if (chatMessageData.message == null || chatMessageData.message.getUid() != 10L) continue;
            reportMsgId.add(String.valueOf(chatMessageData.message.getMsgId()));
            reportJumpUrlList.add(chatMessageData.message.getJumpUrl());
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026441").put("function_id", "show_message").put("message_id", ((Object)reportMsgId).toString()).put("jump_url", ((Object)reportJumpUrlList).toString()));
    }

    @Override
    public void sendTextMsg(String content, long toUserId, String toUserAvatar, String toUserName) {
        super.sendTextMsg(content, toUserId, toUserAvatar, toUserName);
    }

    @Override
    public void onJumpUri(@Nonnull String uri) {
        ChatMessageEventHandler.onJumpUri(uri);
    }

    @Override
    public void toggleGamePush(String gid, boolean isShowNotify, Callback<Pair<String, Boolean>> callback) {
        ChatMessageEventHandler.toggleGamePush(gid, isShowNotify, callback);
    }

    @Override
    public void onJumpToContactQuiz() {
        ChatMessageEventHandler.onJumpToContactQuiz();
    }

    @Override
    public void onJumpHelpCenterOrFeedback(View v, String feedbackContent, String payOrderId) {
        ChatMessageEventHandler.onJumpHelpCenterOrFeedback(v, feedbackContent, payOrderId);
    }

    @Override
    public void onClickGif(GifSet gifSet) {
        if (gifSet != null) {
            Gif nanoGif = gifSet.getNanoGif();
            Gif tinyGif = gifSet.getTinyGif();
            if (nanoGif != null && tinyGif != null) {
                this.sendImgMsg("", nanoGif.getUrl(), "", this.getMTargetUid(), "", "", nanoGif.getWidth(), nanoGif.getHeight(), gifSet.getType(), tinyGif.getUrl(), 0);
            }
        }
    }

    @Override
    public void onJumpIm(Long uid) {
        ChatMessageEventHandler.onJumpIm(uid);
    }

    @Override
    public void bindFb() {
        boolean hasPermission;
        Object object = this.sendMessageSync(BaseMsgDef.MSG_GET_FACEBOOK_BIND_STATU);
        if (object instanceof Boolean && (hasPermission = ((Boolean)object).booleanValue())) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.tips_im_bind_permission_done);
            return;
        }
        this.type = 0;
        ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindFacebook((Object)this.mBindThirdPartyAccountCallBack);
    }

    private void handleFBBindError(int errorCode) {
        YYTaskExecutor.postToMainThread(() -> {
            if (errorCode == 20410) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.fb_err_no_phone_login), (int)1);
            } else if (errorCode == 20413) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.fb_err_account_has_bind_other_phone), (int)1);
            } else if (errorCode == 20412) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.fb_err_phone_has_bind_other_account), (int)1);
            } else if (errorCode == 20422) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.bind_fail_fb_has_been_used), (int)1);
            } else {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.fb_connect_fail), (int)1);
            }
        });
    }

    private void handleZaloBindError(int errorCode) {
    }

    @Override
    public void bindContact() {
        if (PermissionHelper.hasContactPermission((Activity)((FragmentActivity)this.mContext))) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.tips_im_bind_permission_done);
        } else {
            PermissionHelper.requestContactPermission((Activity)((FragmentActivity)this.mContext), (IPermissionListener)new IPermissionListener(){

                public void onPermissionGranted(@NonNull String[] permission) {
                    ToastUtils.showToast((Context)OfficialMessageController.this.mContext, (int)R.string.tips_im_bind_permission_success);
                }

                public void onPermissionDenied(@NonNull String[] permission) {
                }
            });
        }
    }

    @Override
    public void onJumpHelpCenter(@Nullable String url) {
        ChatMessageEventHandler.onJumpHelpCenter(url);
    }

    @Override
    public void bindZalo() {
        boolean hasPermission;
        Object object = this.sendMessageSync(BaseMsgDef.MSG_ZALO_BIND_ACCOUNT_STATU);
        if (object instanceof Boolean && (hasPermission = ((Boolean)object).booleanValue())) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.tips_im_bind_permission_done);
            return;
        }
        this.type = 1;
        ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindZalo(null);
    }

    @Override
    public List<IIMdata> getMsgData() {
        if (this.mOfficialMessageWindow != null && this.mOfficialMessageWindow.getPager() != null) {
            return this.mOfficialMessageWindow.getPager().getMsgData();
        }
        return null;
    }

    private void reportReceiveMsg(ImMessageDBBean bean) {
        if (bean.getMsgType() == 38) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035545").put("function_id", "msg_receive").put("msg_source", bean.getBindType() == 2 ? "8" : (bean.getBindType() == 0 ? "4" : "5")).put("act_uid", String.valueOf(bean.getToUserId())));
        } else if (bean.getMsgType() == 39) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035545").put("function_id", "msg_receive").put("msg_source", bean.getBindType() == 2 ? "7" : (bean.getBindType() == 0 ? "2" : "3")).put("act_uid", String.valueOf(bean.getToUserId())));
        }
    }

    private void reportOfficialMsgGameToChannelGuide(List<ChatMessageData> results) {
        for (ChatMessageData chatMessageData : results) {
            if (chatMessageData == null || chatMessageData.message == null) continue;
            if (chatMessageData.message.getMsgType() == 49) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035809").put("function_id", "guide_goto_channel_show").put("gid", chatMessageData.message.getGameId()).put("remind_type", Integer.toString(1)));
                break;
            }
            if (chatMessageData.message.getMsgType() != 46) break;
            String isNewUser = TimeUtils.isSameDay((long)AccountUtil.getRegisterTime(), (long)System.currentTimeMillis()) ? "1" : "2";
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20044725").put("function_id", "hago_im_content_show").put("content_type", "1").put("user_type", isNewUser));
            break;
        }
    }
}

