/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room;

import android.text.TextUtils;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.IMContentConfig;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.im.ImService;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.utils.ChatMessageDataGenerator;
import com.yy.im.msg.ImNotificationDef;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class IMGameInvitePresenter {
    private static final String TAG = "IMGameInvitePresenter";
    private static final long INVITE_INTERVAL = 30000L;
    private IReadyGameToInvite mReadyGameToInviteListener;
    private String mLastClickInviteGameId;
    private ConcurrentHashMap<String, Integer> mRecordPKFromImMsg;
    private ConcurrentHashMap<String, Integer> mPrecipitationSource;
    private List<String> mContentList;
    private HashMap<String, InvitePersistTask> mPersistTaskMap = new HashMap();
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public IMGameInvitePresenter(IReadyGameToInvite inviteListener) {
        this.mReadyGameToInviteListener = inviteListener;
        this.mRecordPKFromImMsg = new ConcurrentHashMap();
        this.mPrecipitationSource = new ConcurrentHashMap();
    }

    public void sendLocalGameInviteMsg(GameMessageModel messageModel, boolean notifyChatList, int source) {
        ChatMessageData chatMessageData;
        if (messageModel == null) {
            return;
        }
        if (messageModel.getGameTimeLimitType() == 2) {
            return;
        }
        String gameId = messageModel.getGameId();
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo != null && gameInfo.getGameMode() == 6) {
            return;
        }
        boolean isSelf = messageModel.getFrom() == 0;
        int opt = messageModel.getType();
        MLog.info((Object)TAG, (String)"sendLocalGameInviteMsg gid: %s  isSelf: %s  opt: %s toUserUid: %s  toUserName: %s  content: %s", (Object[])new Object[]{messageModel.getGameId(), isSelf, opt, messageModel.getToUserId(), messageModel.getToUserName(), messageModel.getContent()});
        ChatMessageData imInviteMsg = null;
        if (!this.isShowGameInviteMsg(isSelf, opt)) {
            chatMessageData = this.generateLocalSystemText(messageModel.getContent(), messageModel.getToUserId());
        } else {
            long currentTime = System.currentTimeMillis();
            chatMessageData = this.generateLocalOverdueGameInviteMsg(messageModel.getToUserName(), messageModel.getToUserId(), messageModel.getGameName(), messageModel.getGameId(), currentTime, source);
            if (source == 1) {
                imInviteMsg = this.generateLocalSystemText(ResourceUtils.getString((int)R.string.tips_precipitation_im_game_invite_sys_text), messageModel.getToUserId());
            } else if (NAB.B.equals((Object)NewABDefine.GAME_AI_MSG.getTest())) {
                String textContent = this.randImContent();
                if (!TextUtils.isEmpty((CharSequence)textContent)) {
                    imInviteMsg = ChatMessageDataGenerator.generateLocalText(messageModel.getToUserId(), textContent, ++currentTime, 0);
                }
                MLog.info((Object)TAG, (String)"textContent = %s mMessageListener is null %s", (Object[])new Object[]{textContent});
            }
            if (!this.canPersistInviteMessage(chatMessageData)) {
                chatMessageData = null;
            }
        }
        if (ServiceManagerProxy.getServiceManager() != null && chatMessageData != null) {
            if (source == 1 && imInviteMsg != null) {
                MLog.info((Object)TAG, (String)"insertMsg  is imInviteMsg", (Object[])new Object[0]);
                this.insertMsg(imInviteMsg);
            }
            this.insertMsg(chatMessageData);
            if (imInviteMsg != null && source != 1) {
                MLog.info((Object)TAG, (String)"insertMsg  is imInviteMsg", (Object[])new Object[0]);
                this.insertMsg(imInviteMsg);
            }
            if (notifyChatList) {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (Object)chatMessageData.message));
            }
        }
    }

    private void insertMsg(ChatMessageData chatMessageData) {
        ((ImService)ServiceManagerProxy.getServiceManager().getService(ImService.class)).getSendService().addMessageToLocalDb(chatMessageData.message);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (Object)chatMessageData.message));
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ADD_NEW_MSG, (Object)chatMessageData.message));
    }

    private boolean canPersistInviteMessage(ChatMessageData messageData) {
        if (messageData == null) {
            return false;
        }
        ImMessageDBBean messageDBBean = messageData.message;
        InvitePersistTask task = this.mPersistTaskMap.get(messageDBBean.getGameId());
        if (task == null) {
            task = new InvitePersistTask(messageDBBean.getGameId());
            task.start(30000L);
            return true;
        }
        MLog.debug((Object)TAG, (String)("canPersistInviteMessage no, gameId: " + messageDBBean.getGameId()), (Object[])new Object[0]);
        return false;
    }

    private String randImContent() {
        if (this.getImContents() == null || this.mContentList.size() <= 0) {
            MLog.info((Object)TAG, (String)"randImContent  is null", (Object[])new Object[0]);
            return "";
        }
        int index = (int)(Math.random() * (double)this.mContentList.size());
        if (index < this.mContentList.size()) {
            return this.mContentList.get(index);
        }
        return this.mContentList.get(0);
    }

    private List<String> getImContents() {
        if (this.mContentList != null) {
            return this.mContentList;
        }
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.IM_INVITE_CONFIG);
        if (config instanceof IMContentConfig && ((IMContentConfig)config).getImContentList() != null) {
            List languageList = ((IMContentConfig)config).getImContentList().getLangList();
            if (languageList == null) {
                return null;
            }
            for (IMContentConfig.ContentResource langList : languageList) {
                if (langList == null || langList.getSource() == null || !TextUtils.equals((CharSequence)SystemUtils.getLang(), (CharSequence)langList.getLang())) continue;
                this.mContentList = langList.getSource();
                break;
            }
        }
        return this.mContentList;
    }

    private ChatMessageData generateLocalSystemText(String content, long uid) {
        if (FP.empty((CharSequence)content) || uid <= 0L) {
            return null;
        }
        ChatMessageData chatMessageData = ChatMessageDataGenerator.generateLocalSystemData(content, uid);
        return chatMessageData;
    }

    private ChatMessageData generateLocalOverdueGameInviteMsg(String userName, long uid, String gameName, String gameId, long currentTime, int source) {
        if (FP.empty((CharSequence)userName) || uid <= 0L || FP.empty((CharSequence)gameId) || FP.empty((CharSequence)gameName)) {
            return null;
        }
        ChatMessageData chatMessageData = ChatMessageDataGenerator.generateLocalOverdueImGameInviteData(userName, uid, gameName, gameId, currentTime, source);
        return chatMessageData;
    }

    private boolean isShowGameInviteMsg(boolean isSelf, int opt) {
        if (isSelf && opt == 1) {
            return true;
        }
        return !isSelf && opt == 0;
    }

    public void onClickInvite(String gid, int source) {
        MLog.info((Object)TAG, (String)"onClickInvite gid: %s", (Object[])new Object[]{gid});
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gid);
        if (gameInfo == null) {
            MLog.error((Object)TAG, (String)"onClickInvite gameInfo is null gid: %s", (Object[])new Object[]{gid});
            return;
        }
        gameInfo.setPrecipitationSource(source);
        this.mLastClickInviteGameId = gid;
        boolean isDownloaded = ((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).isGameValid(gameInfo);
        MLog.info((Object)TAG, (String)"onClickInvite gid: %s  isDownLoad: %s", (Object[])new Object[]{gid, isDownloaded});
        if (!isDownloaded) {
            gameInfo.downloadInfo.setFrom(GameDownloadInfo.DownloadFrom.home);
            ((IGameService)ServiceManagerProxy.getServiceManager().getService(IGameService.class)).downloadGame(gameInfo);
            this.mBinder.singleBindSourceTo((KvoSource)gameInfo.downloadInfo);
        } else {
            this.onReadyToInvite(gameInfo);
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class, thread=1)
    public void onState(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (event.newValue() == GameDownloadInfo.DownloadState.download_finish) {
            MLog.info((Object)TAG, (String)"download finish gid: %s  mLastClickGid: %s", (Object[])new Object[]{info.gameId, this.mLastClickInviteGameId});
            if (StringUtils.equal((String)info.gameId, (String)this.mLastClickInviteGameId)) {
                GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.mLastClickInviteGameId);
                this.onReadyToInvite(gameInfo);
            }
        } else if (info.getState() == GameDownloadInfo.DownloadState.download_fail) {
            String msg = StringUtils.formatWitUSLocal((String)"{\"errorCode\": %d, \"errorInfo\": %s}", (Object[])new Object[]{info.downloadErrCode, info.downloadErrInfo});
            MLog.info((Object)TAG, (String)"download gid: %s fail msg: %s", (Object[])new Object[]{info.gameId, msg});
        }
    }

    private void onReadyToInvite(GameInfo gameInfo) {
        if (this.mReadyGameToInviteListener != null) {
            MLog.info((Object)TAG, (String)"onReadyToInvite start invite gid: %s", (Object[])new Object[]{gameInfo.gid});
            this.mReadyGameToInviteListener.onReadyGame(gameInfo);
        }
    }

    public void addPkIdFromMsg(String pkId, int source) {
        MLog.debug((Object)TAG, (String)"addPkIdFromMsg pkId: %s, source: %s", (Object[])new Object[]{pkId, source});
        this.mRecordPKFromImMsg.put(pkId, source);
    }

    public void addPkIdWithPrecipitationSource(String pkId, int source) {
        MLog.debug((Object)TAG, (String)"addPkIdFromMsg pkId: %s, source: %s", (Object[])new Object[]{pkId, source});
        this.mPrecipitationSource.put(pkId, source);
    }

    public int getFromMsgByPkId(String pkId) {
        if (FP.empty((CharSequence)pkId) || this.mRecordPKFromImMsg == null) {
            return 99;
        }
        Integer value = this.mRecordPKFromImMsg.get(pkId);
        if (value == null) {
            return 99;
        }
        return value;
    }

    public int getPrecipitationSourceByPkId(String pkId) {
        if (FP.empty((CharSequence)pkId) || this.mPrecipitationSource == null) {
            return 0;
        }
        Integer value = this.mPrecipitationSource.get(pkId);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void onRelease() {
        this.mBinder.clearAllKvoConnections();
        this.mLastClickInviteGameId = null;
        this.mReadyGameToInviteListener = null;
        this.mRecordPKFromImMsg.clear();
    }

    public class InvitePersistTask
    implements Runnable {
        private String mGameId;

        public InvitePersistTask(String gameId) {
            this.mGameId = gameId;
        }

        @Override
        public void run() {
            MLog.debug((Object)IMGameInvitePresenter.TAG, (String)("InvitePersistTask finish remove gameId: " + this.mGameId), (Object[])new Object[0]);
            IMGameInvitePresenter.this.mPersistTaskMap.remove(this.mGameId);
        }

        public void start(long interval) {
            IMGameInvitePresenter.this.mPersistTaskMap.put(this.mGameId, this);
            YYTaskExecutor.postToMainThread((Runnable)this, (long)interval);
        }
    }

    public static interface IReadyGameToInvite {
        public void onReadyGame(GameInfo var1);
    }
}

