/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.model;

import com.yy.appbase.data.ImMessageDBBean;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.im.R;
import com.yy.im.model.ChatSession;
import com.yy.im.viewmodel.ChatSessionViewModel;
import java.util.ArrayList;

public class PublicChatSession
extends ChatSession<ImMessageDBBean> {
    public PublicChatSession(ImMessageDBBean mLastMessage) {
        super(3, mLastMessage);
    }

    @Override
    public void initial() {
        ImMessageDBBean msg = (ImMessageDBBean)this.getLastMessage();
        this.setAvatarType(1);
        this.setSessionId(msg.getSessionId());
        String content = msg.getContent();
        this.setTitleBold(true);
        this.setSubTitle((CharSequence)EmojiManager.INSTANCE.getExpressionString(content));
        if (msg.getContentType() == 2) {
            content = ResourceUtils.getString((int)R.string.img_tag);
            msg.setContent(content);
            this.setSubTitle(content);
        }
        this.setTitle(msg.getUid() == 14L ? ResourceUtils.getString((int)R.string.title_sign_assistant) : ResourceUtils.getString((int)R.string.public_chat_name));
        this.setDefaultAvatar(msg.getUid() == 14L ? R.drawable.icon_sign_assistant : R.drawable.icon_public_msg_avatar);
        this.setTimeStr(msg.getSendTime());
        this.setPresentationTime(msg.getSendTime());
        long targetUid = this.getTargetUid();
        this.setUid(targetUid);
        if (ChatSessionViewModel.mCurrentChatUid != targetUid) {
            this.setUnReadCounts(this.getUnReadCounts() + 1);
        } else if (this.getUnReadCounts() != 0) {
            this.setUnReadCounts(0);
        }
        if (msg.getExtObj() instanceof Boolean && ((Boolean)msg.getExtObj()).booleanValue()) {
            this.setUnReadCounts(0);
        }
        this.setAvatarUrls(new ArrayList<String>());
    }

    public long getTargetUid() {
        ImMessageDBBean msg = (ImMessageDBBean)this.getLastMessage();
        return msg.isSendByMe() ? msg.getToUserId() : msg.getUid();
    }
}

