/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.model;

import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.im.R;
import com.yy.im.model.ChatSession;
import java.util.ArrayList;

public class GamePushChatSession
extends ChatSession<ImMessageDBBean> {
    public GamePushChatSession(ImMessageDBBean mLastMessage) {
        super(11, mLastMessage);
    }

    @Override
    public void initial() {
        ImMessageDBBean msg = (ImMessageDBBean)this.getLastMessage();
        if (msg == null || FP.empty((CharSequence)msg.getReserve1())) {
            MLog.error((Object)"GamePushChatSession", (String)"initial data error!!!!", (Object[])new Object[0]);
            return;
        }
        String gameId = msg.getReserve1();
        this.setSubTitle((CharSequence)EmojiManager.INSTANCE.getExpressionString(msg.getContent()));
        this.setSessionId(msg.getSessionId());
        this.setTimeStr(msg.getSendTime());
        this.setPresentationTime(msg.getSendTime());
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo == null) {
            MLog.error((Object)"GamePushChatSession", (String)"initial gameInfo is null!!!!", (Object[])new Object[0]);
            return;
        }
        this.setAvatarType(0);
        String url = !FP.empty((CharSequence)msg.getImageUrl()) ? msg.getImageUrl() : (FP.empty((CharSequence)gameInfo.getIconUrl()) ? gameInfo.getImIconUrl() : gameInfo.getIconUrl());
        ArrayList<String> urls = new ArrayList<String>(1);
        urls.add(url);
        this.setAvatarUrls(urls);
        this.setUnReadCounts(this.getUnReadCounts() + 1);
        String text = msg.getReserve2();
        if (FP.empty((CharSequence)text)) {
            text = gameInfo.getGname();
        }
        this.setTitle(text);
        this.setSmallIcon(R.drawable.icon_tag_game);
    }
}

