/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.model;

import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.im.R;
import com.yy.im.model.ChatSession;
import java.util.ArrayList;

public class CommonMsgChatSession
extends ChatSession<ImMessageDBBean> {
    public CommonMsgChatSession(ImMessageDBBean mLastMessage) {
        super(12, mLastMessage);
    }

    @Override
    public void initial() {
        ImMessageDBBean msg = (ImMessageDBBean)this.getLastMessage();
        if (msg == null || FP.empty((CharSequence)msg.getReserve1())) {
            MLog.error((Object)"GamePushChatSession", (String)"initial data error!!!!", (Object[])new Object[0]);
            return;
        }
        this.setSessionId(msg.getSessionId());
        this.setUnReadCounts(this.getUnReadCounts() + 1);
        this.setTitleBold(true);
        this.setTitle(msg.getReserve2());
        this.setTimeStr(msg.getSendTime());
        this.setPresentationTime(msg.getSendTime());
        if (!FP.empty((CharSequence)msg.getImageUrl())) {
            this.setAvatarType(0);
            String url = msg.getImageUrl();
            ArrayList<String> urls = new ArrayList<String>(1);
            urls.add(url);
            this.setAvatarUrls(urls);
        } else {
            this.setAvatarType(1);
            this.setDefaultAvatar(R.drawable.icon_channel_notic);
        }
        this.updateSubTitle();
    }

    public void updateSubTitle() {
        ImMessageDBBean msg = (ImMessageDBBean)this.getLastMessage();
        if (StringUtils.safeParseBoolean((String)msg.getReserve5())) {
            this.setSmallIcon(R.drawable.icon_channel_tag);
            if (msg.isRead()) {
                this.setSubTitle((CharSequence)EmojiManager.INSTANCE.getExpressionString(msg.getContent()));
            } else {
                String recomStr = ResourceUtils.getString((int)R.string.title_im_channel_recommend);
                SpannableString spannableString = new SpannableString((CharSequence)(recomStr + " " + msg.getContent()));
                spannableString.setSpan((Object)new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.color_ffc102)), 0, recomStr.length(), 17);
                this.setSubTitle((CharSequence)spannableString);
            }
        } else {
            this.setSubTitle((CharSequence)EmojiManager.INSTANCE.getExpressionString(msg.getContent()));
        }
    }
}

