/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.localpush;

import com.google.gson.reflect.TypeToken;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.ImGameMsgContentConfig;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateFormatUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.localpush.ImGameRecordData;
import com.yy.im.localpush.PlayGameInfo;
import com.yy.im.model.ChatSession;
import com.yy.im.model.GamePushChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.session.ISessionPresenter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ImGamePushMsgPresenter {
    private static final String TAG = "ImGamePushMsgPresenter";
    private boolean isNeedGamePush;
    private ImGameRecordData mGameRecordData;
    private static final String FILE_NAME = "ImGameRecordData";
    private volatile boolean isInitData;
    private ISessionPresenter.ISessionCallback mISessionCallback;
    private int entryMsgListCount = 0;
    private IGameLifecycle mIGameLifecycle = new IGameLifecycle(){
        private PlayGameInfo mPlayGameInfo;

        private boolean filterGameType(GameInfo gameInfo) {
            return gameInfo.getGameMode() == 8;
        }

        private boolean isFromGamePush(GamePlayContext context) {
            GameMatchContext matchContext;
            if (context.getFrom() == GameContextDef.JoinFrom.FROM_IM_LOCAL_GAME_SESSION) {
                return true;
            }
            return context.getFrom() == GameContextDef.JoinFrom.FROM_MATCH && (matchContext = context.getPkMatchContext()) != null && matchContext.getFrom() == GameContextDef.JoinFrom.FROM_IM_LOCAL_GAME_SESSION;
        }

        public void onPreloadGame(GamePlayContext context) {
            MLog.info((Object)ImGamePushMsgPresenter.TAG, (String)"onPreloadGame", (Object[])new Object[0]);
        }

        public void onLoadGameFinish(GamePlayContext context, int finishType, DefaultWindow window) {
            if (context == null || context.getGameInfo() == null || FP.empty((CharSequence)context.getGameInfo().gid)) {
                return;
            }
            if (((ImGamePushMsgPresenter)ImGamePushMsgPresenter.this).getGameRecordData().isNotTargetUser) {
                return;
            }
            if (this.filterGameType(context.getGameInfo())) {
                return;
            }
            String gameId = context.getGameInfo().gid;
            MLog.info((Object)ImGamePushMsgPresenter.TAG, (String)"onLoadGameFinish gameId: %s", (Object[])new Object[]{gameId});
            this.mPlayGameInfo = new PlayGameInfo();
            this.mPlayGameInfo.gameId = gameId;
            this.mPlayGameInfo.startTime = System.currentTimeMillis();
            this.mPlayGameInfo.flag = context.getRoomId();
            this.mPlayGameInfo.mFromGamePush = this.isFromGamePush(context);
            Object value = context.getExtendValue("sessionId", (Object)"");
            if (value instanceof String) {
                this.mPlayGameInfo.sessionId = (String)value;
            }
        }

        public void onGameReady(GamePlayContext context) {
            MLog.debug((Object)ImGamePushMsgPresenter.TAG, (String)"onGameReady", (Object[])new Object[0]);
        }

        public void onPlayGameStart(GamePlayContext context) {
            MLog.debug((Object)ImGamePushMsgPresenter.TAG, (String)"onPlayGameStart", (Object[])new Object[0]);
        }

        public void onPlayGameFinish(GamePlayContext context, int finishType) {
            MLog.info((Object)ImGamePushMsgPresenter.TAG, (String)"onPlayGameFinish", (Object[])new Object[0]);
        }

        public void onPreGameExit(GamePlayContext context) {
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            if (context == null || context.getGameInfo() == null || FP.empty((CharSequence)context.getGameInfo().gid)) {
                return;
            }
            if (this.filterGameType(context.getGameInfo())) {
                return;
            }
            if (((ImGamePushMsgPresenter)ImGamePushMsgPresenter.this).getGameRecordData().isNotTargetUser) {
                return;
            }
            String gameId = context.getGameInfo().gid;
            if (this.mPlayGameInfo == null || !StringUtils.equalsIgnoreCase((String)gameId, (String)this.mPlayGameInfo.gameId) || !StringUtils.equalsIgnoreCase((String)context.getRoomId(), (String)this.mPlayGameInfo.flag)) {
                MLog.info((Object)ImGamePushMsgPresenter.TAG, (String)"onGameExited not match start info!!", (Object[])new Object[0]);
                return;
            }
            this.mPlayGameInfo.endTime = System.currentTimeMillis();
            YYTaskExecutor.execute(() -> ImGamePushMsgPresenter.this.updateGameRecordData(this.mPlayGameInfo));
        }

        public void onGameViewAttach(GamePlayContext context) {
        }

        public void onGameViewInit(GamePlayContext context) {
        }

        public void onGameViewDetach(GamePlayContext context) {
        }
    };

    public ImGamePushMsgPresenter(ISessionPresenter.ISessionCallback mISessionCallback) {
        this.isNeedGamePush = NAB.B.equals((Object)NewABDefine.HAGO_ANDROID_GAME_WITHIN2DAY_1029.getTest());
        MLog.info((Object)TAG, (String)"isNeedGamePush: %s  AB: %s", (Object[])new Object[]{this.isNeedGamePush, NewABDefine.HAGO_ANDROID_GAME_WITHIN2DAY_1029.getTest()});
        this.isInitData = false;
        this.mISessionCallback = mISessionCallback;
    }

    public void judgeAndSendGamePush() {
        if (!this.isNeedGamePush) {
            return;
        }
        ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle(this.mIGameLifecycle);
        YYTaskExecutor.execute(() -> {
            String s = FileStorageUtils.getInstance().getStrFromFile(true, FILE_NAME);
            MLog.info((Object)TAG, (String)"judgeAndSendGamePush get str: %s", (Object[])new Object[]{s});
            if (FP.empty((CharSequence)s)) {
                this.isInitData = true;
                return;
            }
            this.mGameRecordData = this.parseJson(s);
            this.isInitData = true;
            if (this.mGameRecordData == null) {
                MLog.error((Object)TAG, (String)"judgeAndSendGamePush mGameRecordData is null!!!", (Object[])new Object[0]);
                return;
            }
            if (this.getGameRecordData().isNotTargetUser) {
                MLog.info((Object)TAG, (String)"judgeAndSendGamePush isNotTargetUser!!!", (Object[])new Object[0]);
                ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).unRegisterGameLifecycle(this.mIGameLifecycle);
                return;
            }
            if (FP.empty(this.getGameRecordData().mGameList)) {
                MLog.info((Object)TAG, (String)"judgeAndSendGamePush mGameList is empty!!!", (Object[])new Object[0]);
                return;
            }
            if (!this.hasTowDayNotPlayGame()) {
                MLog.info((Object)TAG, (String)"judgeAndSendGamePush hasTowDayNotPlayGame is false!!!", (Object[])new Object[0]);
                return;
            }
            if (!this.checkTodayTimes()) {
                MLog.info((Object)TAG, (String)"judgeAndSendGamePush todayNeedJudge is false!!!", (Object[])new Object[0]);
                return;
            }
            String content = this.getContent();
            if (FP.empty((CharSequence)content)) {
                MLog.info((Object)TAG, (String)"judgeAndSendGamePush content is null!!!", (Object[])new Object[0]);
                return;
            }
            ImGameRecordData.ImGamePushData maxPlayGameData = null;
            for (int i = 0; i < this.getGameRecordData().mGameList.size(); ++i) {
                ImGameRecordData.ImGamePushData data2 = this.getGameRecordData().mGameList.get(i);
                if (data2 == null || FP.empty((CharSequence)data2.gameId) || data2.isNotify) continue;
                if (maxPlayGameData == null) {
                    maxPlayGameData = data2;
                    continue;
                }
                if (maxPlayGameData.playCount >= data2.playCount) continue;
                maxPlayGameData = data2;
            }
            if (maxPlayGameData != null) {
                maxPlayGameData.isNotify = true;
                MLog.info((Object)TAG, (String)"maxPlayGameData : %s", (Object[])new Object[]{maxPlayGameData});
                String sessionId2 = "s_10_" + AccountUtil.getUid();
                sessionId2 = Utils.appendGameSessionId((String)sessionId2, (String)TAG);
                MessageBuilder messageBuilder = MessageBuilder.newInstance();
                messageBuilder.content(content).clientSendTime(System.currentTimeMillis()).sendTime(System.currentTimeMillis()).sendByMe(false).msgId(System.currentTimeMillis()).sessionId(sessionId2).fromType(2).msgType(47).uid(10L).reverse1(maxPlayGameData.gameId).reserve2("").reserve3("").reserve4("false").reserve5("false");
                ImMessageDBBean receiveMsg = messageBuilder.builder();
                YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_RECEIVE_COMMON_SESSION, (Object)receiveMsg)));
            }
            MLog.info((Object)TAG, (String)"update todayCheckTime: %s", (Object[])new Object[]{this.getGameRecordData().todayCheckTime});
            this.updateDataToFile();
        });
    }

    private String getContent() {
        ImGameMsgContentConfig config = (ImGameMsgContentConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.IM_GAME_CONTENT_LIST);
        if (config == null || FP.empty((Collection)config.getContentList())) {
            MLog.info((Object)TAG, (String)"getContent config is empty!!!", (Object[])new Object[0]);
            return "";
        }
        long curTime = System.currentTimeMillis();
        int size = config.getContentList().size();
        int index = (int)(curTime % (long)size);
        return (String)config.getContentList().get(index);
    }

    private boolean hasTowDayNotPlayGame() {
        if (this.getGameRecordData().lastPlayGameTime <= 0L) {
            return false;
        }
        long cur = System.currentTimeMillis();
        return cur - this.getGameRecordData().lastPlayGameTime >= 86400000L;
    }

    private boolean checkTodayTimes() {
        Calendar today = Calendar.getInstance();
        String date = DateFormatUtils.dateToString((Date)today.getTime(), (String)"yyyy-MM-dd");
        if (FP.empty((CharSequence)this.getGameRecordData().todayCheckTime)) {
            this.getGameRecordData().todayCheckTime = date + " " + 1;
            return true;
        }
        String[] strs = this.getGameRecordData().todayCheckTime.split(" ");
        if (strs.length != 2) {
            this.getGameRecordData().todayCheckTime = date + " " + 1;
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)strs[0], (String)date)) {
            this.getGameRecordData().todayCheckTime = date + " " + 1;
            return true;
        }
        int count = StringUtils.parseInt((String)strs[1].trim());
        if (count >= 2) {
            return false;
        }
        this.getGameRecordData().todayCheckTime = date + " " + (count + 1);
        return true;
    }

    private ImGameRecordData parseJson(String str) {
        try {
            Type type = new TypeToken<ImGameRecordData>(){}.getType();
            ImGameRecordData data2 = (ImGameRecordData)JsonParser.parseJsonObject((String)str, (Type)type);
            return data2;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"parseJson ex: %s", (Throwable)e, (Object[])new Object[0]);
            return null;
        }
    }

    private void updateGameRecordData(PlayGameInfo playGameInfo) {
        if (!this.isInitData) {
            MLog.info((Object)TAG, (String)"updateGameRecordData mGameRecord not init!!", (Object[])new Object[0]);
            return;
        }
        if (this.getGameRecordData().isNotTargetUser) {
            MLog.info((Object)TAG, (String)"updateGameRecordData mGameRecord isNotTargetUser!!!", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"updateGameRecordData: %s", (Object[])new Object[]{playGameInfo});
        this.getGameRecordData().lastPlayGameId = playGameInfo.gameId;
        this.getGameRecordData().lastPlayGameTime = playGameInfo.endTime;
        if (this.getGameRecordData().mGameList == null) {
            this.getGameRecordData().mGameList = new ArrayList<ImGameRecordData.ImGamePushData>();
        }
        boolean hasContainer = false;
        for (int i = 0; i < this.getGameRecordData().mGameList.size(); ++i) {
            ImGameRecordData.ImGamePushData gameData = this.getGameRecordData().mGameList.get(i);
            if (gameData == null || FP.empty((CharSequence)gameData.gameId)) continue;
            if (StringUtils.equalsIgnoreCase((String)gameData.gameId, (String)playGameInfo.gameId)) {
                ++gameData.playCount;
                gameData.lastPlayTime = playGameInfo.endTime;
                hasContainer = true;
            }
            gameData.isNotify = false;
        }
        if (!hasContainer) {
            ImGameRecordData.ImGamePushData data2 = new ImGameRecordData.ImGamePushData();
            data2.gameId = playGameInfo.gameId;
            data2.playCount = 1;
            data2.isNotify = false;
            data2.lastPlayTime = playGameInfo.endTime;
            this.getGameRecordData().mGameList.add(data2);
        }
        if (playGameInfo.mFromGamePush) {
            long costTime = playGameInfo.endTime - playGameInfo.startTime;
            if (costTime >= 60000L) {
                this.getIgnorePushCondition().notClickAndGameShortTime = 0;
                if (this.entryMsgListCount > 0) {
                    this.entryMsgListCount = 0;
                }
            } else {
                GamePushChatSession session;
                String sessionId2 = playGameInfo.sessionId;
                MLog.info((Object)TAG, (String)"updateGameRecordData sessionId: %s", (Object[])new Object[]{sessionId2});
                if (FP.empty((CharSequence)sessionId2) || this.mISessionCallback == null) {
                    return;
                }
                ChatSession chatSession = this.mISessionCallback.getTargetSession(sessionId2);
                if (chatSession != null && chatSession instanceof GamePushChatSession && (session = (GamePushChatSession)chatSession).getLastMessage() != null && StringUtils.equalsIgnoreCase((String)((ImMessageDBBean)session.getLastMessage()).getReserve5(), (String)"false") && ((ImMessageDBBean)session.getLastMessage()).getFromType() == 2) {
                    this.addNotClickAndGameShortTime(session, false);
                }
            }
            this.getIgnorePushCondition().ignoreMsgCount = 0;
            MLog.info((Object)TAG, (String)"updateGameRecordData costTime: %s  gid: %s", (Object[])new Object[]{costTime, playGameInfo.gameId});
        }
        this.updateDataToFile();
    }

    public void ignoreOrDelGamePush() {
        if (!this.isInitData) {
            return;
        }
        if (this.getGameRecordData().isNotTargetUser) {
            return;
        }
        ++this.getIgnorePushCondition().ignoreMsgCount;
        if (this.getIgnorePushCondition().ignoreMsgCount >= 3) {
            MLog.info((Object)TAG, (String)"ignoreOrDelGamePush set isNotTargetUser!!!", (Object[])new Object[0]);
            this.getGameRecordData().isNotTargetUser = true;
        }
        MLog.info((Object)TAG, (String)"ignoreOrDelGamePush ignoreCount: %s", (Object[])new Object[]{this.getIgnorePushCondition().ignoreMsgCount});
        this.updateDataToFile();
    }

    public void entryMsgListPage() {
        if (!this.isInitData) {
            return;
        }
        if (this.mISessionCallback == null) {
            MLog.error((Object)TAG, (String)"entryMsgListPage error mISessionCallback == null", (Object[])new Object[0]);
            return;
        }
        if (this.getGameRecordData().isNotTargetUser) {
            MLog.info((Object)TAG, (String)"entryMsgListPage isNotTargetUser!!", (Object[])new Object[0]);
            return;
        }
        if (this.entryMsgListCount == Integer.MIN_VALUE) {
            return;
        }
        List<GamePushChatSession> chatSessionList = this.mISessionCallback.getLocalGamePushSession();
        GamePushChatSession judgeSession = null;
        for (int i = 0; i < chatSessionList.size(); ++i) {
            GamePushChatSession session = chatSessionList.get(i);
            if (session.getUnReadCounts() <= 0 || session.getLastMessage() == null || !StringUtils.equalsIgnoreCase((String)((ImMessageDBBean)session.getLastMessage()).getReserve5(), (String)"false") || ((ImMessageDBBean)session.getLastMessage()).getFromType() != 2) continue;
            judgeSession = session;
            break;
        }
        if (judgeSession != null) {
            ++this.entryMsgListCount;
            if (this.entryMsgListCount >= 3) {
                this.addNotClickAndGameShortTime(judgeSession, true);
            }
        }
    }

    private void addNotClickAndGameShortTime(final GamePushChatSession session, boolean updateFile) {
        ++this.getIgnorePushCondition().notClickAndGameShortTime;
        if (this.getIgnorePushCondition().notClickAndGameShortTime >= 3) {
            MLog.info((Object)TAG, (String)"addNotClickAndGameShortTime set isNotTargetUser!!!", (Object[])new Object[0]);
            this.getGameRecordData().isNotTargetUser = true;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((ImMessageDBBean)session.getLastMessage()).setReserve5("true");
                ImGamePushMsgPresenter.this.mISessionCallback.updateNormalSession(session);
            }
        });
        this.entryMsgListCount = Integer.MIN_VALUE;
        MLog.info((Object)TAG, (String)"addNotClickAndGameShortTime count: %s", (Object[])new Object[]{this.getIgnorePushCondition().notClickAndGameShortTime});
        if (updateFile) {
            this.updateDataToFile();
        }
    }

    private ImGameRecordData.IgnorePushCondition getIgnorePushCondition() {
        if (this.getGameRecordData().mCondition == null) {
            this.getGameRecordData().mCondition = new ImGameRecordData.IgnorePushCondition();
        }
        return this.getGameRecordData().mCondition;
    }

    private ImGameRecordData getGameRecordData() {
        if (this.mGameRecordData == null) {
            this.mGameRecordData = new ImGameRecordData();
        }
        return this.mGameRecordData;
    }

    private void updateDataToFile() {
        MLog.debug((Object)TAG, (String)"updateDataToFile", (Object[])new Object[0]);
        if (this.getGameRecordData() != null) {
            if (!YYTaskExecutor.isMainThread()) {
                String json = JsonParser.toJson((Object)this.getGameRecordData());
                FileStorageUtils.getInstance().saveToFile(true, json, FILE_NAME);
            } else {
                YYTaskExecutor.execute(() -> {
                    String json = JsonParser.toJson((Object)this.getGameRecordData());
                    FileStorageUtils.getInstance().saveToFile(true, json, FILE_NAME);
                });
            }
        }
    }
}

