/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.controller;

import android.content.Context;
import android.os.Message;
import android.view.View;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.AccessRecordDbBean;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.GrowthBusinessConfig;
import com.yy.base.event.fw.FWEvent;
import com.yy.base.event.fw.FWEventActionKey;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.AbstractWindowManager;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.im.controller.WhoHasSeenMeController;
import com.yy.im.module.whohasseenme.WhoHasSeenMeListWindow;
import com.yy.im.module.whohasseenme.WhoHasSeenMeReporter;
import com.yy.im.msg.ImNotificationDef;
import common.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.base.api.accessrecords.AccessInfo;
import net.ihago.base.api.accessrecords.AccessNotify;
import net.ihago.base.api.accessrecords.EAccessNotifyUri;
import net.ihago.base.api.accessrecords.GetUserHomePageAccessRecordsReq;
import net.ihago.base.api.accessrecords.GetUserHomePageAccessRecordsRsp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0014\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u00020 2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020 H\u0002J\u0016\u0010/\u001a\u00020 2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002J\b\u00103\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R;\u0010\u000b\u001a\"\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u000b\u0012\u0002\b\u0003\u0018\u00010\f\u00a8\u0006\u00010\f\u00a8\u0006\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/yy/im/controller/WhoHasSeenMeController;", "Lcom/yy/appbase/core/DefaultController;", "env", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "KEY_START_TIME", "", "TAG", "accessRecords", "", "Lcom/yy/appbase/data/AccessRecordDbBean;", "box", "Lcom/yy/appbase/data/MyBox;", "Lcom/yy/appbase/data/BaseDBBean;", "kotlin.jvm.PlatformType", "getBox", "()Lcom/yy/appbase/data/MyBox;", "box$delegate", "Lkotlin/Lazy;", "mAccessInfoNotify", "com/yy/im/controller/WhoHasSeenMeController$mAccessInfoNotify$1", "Lcom/yy/im/controller/WhoHasSeenMeController$mAccessInfoNotify$1;", "page", "Lcommon/Page;", "value", "", "startTime", "setStartTime", "(J)V", "window", "Lcom/yy/im/module/whohasseenme/WhoHasSeenMeListWindow;", "getAccessRecords", "", "handleMessage", "msg", "Landroid/os/Message;", "hideEntrance", "", "loadDataFromDb", "notify", "notification", "Lcom/yy/framework/core/Notification;", "onWindowDetach", "abstractWindow", "Lcom/yy/framework/core/ui/AbstractWindow;", "putOnlineStatus", "register", "resolveAccessRecords", "list", "", "Lnet/ihago/base/api/accessrecords/AccessInfo;", "showWindow", "im_debug"})
public final class WhoHasSeenMeController
extends DefaultController {
    private final String TAG = "WhoHasSeenMeController";
    private final String KEY_START_TIME = "key_last_request_start_time";
    private Page page;
    private long startTime;
    private final Lazy box$delegate;
    private WhoHasSeenMeListWindow window;
    private List<AccessRecordDbBean> accessRecords;
    private final mAccessInfoNotify.1 mAccessInfoNotify;

    private final void setStartTime(long value) {
        MLog.debug((Object)this.TAG, (String)("update getAccessRecords startTime:" + value), (Object[])new Object[0]);
        this.startTime = value;
        SettingFlags.setLongValue((String)(this.KEY_START_TIME + AccountUtil.getUid()), (long)value);
    }

    private final MyBox<BaseDBBean> getBox() {
        Lazy lazy = this.box$delegate;
        WhoHasSeenMeController whoHasSeenMeController = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MyBox)lazy.getValue();
    }

    public void notify(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        super.notify(notification);
        if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS) {
            if (this.hideEntrance()) {
                MLog.info((Object)this.TAG, (String)"return by hideEntrance.", (Object[])new Object[0]);
                return;
            }
            this.register();
        }
    }

    private final void register() {
        MLog.debug((Object)this.TAG, (String)"register success.", (Object[])new Object[0]);
        this.getAccessRecords();
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.mAccessInfoNotify);
    }

    public void handleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        super.handleMessage(msg);
        if (this.hideEntrance()) {
            MLog.info((Object)this.TAG, (String)"handleMessage return by hideEntrance.", (Object[])new Object[0]);
            return;
        }
        if (msg.what == BaseMsgDef.OPEN_WHO_HAS_SEEN_ME_LIST) {
            this.showWindow();
        }
    }

    private final void showWindow() {
        MLog.info((Object)this.TAG, (String)"showWindow", (Object[])new Object[0]);
        if (this.window == null) {
            Context context = this.mContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContext");
            this.window = new WhoHasSeenMeListWindow(context, (UICallBacks)this, this.accessRecords, (Function1<? super View, Unit>)((Function1)new Function1<View, Unit>(this){
                final /* synthetic */ WhoHasSeenMeController this$0;

                public final void invoke(@NotNull View it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    WhoHasSeenMeController.access$getMWindowMgr$p(this.this$0).popWindow(true);
                }
                {
                    this.this$0 = whoHasSeenMeController;
                    super(1);
                }
            }));
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.window, true);
        WhoHasSeenMeListWindow whoHasSeenMeListWindow = this.window;
        if (whoHasSeenMeListWindow != null) {
            whoHasSeenMeListWindow.updateView();
        }
        WhoHasSeenMeReporter.INSTANCE.reportWhoHasSeenMeListShow(this.accessRecords.size());
    }

    private final void getAccessRecords() {
        MLog.info((Object)this.TAG, (String)"start getAccessRecords", (Object[])new Object[0]);
        GetUserHomePageAccessRecordsReq req = new GetUserHomePageAccessRecordsReq.Builder().page(this.page).start_time(Long.valueOf(this.startTime)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetUserHomePageAccessRecordsRsp>(this){
            final /* synthetic */ WhoHasSeenMeController this$0;

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)WhoHasSeenMeController.access$getTAG$p(this.this$0), (String)"getAccessRecords timeout.", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.error((Object)WhoHasSeenMeController.access$getTAG$p(this.this$0), (String)("getAccessRecords error:" + reason), (Object[])new Object[0]);
                return false;
            }

            public void onResponse(@NotNull GetUserHomePageAccessRecordsRsp message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                MLog.debug((Object)WhoHasSeenMeController.access$getTAG$p(this.this$0), (String)("getAccessRecords onResponse, code:" + code + ", msg:" + msg + ", message:" + message), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    Page page2 = message.page;
                    Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"message.page");
                    WhoHasSeenMeController.access$setPage$p(this.this$0, page2);
                    Long l = message.start_time;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"message.start_time");
                    WhoHasSeenMeController.access$setStartTime$p(this.this$0, l);
                    List list = message.items;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"message.items");
                    WhoHasSeenMeController.access$resolveAccessRecords(this.this$0, list);
                    Notification notification = Notification.obtain((int)NotificationIdDef.WHO_HAS_SEEN_ME_NEW_MSG);
                    notification.extObj = message.items;
                    NotificationCenter.getGlobalInstance().notify(notification);
                    if (message.items != null) {
                        FWEvent.sendEventAsync((int)2, (Object)((Object)this.this$0), (FWEventActionKey)FWEventActionKey.FWAction_On_Visitor_Add, (Object[])new Object[]{message.items.size()});
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final boolean hideEntrance() {
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.GROWTH_BUSINESS);
        MLog.info((Object)this.TAG, (String)("hideEntrance config:" + configData), (Object[])new Object[0]);
        if (configData instanceof GrowthBusinessConfig) {
            if (((GrowthBusinessConfig)configData).getData().getWhoHasSeenMe().getHideEntrance()) {
                MLog.info((Object)this.TAG, (String)"hideEntrance:true, by switch.", (Object[])new Object[0]);
                return true;
            }
            if (((GrowthBusinessConfig)configData).getData().getWhoHasSeenMe().getBlacklist().contains(AccountUtil.getUid())) {
                MLog.info((Object)this.TAG, (String)"hideEntrance: true, by blacklist.", (Object[])new Object[0]);
                return true;
            }
        }
        return false;
    }

    public void onWindowDetach(@Nullable AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (Intrinsics.areEqual((Object)((Object)this.window), (Object)abstractWindow)) {
            this.window = null;
        }
    }

    private final void resolveAccessRecords(List<AccessInfo> list) {
        if (this.getBox() == null) {
            MLog.error((Object)this.TAG, (String)"DBService is not available.", (Object[])new Object[0]);
            return;
        }
        ArrayList<AccessRecordDbBean> dbList = new ArrayList<AccessRecordDbBean>(list.size());
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AccessInfo it = (AccessInfo)element$iv;
            boolean bl = false;
            Long l = it.user.uid;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"it.user.uid");
            long l2 = l;
            int n = it.getPageValue();
            Long l3 = it.access_time;
            Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"it.access_time");
            long l4 = l3;
            String string2 = it.user.nick;
            String string3 = it.user.avatar;
            String string4 = it.user.birthday;
            Long l5 = it.user.sex;
            Intrinsics.checkExpressionValueIsNotNull((Object)l5, (String)"it.user.sex");
            AccessRecordDbBean accessRecordDbBean = new AccessRecordDbBean(l2, n, l4, string2, string3, string4, l5.longValue(), it.user.hometown);
            dbList.add(accessRecordDbBean);
        }
        this.getBox().updateItems(CollectionsKt.toList((Iterable)dbList), true);
        this.loadDataFromDb();
    }

    private final void loadDataFromDb() {
        if (this.getBox() == null) {
            MLog.error((Object)this.TAG, (String)"DBService is not available.", (Object[])new Object[0]);
            return;
        }
        this.getBox().getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<BaseDBBean>(this){
            final /* synthetic */ WhoHasSeenMeController this$0;

            public final void onLoaded(ArrayList<BaseDBBean> datas) {
                block1: {
                    ArrayList<BaseDBBean> arrayList = datas;
                    if (arrayList == null) break block1;
                    ArrayList<BaseDBBean> arrayList2 = arrayList;
                    boolean bl = false;
                    boolean bl2 = false;
                    ArrayList<BaseDBBean> it = arrayList2;
                    boolean bl3 = false;
                    WhoHasSeenMeController.access$getAccessRecords$p(this.this$0).clear();
                    ArrayList<BaseDBBean> arrayList3 = it;
                    if (arrayList3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<com.yy.appbase.data.AccessRecordDbBean>");
                    }
                    WhoHasSeenMeController.access$getAccessRecords$p(this.this$0).addAll((Collection)arrayList3);
                    CollectionsKt.sortWith((List)WhoHasSeenMeController.access$getAccessRecords$p(this.this$0), (Comparator)loadDataFromDb.1.1.INSTANCE);
                    WhoHasSeenMeController.access$putOnlineStatus(this.this$0);
                }
            }
            {
                this.this$0 = whoHasSeenMeController;
            }
        });
    }

    private final void putOnlineStatus() {
        boolean bl = false;
        List uids = new ArrayList();
        Iterable $this$forEach$iv = this.accessRecords;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AccessRecordDbBean it = (AccessRecordDbBean)element$iv;
            boolean bl2 = false;
            uids.add(it.getUid());
        }
        if (uids.size() > 0) {
            IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getInstance().getService(IUserInfoService.class);
            LiveData userOnlineDBBeanLiveData = null;
            if (userInfoService != null) {
                userOnlineDBBeanLiveData = userInfoService.getOnlineStatus(uids, true);
                userOnlineDBBeanLiveData.observeForever((Observer)new Observer<Map<Long, ? extends UserOnlineDBBean>>(this){
                    final /* synthetic */ WhoHasSeenMeController this$0;

                    public final void onChanged(Map<Long, UserOnlineDBBean> onlineBean) {
                        Iterable $this$forEach$iv = WhoHasSeenMeController.access$getAccessRecords$p(this.this$0);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            AccessRecordDbBean item = (AccessRecordDbBean)element$iv;
                            boolean bl = false;
                            if (!onlineBean.containsKey(item.getUid())) continue;
                            item.setOnlineDBBean(onlineBean.get(item.getUid()));
                        }
                        Collection collection = WhoHasSeenMeController.access$getAccessRecords$p(this.this$0);
                        int n = ImNotificationDef.IM_UPDATE_WHO_HAS_SEEN_ENTRANCE_TIME;
                        NotificationCenter notificationCenter = NotificationCenter.getGlobalInstance();
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = collection == null || collection.isEmpty();
                        notificationCenter.notify(Notification.obtain((int)n, (Object)(bl3 ? System.currentTimeMillis() : ((AccessRecordDbBean)CollectionsKt.first((List)WhoHasSeenMeController.access$getAccessRecords$p(this.this$0))).getAccessTime() * (long)1000)));
                    }
                    {
                        this.this$0 = whoHasSeenMeController;
                    }
                });
            }
        }
        Collection collection = this.accessRecords;
        int n = ImNotificationDef.IM_UPDATE_WHO_HAS_SEEN_ENTRANCE_TIME;
        NotificationCenter notificationCenter = NotificationCenter.getGlobalInstance();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = collection == null || collection.isEmpty();
        notificationCenter.notify(Notification.obtain((int)n, (Object)(bl5 ? System.currentTimeMillis() : ((AccessRecordDbBean)CollectionsKt.first(this.accessRecords)).getAccessTime() * (long)1000)));
    }

    public WhoHasSeenMeController(@NotNull Environment env) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        super(env);
        this.TAG = "WhoHasSeenMeController";
        this.KEY_START_TIME = "key_last_request_start_time";
        this.page = new Page(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(50L), Long.valueOf(0L));
        this.startTime = SettingFlags.getLongValue((String)(this.KEY_START_TIME + AccountUtil.getUid()), (long)1L);
        this.box$delegate = LazyKt.lazy((Function0)box.2.INSTANCE);
        WhoHasSeenMeController whoHasSeenMeController = this;
        boolean bl = false;
        whoHasSeenMeController.accessRecords = list = (List)new ArrayList();
        this.mAccessInfoNotify = new IProtoNotify<AccessNotify>(this){
            final /* synthetic */ WhoHasSeenMeController this$0;

            @NotNull
            public String serviceName() {
                return "net.ihago.base.api.accessrecords";
            }

            public void onNotify(@NotNull AccessNotify notify2) {
                Intrinsics.checkParameterIsNotNull((Object)notify2, (String)"notify");
                if (notify2.uri == EAccessNotifyUri.kUriAccessUserHomePage) {
                    MLog.info((Object)WhoHasSeenMeController.access$getTAG$p(this.this$0), (String)("AccessInfo notify:" + notify2), (Object[])new Object[0]);
                    WhoHasSeenMeController.access$getAccessRecords(this.this$0);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ AbstractWindowManager access$getMWindowMgr$p(WhoHasSeenMeController $this) {
        return $this.mWindowMgr;
    }

    public static final /* synthetic */ void access$setMWindowMgr$p(WhoHasSeenMeController $this, AbstractWindowManager abstractWindowManager) {
        $this.mWindowMgr = abstractWindowManager;
    }

    public static final /* synthetic */ String access$getTAG$p(WhoHasSeenMeController $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ Page access$getPage$p(WhoHasSeenMeController $this) {
        return $this.page;
    }

    public static final /* synthetic */ void access$setPage$p(WhoHasSeenMeController $this, Page page2) {
        $this.page = page2;
    }

    public static final /* synthetic */ long access$getStartTime$p(WhoHasSeenMeController $this) {
        return $this.startTime;
    }

    public static final /* synthetic */ void access$setStartTime$p(WhoHasSeenMeController $this, long l) {
        $this.setStartTime(l);
    }

    public static final /* synthetic */ void access$resolveAccessRecords(WhoHasSeenMeController $this, List list) {
        $this.resolveAccessRecords(list);
    }

    public static final /* synthetic */ List access$getAccessRecords$p(WhoHasSeenMeController $this) {
        return $this.accessRecords;
    }

    public static final /* synthetic */ void access$setAccessRecords$p(WhoHasSeenMeController $this, List list) {
        $this.accessRecords = list;
    }

    public static final /* synthetic */ void access$putOnlineStatus(WhoHasSeenMeController $this) {
        $this.putOnlineStatus();
    }

    public static final /* synthetic */ void access$getAccessRecords(WhoHasSeenMeController $this) {
        $this.getAccessRecords();
    }
}

