/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.cim;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im.model.chat.roaming.RoamingChat;
import com.hummer.im.model.chat.roaming.RoamingChatInfo;
import com.hummer.im.model.chat.states.Revoked;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.service.RoamingService;
import com.yy.appbase.service.ICIMService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.LastMsgAndUnreadData;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.bean.unreadmsg.IChannelUnreadMsgNotifyCallbak;
import com.yy.hiyo.channel.base.bean.unreadmsg.IChannelUnreadMsgPuller;
import com.yy.hiyo.channel.base.bean.unreadmsg.IUnreadMsgRequestCallBack;
import com.yy.im.cim.GroupCimMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.CRC32;

public class CimUnreadMsgPuller
implements IChannelUnreadMsgPuller,
RoamingService.RoamingChatListener {
    private static final String TAG = "CimUnreadMsgPuller";
    private IFrequencyLimitExecutor pullMsgLimitExecutor;
    private final List<Identifiable> targetsToRefresh = new ArrayList<Identifiable>(10);
    private boolean needRefreshAll;
    private boolean refreshing = false;
    private IChannelUnreadMsgNotifyCallbak listener;

    private void ensureCimOpen(final ICIMService.IOpenCallBack callBack) {
        ICIMService icimService = (ICIMService)ServiceManagerProxy.getService(ICIMService.class);
        if (icimService != null && !icimService.isOpened()) {
            icimService.initCIM();
            icimService.open(new ICIMService.IOpenCallBack(){

                public void onsuccess() {
                    if (callBack != null) {
                        callBack.onsuccess();
                    }
                }

                public void onError(int errorCode, String tips) {
                    YYTaskExecutor.postToMainThread(() -> {
                        if (callBack != null) {
                            callBack.onError(errorCode, "");
                        }
                    });
                }
            });
        } else if (icimService != null) {
            if (callBack != null) {
                callBack.onsuccess();
            }
        } else if (callBack != null) {
            callBack.onError(-1, "service is null!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeChatInfo(List<Identifiable> targets, ArrayList<MyJoinChannelItem> groups, IUnreadMsgRequestCallBack callBack) {
        if (this.pullMsgLimitExecutor == null) {
            this.pullMsgLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)3000L, (boolean)false);
        }
        CimUnreadMsgPuller cimUnreadMsgPuller = this;
        synchronized (cimUnreadMsgPuller) {
            if (targets == null) {
                this.targetsToRefresh.clear();
                this.needRefreshAll = true;
            } else if (this.targetsToRefresh != targets) {
                this.targetsToRefresh.addAll(targets);
            }
        }
        if (this.refreshing) {
            return;
        }
        final Runnable pullCommand = () -> {
            ArrayList<Identifiable> targetsToRequest;
            CimUnreadMsgPuller cimUnreadMsgPuller = this;
            synchronized (cimUnreadMsgPuller) {
                if (this.needRefreshAll) {
                    this.needRefreshAll = false;
                    targetsToRequest = null;
                } else {
                    targetsToRequest = new ArrayList<Identifiable>(this.targetsToRefresh);
                }
                this.targetsToRefresh.clear();
            }
            this.doChangeChatInfoInner(targetsToRequest, groups, callBack);
        };
        this.pullMsgLimitExecutor.execute(() -> this.ensureCimOpen(new ICIMService.IOpenCallBack(){

            public void onsuccess() {
                pullCommand.run();
            }

            public void onError(int errorCode, String tips) {
                pullCommand.run();
            }
        }));
    }

    private void doChangeChatInfoInner(List<Identifiable> targets, ArrayList<MyJoinChannelItem> groups, final IUnreadMsgRequestCallBack callBack) {
        if (groups == null || groups.size() <= 0) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        ArrayList<MyJoinChannelItem> groupsToPull = null;
        for (MyJoinChannelItem myJoinChannelItem : groups) {
            if (myJoinChannelItem == null || myJoinChannelItem.mPluginData == null || myJoinChannelItem.mPluginData.mode != 1) continue;
            if (groupsToPull == null) {
                groupsToPull = new ArrayList<MyJoinChannelItem>(10);
            }
            groupsToPull.add(myJoinChannelItem);
        }
        if (groupsToPull == null || groupsToPull.size() <= 0) {
            return;
        }
        this.refreshing = true;
        MLog.info((Object)TAG, (String)"doChangeChatInfoInner!", (Object[])new Object[0]);
        HashMap<String, MyJoinChannelItem> groupMap = new HashMap<String, MyJoinChannelItem>(groupsToPull.size(), 1.0f);
        for (MyJoinChannelItem myJoinChannelItem : groupsToPull) {
            if (null == myJoinChannelItem) continue;
            groupMap.put(myJoinChannelItem.cid, myJoinChannelItem);
        }
        ArrayList<RoamingChat> arrayList = new ArrayList<RoamingChat>(groupsToPull.size());
        if (targets == null) {
            for (MyJoinChannelItem item : groupsToPull) {
                AppSession target;
                if (null == item) continue;
                CRC32 crc32 = new CRC32();
                crc32.update(item.cid.getBytes());
                if (item.region != null) {
                    String regionLower = item.region.region != null ? item.region.region.toLowerCase() : "";
                    target = new AppSession(item.cid, crc32.getValue(), regionLower);
                } else {
                    target = new AppSession(item.cid, crc32.getValue(), "");
                }
                arrayList.add(new RoamingChat().setLatestReadTimestamp(item.lastReadMsgTime).setTarget((Identifiable)target));
            }
        } else {
            ArrayList<String> arrayList2 = new ArrayList<String>(targets.size());
            for (Identifiable target : targets) {
                if (!(target instanceof AppSession)) continue;
                String cid = ((AppSession)target).getType();
                if (arrayList2.size() == 0) {
                    arrayList2.add(cid);
                } else {
                    boolean find = false;
                    for (String cidAddItem : arrayList2) {
                        if (!StringUtils.equal((String)cidAddItem, (String)cid)) continue;
                        find = true;
                        break;
                    }
                    if (find) continue;
                    arrayList2.add(cid);
                }
                MyJoinChannelItem item = (MyJoinChannelItem)groupMap.get(cid);
                arrayList.add(new RoamingChat().setTarget(target).setLatestReadTimestamp(item == null ? 0L : item.lastReadMsgTime));
            }
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)"doChangeChatInfoInner:%s", (Object[])new Object[]{arrayList2});
            }
        }
        RoamingService roamingService = (RoamingService)HMR.getService(RoamingService.class);
        MLog.info((Object)TAG, (String)"doChangeChatInfoInner roamingService:%s", (Object[])new Object[]{roamingService});
        if (roamingService != null) {
            roamingService.fetchChatInfoList(arrayList, (HMR.CompletionArg)new HMR.CompletionArg<List<RoamingChatInfo>>(){

                public void onSuccess(List<RoamingChatInfo> data2) {
                    MLog.info((Object)CimUnreadMsgPuller.TAG, (String)"doChangeChatInfoInner onSuccess size:%d", (Object[])new Object[]{data2 != null ? data2.size() : 0});
                    CimUnreadMsgPuller.this.refreshing = false;
                    CimUnreadMsgPuller.this.onRoamingChatResponse(data2, callBack);
                    if (!CimUnreadMsgPuller.this.targetsToRefresh.isEmpty() && callBack != null) {
                        callBack.needRefresh(CimUnreadMsgPuller.this.targetsToRefresh);
                    }
                }

                public void onFailed(Error err) {
                    MLog.error((Object)CimUnreadMsgPuller.TAG, (String)"doChangeChatInfoInner refreshing err:%s", (Object[])new Object[]{err});
                    CimUnreadMsgPuller.this.refreshing = false;
                    if (callBack != null) {
                        callBack.onError(err.code, err.desc);
                    }
                }
            });
        }
    }

    private void onRoamingChatResponse(List<RoamingChatInfo> data2, IUnreadMsgRequestCallBack callBack) {
        MLog.info((Object)TAG, (String)"onRoamingChatResponse has data:%d", (Object[])new Object[]{!FP.empty(data2)});
        HashMap items = new HashMap();
        YYTaskExecutor.execute(() -> {
            if (data2 != null && data2.size() > 0) {
                for (RoamingChatInfo chatInfo : data2) {
                    if (!(chatInfo.getTarget() instanceof AppSession)) continue;
                    LastMsgAndUnreadData item = new LastMsgAndUnreadData();
                    String type = ((AppSession)chatInfo.getTarget()).getType();
                    item.unreadMsgNum = chatInfo.getUnreadCount();
                    item.lastestUnReadMsgTs = chatInfo.getLatestMsg().getTimestamp();
                    if (chatInfo.getLatestMsg().getContent() instanceof GroupCimMsg) {
                        item.lastMsg = callBack.transformMsgItem(chatInfo.getLatestMsg().getUuid(), ((GroupCimMsg)chatInfo.getLatestMsg().getContent()).getMsg(), null, chatInfo.getLatestMsg().getState() instanceof Revoked);
                    }
                    items.put(type, item);
                }
            }
        }, () -> callBack.onSuccess(items));
    }

    public void getUnreadChatInfo(List targets, ArrayList<MyJoinChannelItem> channels, IUnreadMsgRequestCallBack callBack) {
        if (this.targetsToRefresh != targets) {
            if (targets != null && targets.size() > 0) {
                this.doChangeChatInfo(targets, channels, callBack);
            } else {
                this.doChangeChatInfo(null, channels, callBack);
            }
        } else {
            this.doChangeChatInfo(this.targetsToRefresh, channels, callBack);
        }
    }

    public void addRoamingCahtListener(IChannelUnreadMsgNotifyCallbak listener) {
        ICIMService service2 = (ICIMService)ServiceManagerProxy.getService(ICIMService.class);
        if (this.listener == listener || service2 == null) {
            return;
        }
        if (this.listener != null) {
            service2.removeRoamingCahtListener((Object)this);
        }
        this.listener = listener;
        service2.addRoamingCahtListener((Object)this);
    }

    public void removeRoamingCahtListener(IChannelUnreadMsgNotifyCallbak listener) {
        if (this.listener == listener) {
            this.listener = null;
            ICIMService service2 = (ICIMService)ServiceManagerProxy.getService(ICIMService.class);
            if (service2 != null) {
                service2.removeRoamingCahtListener((Object)this);
            }
        }
    }

    public void onChangeChatInfo(List<Identifiable> targets) {
        if (this.listener != null) {
            this.listener.onMsgCome(targets);
        }
    }
}

