/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im;

import android.app.Activity;
import com.yy.appbase.kvo.CheckStatus;
import com.yy.appbase.kvo.moduledata.PlatformPermissionModuleData;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.PlatformPermissionModule;
import com.yy.appbase.service.model.NetCheckUpload;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.im.interfaces.PlatformCallback;
import com.yy.location.ILocationChangedListener;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;

public class MultiPlatFormBizDataModel {
    private CheckStatus mFacebookData = null;
    private CheckStatus mContactData = null;
    private CheckStatus mLocationData = null;
    private CheckStatus mZaloData = null;
    private PlatformPermissionModule module = null;
    private Activity mContext;
    private PlatformCallback mCallback;
    private boolean hasCheck = false;
    private ILocationChangedListener mLocationListener = new ILocationChangedListener(){

        public void onLocationFailed(int errorCode, String errorMsg) {
            if (MultiPlatFormBizDataModel.this.mLocationData != null) {
                MultiPlatFormBizDataModel.this.mLocationData.setValue("hasUpload", (Object)false);
            }
        }

        public void onLocationChanged(LocationInfo info, boolean isCache) {
            if (MultiPlatFormBizDataModel.this.mLocationData != null) {
                MultiPlatFormBizDataModel.this.mLocationData.setValue("hasUpload", (Object)true);
            }
        }
    };

    public MultiPlatFormBizDataModel(Activity ctx, PlatformCallback callback) {
        this.mContext = ctx;
        this.mCallback = callback;
        if (KvoModuleManager.isKvoInitEnved()) {
            this.module = (PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class);
            if (this.module == null) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("MultiPlatFormBizDataModel can be use only after register PlatformPermissionModule!!");
                }
                return;
            }
        } else {
            KvoModuleManager.addInitEnvCallback((KvoModuleManager.InitEnvCallback)new KvoModuleManager.InitEnvCallback(){

                public void onInitEnv() {
                    MultiPlatFormBizDataModel.this.module = (PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class);
                    if (MultiPlatFormBizDataModel.this.module == null) {
                        if (RuntimeContext.sIsDebuggable) {
                            throw new RuntimeException("MultiPlatFormBizDataModel can be use only after register PlatformPermissionModule!!");
                        }
                        return;
                    }
                }
            });
        }
    }

    public void initKvo() {
        PlatformPermissionModuleData data2 = (PlatformPermissionModuleData)KvoModuleManager.getModuleData(PlatformPermissionModule.class);
        if (this.mFacebookData == null) {
            this.mFacebookData = data2.facebookState;
            Kvo.addKvoBinding((KvoSource)this.mFacebookData, (Object)this, (String)"onUploadFacebookEvent");
            Kvo.addKvoBinding((KvoSource)this.mFacebookData, (Object)this, (String)"onFacebookPermissionChange");
            Kvo.addKvoBinding((KvoSource)this.mFacebookData.checkNeedUpload, (Object)this, (String)"onFbCheckNeeUploadEvent");
        }
        if (this.mContactData == null) {
            this.mContactData = data2.contactState;
            Kvo.addKvoBinding((KvoSource)this.mContactData, (Object)this, (String)"onUploadContactEvent");
            Kvo.addKvoBinding((KvoSource)this.mContactData, (Object)this, (String)"onContactPermissionChange");
            Kvo.addKvoBinding((KvoSource)this.mContactData.checkNeedUpload, (Object)this, (String)"onContactCheckNeeUploadEvent");
        }
        if (this.mLocationData == null) {
            this.mLocationData = data2.locationState;
            Kvo.addKvoBinding((KvoSource)this.mLocationData, (Object)this, (String)"onLocationPermissionChange");
            Kvo.addKvoBinding((KvoSource)this.mLocationData, (Object)this, (String)"onUploadLocationEvent");
        }
        if (this.mZaloData == null) {
            this.mZaloData = data2.zaloState;
            Kvo.addKvoBinding((KvoSource)this.mZaloData, (Object)this, (String)"onZaloPermissionChange");
        }
    }

    @KvoMethodAnnotation(name="finishCheck", sourceClass=NetCheckUpload.class, thread=1)
    public void onFbCheckNeeUploadEvent(KvoEventIntent event) {
        if (this.mFacebookData == null || this.mFacebookData.hasUpload) {
            return;
        }
        this.mCallback.onNeedUpload(0, this.mFacebookData.checkNeedUpload);
        if (this.mFacebookData.checkNeedUpload.dataStatus.isSuccess() && this.mFacebookData.checkNeedUpload.need) {
            if (this.module == null) {
                this.module = (PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class);
            }
            if (this.module != null) {
                this.module.facebookPermission(this.mFacebookData.permissionState);
            }
        }
    }

    @KvoMethodAnnotation(name="finishCheck", sourceClass=NetCheckUpload.class, thread=1)
    public void onContactCheckNeeUploadEvent(KvoEventIntent event) {
        if (this.mContactData == null || this.mContactData.hasUpload) {
            return;
        }
        this.mCallback.onNeedUpload(1, this.mContactData.checkNeedUpload);
        if (this.mContactData.checkNeedUpload.dataStatus.isSuccess() && this.mContactData.checkNeedUpload.need) {
            if (this.module == null) {
                this.module = (PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class);
            }
            if (this.module != null) {
                this.module.contactPermission(this.mContext, this.mContactData.permissionState);
            }
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onFacebookPermissionChange(KvoEventIntent event) {
        if (event.source() == this.mFacebookData) {
            if (this.mFacebookData == null || this.mFacebookData.permissionState == CheckStatus.UNCHECK) {
                return;
            }
            this.mCallback.onPermissionChange(0, this.mFacebookData.permissionState);
            if (this.mFacebookData.permissionState == CheckStatus.AUTH) {
                if (this.module == null) {
                    this.module = (PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class);
                }
                if (this.module != null) {
                    this.module.uploadFacebookFriendList();
                }
            }
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onContactPermissionChange(KvoEventIntent event) {
        if (event.source() == this.mContactData) {
            if (this.mContactData == null || this.mContactData.permissionState == CheckStatus.UNCHECK) {
                return;
            }
            this.mCallback.onPermissionChange(1, this.mContactData.permissionState);
            if (this.mContactData.permissionState == CheckStatus.AUTH) {
                if (this.module == null) {
                    this.module = (PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class);
                }
                if (this.module != null) {
                    this.module.uploadContacts();
                }
            }
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onLocationPermissionChange(KvoEventIntent event) {
        if (event.source() == this.mLocationData) {
            if (this.mLocationData == null || this.mLocationData.permissionState == CheckStatus.UNCHECK) {
                return;
            }
            this.mCallback.onPermissionChange(2, this.mLocationData.permissionState);
            LocationInfo info = LocationHelper.getLocationInfo((boolean)true);
            if (info != null) {
                this.mLocationData.setValue("hasUpload", (Object)true);
            }
            if (this.mLocationData.permissionState == CheckStatus.AUTH) {
                LocationHelper.location();
            }
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onZaloPermissionChange(KvoEventIntent event) {
        if (event.source() == this.mZaloData) {
            if (this.mZaloData == null || this.mZaloData.permissionState == CheckStatus.UNCHECK) {
                return;
            }
            this.mCallback.onPermissionChange(3, this.mZaloData.permissionState);
        }
    }

    @KvoMethodAnnotation(name="hasUpload", sourceClass=CheckStatus.class, thread=1)
    public void onUploadFacebookEvent(KvoEventIntent event) {
        if (this.mFacebookData == null) {
            return;
        }
        this.mCallback.onUploadFinish(0, this.mFacebookData.hasUpload);
    }

    @KvoMethodAnnotation(name="hasUpload", sourceClass=CheckStatus.class, thread=1)
    public void onUploadContactEvent(KvoEventIntent event) {
        if (this.mContactData == null) {
            return;
        }
        this.mCallback.onUploadFinish(1, this.mContactData.hasUpload);
    }

    @KvoMethodAnnotation(name="hasUpload", sourceClass=CheckStatus.class, thread=1)
    public void onUploadLocationEvent(KvoEventIntent event) {
        if (this.mLocationData == null) {
            return;
        }
        this.mCallback.onUploadFinish(2, this.mLocationData.hasUpload);
    }

    public void start() {
        if (this.hasCheck) {
            return;
        }
        this.hasCheck = true;
        LocationHelper.removeLocationListener((ILocationChangedListener)this.mLocationListener);
        LocationHelper.addLocationListener((ILocationChangedListener)this.mLocationListener);
        this.checkPermission();
        if (this.module != null) {
            this.module.checkUploadFb(null);
            this.module.checkUploadContacts(null);
        }
    }

    public boolean hasGrantedPermission() {
        return this.mFacebookData != null && this.mFacebookData.permissionState == CheckStatus.AUTH || this.mContactData != null && this.mContactData.permissionState == CheckStatus.AUTH || this.mZaloData != null && this.mZaloData.permissionState == CheckStatus.AUTH || this.mLocationData != null && this.mLocationData.permissionState == CheckStatus.AUTH;
    }

    public boolean isAllPermissionDeny() {
        return this.mFacebookData != null && (this.mFacebookData.permissionState == CheckStatus.UNAUTH || this.mFacebookData.permissionState == CheckStatus.EXPIRE) && this.mContactData != null && this.mContactData.permissionState == CheckStatus.UNAUTH && this.mLocationData != null && this.mLocationData.permissionState == CheckStatus.UNAUTH;
    }

    public void checkPermission() {
        if (this.module == null) {
            this.module = (PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class);
        }
        if (this.module != null) {
            if (this.mFacebookData != null) {
                this.module.facebookPermission(this.mFacebookData.permissionState);
            }
            this.module.locationPermission(this.mContext);
            if (this.mContactData != null) {
                this.module.contactPermission(this.mContext, this.mContactData.permissionState);
            }
            if (this.mZaloData != null) {
                this.module.zaloPermission(this.mZaloData.permissionState);
            }
        }
    }

    public void reset() {
        this.hasCheck = false;
        LocationHelper.removeLocationListener((ILocationChangedListener)this.mLocationListener);
    }
}

