/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.viewmodel;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ObservableBoolean;
import androidx.databinding.ObservableField;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ChatSessionDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.kvo.CheckStatus;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvo.moduledata.PlatformPermissionModuleData;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.kvomodule.module.PlatformPermissionModule;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.push.tips.PushPermissionTipManager;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.im.ContactUtils;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.base.IFBService;
import com.yy.hiyo.im.base.OnGetFbFriendWithoutContactCallback;
import com.yy.hiyo.im.base.SuggestFriendData;
import com.yy.hiyo.login.base.IBindThirdPartyAccountCallBack;
import com.yy.hiyo.login.base.stat.ZaloStat;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.im.ImModuleData;
import com.yy.im.R;
import com.yy.im.model.ChatSession;
import com.yy.im.model.SearchFriend;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.viewmodel.BizViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ihago.bbs.srv.mgr.PostsNotice;
import net.ihago.room.srv.follow.EPath;

public class ChatSessionViewModel
extends BizViewModel {
    private static final String TAG = "ChatSessionViewModel";
    public static final int FB_BLOCK = 1;
    public static final int FB_UNBIND = 2;
    public static final int FB_BINDED = 3;
    public static final int FB_EXPIRED = 4;
    public static final int ZALO_BLOCK = 0;
    public static final int ZALO_UNAUTHORIZED = CheckStatus.UNAUTH;
    public static final int ZALO_AUTHORIZED = CheckStatus.AUTH;
    public static final int LOADING = 0;
    public static final int SESSION_EMPTY = 1;
    public static final int SESSION_NOT_EMPTY = 2;
    private CheckStatus mFacebookState = null;
    private CheckStatus mZaloCheckStatus = null;
    public static final String PREF_UNREAD = "pref_unread_counts";
    public static final int CONTACT_PERMISSION_CLOSED = 1;
    public static final int CONTACT_PERMISSION_OPEN = 2;
    private static final String CHAT_PREFENCE_NAME = "chats";
    private static final String KEY_CONNECT_CONTACT_CLOSE_TIMEMILLIS = "contact_close_timemillis";
    private static final int DAY_TIMEMILLIS = 604800000;
    private static final String KEY_ADD_FRIENDS_HAS_CLOSED = "key_can_show_add_friends";
    private IBindFbCallback mBindFbCallback;
    private PostsNotice mPostsNotice;
    public static long mCurrentChatUid = 0L;
    private final MutableLiveData<List<ChatSession>> mChatSessionList = new MutableLiveData();
    private MutableLiveData<List<SearchFriend>> mSuggestedFbFriends = new MutableLiveData();
    private MutableLiveData<List<SearchFriend>> mFbFriends = new MutableLiveData();
    private MutableLiveData<Integer> mFbState = new MutableLiveData();
    private MutableLiveData<Integer> mSessionState = new MutableLiveData();
    private MutableLiveData<Integer> mContactState = new MediatorLiveData();
    private MutableLiveData<Integer> mZaloState = new MediatorLiveData();
    private MediatorLiveData<SessionDataState> mSessionDataState = new MediatorLiveData();
    public ObservableField<Boolean> mClickCloseBindFb = new ObservableField((Object)false);
    public ObservableField<Boolean> mAddFriendsHasClosed = new ObservableField((Object)false);
    public ObservableBoolean mShowSuggestFriend = new ObservableBoolean(true);
    private long mLastCloseSuggestFriendDate = 0L;
    public ObservableField<String> mBindTips = new ObservableField((Object)ResourceUtils.getString((int)R.string.chat_tips2));
    private IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    private boolean isShowing = false;
    private IBindThirdPartyAccountCallBack mBindThirdPartyAccountCallBack = new IBindThirdPartyAccountCallBack(){

        public void onSuccess() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (null != ChatSessionViewModel.this.mBindFbCallback) {
                        ChatSessionViewModel.this.mBindFbCallback.onBindSuccess();
                    }
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.bind_fb_success, (int)1);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "fb_guide_success"));
                }
            });
        }

        public void onCancel() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.fb_bind_cancel, (int)1);
                }
            });
        }

        public void onError(final int errorCode, Exception e) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (errorCode == 20410) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.fb_err_no_phone_login), (int)1);
                    } else if (errorCode == 20413) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.fb_err_account_has_bind_other_phone), (int)1);
                    } else if (errorCode == 20412) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.fb_err_phone_has_bind_other_account), (int)1);
                    } else if (errorCode == 20422) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.bind_fail_fb_has_been_used), (int)1);
                    } else {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.fb_connect_fail), (int)1);
                    }
                }
            });
        }
    };
    private static final String KEY_NEXT_OPENDATE = "suggestedFriend_nextOpenData";

    public ChatSessionViewModel(@NonNull Application application) {
        super(application);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_ADD_FRIENDS, (INotify)this);
        this.mFbState.setValue((Object)1);
        this.mZaloState.setValue((Object)0);
        this.mSessionState.setValue((Object)0);
        this.mContactState.setValue((Object)0);
        if (KvoModuleManager.isKvoInitEnved()) {
            this.getNormalChatSessions();
        } else {
            KvoModuleManager.addInitEnvCallback((KvoModuleManager.InitEnvCallback)new KvoModuleManager.InitEnvCallback(){

                public void onInitEnv() {
                    ChatSessionViewModel.this.getNormalChatSessions();
                }
            });
        }
        this.mFbState.observeForever((Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer integer) {
                if (integer == null) {
                    return;
                }
                if (integer == 3) {
                    ChatSessionViewModel.this.handleFacebookFriendList();
                } else if (integer == 2 || integer == 4) {
                    ChatSessionViewModel.this.mSuggestedFbFriends.setValue(new ArrayList());
                }
            }
        });
        this.mSessionDataState.addSource(this.mSessionState, (Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer objects) {
                ChatSessionViewModel.this.changeState();
            }
        });
        this.mSessionDataState.addSource(this.mFbState, (Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer integer) {
                ChatSessionViewModel.this.changeState();
            }
        });
        this.mSessionDataState.addSource(this.mContactState, (Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer integer) {
                ChatSessionViewModel.this.changeState();
            }
        });
        this.mSessionDataState.addSource(this.mZaloState, (Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer integer) {
                MLog.error((Object)"vanda", (String)("mSessionDataState mZaloState = " + integer), (Object[])new Object[0]);
                ChatSessionViewModel.this.changeState();
            }
        });
        this.initClickClose();
        this.initAddFriendShow();
        this.readEmojiData();
    }

    public PostsNotice getPostsNotice() {
        return this.mPostsNotice;
    }

    public void setPostsNotice(PostsNotice postsNotice) {
        this.mPostsNotice = postsNotice;
        SessionDataState sessionDataState = new SessionDataState((Integer)this.mFbState.getValue(), (Integer)this.mSessionState.getValue(), (Integer)this.mContactState.getValue(), (Integer)this.mZaloState.getValue());
        this.mSessionDataState.setValue((Object)sessionDataState);
    }

    private void getNormalChatSessions() {
        ImModule imModule = (ImModule)KvoModuleManager.getModule(ImModule.class);
        if (imModule != null) {
            imModule.getNormalChatSessions().observeForever(chatSessions -> {
                this.mSessionState.postValue((Object)(FP.empty((Collection)chatSessions) ? 1 : 2));
                if (chatSessions != null) {
                    ArrayList<ChatSession> sessions = new ArrayList<ChatSession>(chatSessions.size());
                    for (Object s : chatSessions) {
                        ChatSession chatSession = (ChatSession)s;
                        if (chatSession.isExpired()) continue;
                        sessions.add(chatSession);
                    }
                    this.mChatSessionList.postValue(sessions);
                }
            });
        }
    }

    private void readEmojiData() {
        EmojiManager.INSTANCE.init();
    }

    private void initClickClose() {
        long closeTimemillis = this.getSharedPreferences().getLong(KEY_CONNECT_CONTACT_CLOSE_TIMEMILLIS, 0L);
        boolean initClosed = closeTimemillis > System.currentTimeMillis() - 604800000L;
        MLog.debug((Object)TAG, (String)("closeTimemillis = " + closeTimemillis + ", initClosed = " + initClosed), (Object[])new Object[0]);
        this.mClickCloseBindFb.set((Object)initClosed);
    }

    private void initAddFriendShow() {
        boolean hasClosed = this.getSharedPreferences().getBoolean(KEY_ADD_FRIENDS_HAS_CLOSED, false);
        MLog.debug((Object)TAG, (String)("initAddFriendShow = " + hasClosed), (Object[])new Object[0]);
        this.mAddFriendsHasClosed.set((Object)hasClosed);
    }

    private SharedPreferences getSharedPreferences() {
        return SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)this.getApplication(), CHAT_PREFENCE_NAME, 0);
    }

    public MutableLiveData<List<SearchFriend>> getFbFriends() {
        return this.mFbFriends;
    }

    public ObservableBoolean getShowSuggestFriend() {
        return this.mShowSuggestFriend;
    }

    public MutableLiveData<SessionDataState> getSessionDataState() {
        return this.mSessionDataState;
    }

    public MutableLiveData<List<ChatSession>> getChatSessionList() {
        return this.mChatSessionList;
    }

    public MutableLiveData<List<SearchFriend>> getmSuggestedFbFriends() {
        return this.mSuggestedFbFriends;
    }

    private void resetContactState() {
        if (this.getAty() == null) {
            return;
        }
        ContactUtils.hasContactPermission((Activity)this.getAty(), (ContactUtils.IContactPermissionCheckCallBack)new ContactUtils.IContactPermissionCheckCallBack(){

            public void onHasContactPermissionCallBack(final boolean has) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ChatSessionViewModel.this.mContactState != null) {
                            ChatSessionViewModel.this.mContactState.setValue((Object)(has ? 2 : 1));
                        }
                    }
                });
            }
        });
    }

    public void gotoBindZalo(View view) {
        this.gotoBindZaloCallback(view, null);
    }

    public void gotoBindZaloCallback(View view, final IBindZaloCallback iBindZaloCallback) {
        if (AccountUtil.isLoginByGuest()) {
            Message msg = Message.obtain();
            msg.what = BaseMsgDef.MSG_GUEST_LOGIN_WITH_TYPE;
            Bundle bundle = new Bundle();
            bundle.putInt("key_login_type", 7);
            bundle.putInt("key_login_source", 6);
            msg.setData(bundle);
            MsgDispatcher.getInstance().sendMessage(msg);
        } else {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindZalo((Object)new IBindThirdPartyAccountCallBack(){

                public void onSuccess() {
                    ZaloStat.statZaloBindGuideSucess();
                    if (iBindZaloCallback != null) {
                        iBindZaloCallback.onBindSuccess();
                    }
                }

                public void onCancel() {
                }

                public void onError(int errorCode, Exception e) {
                }
            });
        }
    }

    public void goToBindContact(View view) {
        this.goToBindContact(view, null);
    }

    public void goToBindContact(View view, final IBindContactCallback callback) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"goToBindContact", (Object[])new Object[0]);
        }
        if (this.getAty() == null) {
            return;
        }
        PermissionHelper.requestContactPermission((Activity)this.getAty(), (IPermissionListener)new IPermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                if (ChatSessionViewModel.this.mContactState != null) {
                    ChatSessionViewModel.this.mContactState.postValue((Object)2);
                }
                if (null != callback) {
                    callback.onBindSuccess();
                }
            }

            public void onPermissionDenied(@NonNull String[] permission) {
            }
        });
        String entId = view.getId() == R.id.tv_func ? "1" : (view.getId() == R.id.tv_bind ? "2" : "4");
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024335").put("function_id", "contact_click").put("ent_id", entId));
    }

    public void goToAddNewFriend(View view) {
        MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_PAGE);
    }

    public void onClickCloseHeader(View v) {
        long closeTimemillis = this.getSharedPreferences().getLong(KEY_CONNECT_CONTACT_CLOSE_TIMEMILLIS, 0L);
        MLog.debug((Object)TAG, (String)("onClickCloseHeader closeTimemillis = " + closeTimemillis), (Object[])new Object[0]);
        SharedPreferences shared = this.getSharedPreferences();
        SharedPreferences.Editor editor = shared.edit();
        editor.putLong(KEY_CONNECT_CONTACT_CLOSE_TIMEMILLIS, System.currentTimeMillis());
        editor.apply();
        this.mClickCloseBindFb.set((Object)true);
    }

    public void onClickAddFriendsCloseHeader(View v) {
        SharedPreferences shared = this.getSharedPreferences();
        SharedPreferences.Editor editor = shared.edit();
        editor.putBoolean(KEY_ADD_FRIENDS_HAS_CLOSED, true);
        editor.apply();
        this.mAddFriendsHasClosed.set((Object)true);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024335").put("function_id", "add_friends_delete_click"));
    }

    public void AddFriendsgoToAddFriends(View view) {
        MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_PAGE);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024335").put("function_id", "add_friends_click"));
    }

    public void onClickSuggestArrow(View v) {
        if (this.mShowSuggestFriend.get()) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024335").put("function_id", "suggested_close"));
        }
        this.mShowSuggestFriend.set(!this.mShowSuggestFriend.get());
        this.updateShowSuggestFriendDate(this.mShowSuggestFriend.get());
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "recommend_click").put("recommend_list", this.mShowSuggestFriend.get() ? "fold" : "show"));
    }

    private void changeState() {
        SessionDataState value = (SessionDataState)this.mSessionDataState.getValue();
        if (value == null || value.mFbState != (Integer)this.mFbState.getValue() || value.mSessionState != (Integer)this.mSessionState.getValue() || value.mZaloState != (Integer)this.mZaloState.getValue() || value.mContactState != (Integer)this.mContactState.getValue()) {
            this.mBindTips.set((Object)ResourceUtils.getString((int)R.string.chat_contact_tips2));
            SessionDataState sessionDataState = new SessionDataState((Integer)this.mFbState.getValue(), (Integer)this.mSessionState.getValue(), (Integer)this.mContactState.getValue(), (Integer)this.mZaloState.getValue());
            MLog.info((Object)"vanda", (String)("changeState sessionDataState = " + sessionDataState), (Object[])new Object[0]);
            this.mSessionDataState.setValue((Object)sessionDataState);
        }
    }

    @Override
    public void notify(Notification notification) {
        super.notify(notification);
        if (notification == null) {
            return;
        }
        int id2 = notification.id;
        if (notification.id == ImNotificationDef.IM_ADD_FRIENDS && notification.extObj instanceof SearchFriend) {
            this.handleSearchFriend((SearchFriend)notification.extObj);
        } else if (notification.id == ImNotificationDef.IM_ADD_FRIENDS && notification.extObj instanceof SuggestFriendData) {
            this.sendAddFriendRequest((SuggestFriendData)notification.extObj);
            ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("Add_Friend_Request"));
        }
    }

    public void handleSearchFriend(SearchFriend friend) {
        if (friend.getViewState() == 0) {
            if (this.isBlack(friend.getUid())) {
                ToastUtils.showToast((Context)this.getAty(), (String)ResourceUtils.getString((int)R.string.im_add_black_tips), (int)0);
                return;
            }
            this.sendAddFriend(friend);
            ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("Add_Friend_Request"));
        } else if (friend.getViewState() == 2) {
            this.gotoInviteFriend(friend);
        } else if (friend.getViewState() == 4) {
            MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_PAGE);
        }
    }

    private boolean isBlack(long uid) {
        return ((IBlacklistService)ServiceManagerProxy.getService(IBlacklistService.class)).isInBlacklist(uid).getInBlacklist();
    }

    private void sendAddFriendRequest(SuggestFriendData suggestFriendData) {
        if (suggestFriendData == null) {
            return;
        }
        RelationInfo relationInfo = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationLocal(suggestFriendData.mFriend.getUid());
        ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).requestFollow(relationInfo, EPath.PATH_OLD_FRIENDS.getValue());
        this.reportImOldAddFriends();
    }

    private void gotoInviteFriend(SearchFriend friend) {
    }

    private void sendAddFriend(SearchFriend friend) {
        if (friend == null) {
            return;
        }
        RelationInfo relationInfo = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationLocal(friend.getUid());
        ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).requestFollow(relationInfo, EPath.PATH_OLD_FRIENDS.getValue());
        this.reportImOldAddFriends();
    }

    private void reportImOldAddFriends() {
        ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("add_friend"));
        PushPermissionTipManager.checkToShowPushDialog((PushPermissionTipManager.Source)PushPermissionTipManager.Source.ADD_FRIEND);
    }

    private void checkToShowPushDialog() {
        Message obtain = Message.obtain();
        obtain.what = ImBaseMsgDef.ON_CHAT_PAGE_SHOW;
        if (AccountUtil.isLoginByGuest()) {
            MsgDispatcher.getInstance().sendMessage(obtain);
            return;
        }
        Runnable runnable2 = () -> {
            ImModuleData data2 = (ImModuleData)KvoModuleManager.getModuleData(ImModule.class);
            if (data2 != null) {
                obtain.obj = data2.mNormalSessionUnread.getCount();
                MsgDispatcher.getInstance().sendMessage(obtain);
            }
        };
        if (KvoModuleManager.isKvoInitEnved()) {
            runnable2.run();
        } else {
            KvoModuleManager.addInitEnvCallback(runnable2::run);
        }
    }

    @Override
    public void onWindowAttach() {
        super.onWindowAttach();
        this.mShowSuggestFriend.set(this.readShowSuggestFriend());
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.isShowing) {
            this.resetContactState();
        }
    }

    private void handleFacebookFriendList() {
        ((IFBService)this.getService().getService(IFBService.class)).getFBFriendListWithoutContacts(new OnGetFbFriendWithoutContactCallback(){

            public void onGetFriendListUids(List<Long> uids) {
            }

            public void onGetFbFriendSuccess(List<UserInfoKS> userInfos, List<Long> uids) {
                MLog.info((Object)ChatSessionViewModel.TAG, (String)("get facebook friendlist success, size is " + (userInfos != null ? userInfos.size() : 0)), (Object[])new Object[0]);
                if (userInfos != null && !userInfos.isEmpty()) {
                    ArrayList<SearchFriend> friends = new ArrayList<SearchFriend>();
                    for (UserInfoKS info : userInfos) {
                        if (info == null || info.ver == 0L) continue;
                        SearchFriend friend = new SearchFriend();
                        friend.setAvatarUrl(info.avatar);
                        friend.setName(info.nick);
                        friend.setUid(info.uid);
                        friend.setFacebookTag(true);
                        friend.setAddress(info.lastLoginLocation);
                        friend.setSex(info.sex);
                        friend.setFromType(3);
                        friends.add(friend);
                    }
                    ChatSessionViewModel.this.mSuggestedFbFriends.postValue(friends);
                }
            }

            public void onError(int errCode, String msg) {
                if (errCode == 101) {
                    ChatSessionViewModel.this.mFbState.postValue((Object)4);
                } else {
                    YYTaskExecutor.postToMainThread(() -> ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_get_facebook_friend_error), (int)0));
                    MLog.info((Object)ChatSessionViewModel.TAG, (String)"handleFacebookFriendList error code =%d,msg=%s", (Object[])new Object[]{errCode, msg});
                }
            }
        });
    }

    @Override
    protected void resetWhenLogout() {
        super.resetWhenLogout();
        MLog.info((Object)TAG, (String)"resetWhenLogout", (Object[])new Object[0]);
        this.mChatSessionList.setValue(new ArrayList());
        this.mSuggestedFbFriends.setValue(new ArrayList());
        this.mFbFriends.setValue(new ArrayList());
        this.mFbState.setValue((Object)1);
        this.mZaloState.setValue((Object)0);
        this.mSessionState.setValue((Object)1);
    }

    @Override
    public void onWindowShow() {
        super.onWindowShow();
        this.isShowing = true;
        this.checkToShowPushDialog();
        this.checkZaloAuthStatus();
        this.checkFacebookAuthStatus();
        this.checkContactPermission();
    }

    @Override
    public void onWindowHide() {
        super.onWindowHide();
        this.isShowing = false;
        if (this.mFacebookState != null) {
            Kvo.removeKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onFacebookPermissionChange");
        }
        if (this.mZaloCheckStatus != null) {
            Kvo.removeKvoBinding((KvoSource)this.mZaloCheckStatus, (Object)this, (String)"onZaloPermissionChange");
        }
    }

    private void checkFacebookAuthStatus() {
        KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
        if (moduleData instanceof PlatformPermissionModuleData) {
            PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
            this.mFacebookState = moduleData1.facebookState;
            Kvo.removeKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onFacebookPermissionChange");
            Kvo.addKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onFacebookPermissionChange");
            this.checkFacebookPermission();
        }
    }

    private void checkZaloAuthStatus() {
        KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
        if (moduleData instanceof PlatformPermissionModuleData) {
            PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
            this.mZaloCheckStatus = moduleData1.zaloState;
            Kvo.removeKvoBinding((KvoSource)this.mZaloCheckStatus, (Object)this, (String)"onZaloPermissionChange");
            Kvo.addKvoBinding((KvoSource)this.mZaloCheckStatus, (Object)this, (String)"onZaloPermissionChange");
            this.checkZaloPermission();
        }
    }

    private void checkFacebookPermission() {
        if (this.mFacebookState != null) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).facebookPermission(this.mFacebookState.permissionState);
        }
    }

    private void checkZaloPermission() {
        if (this.mZaloCheckStatus != null) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).facebookPermission(this.mZaloCheckStatus.permissionState);
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onFacebookPermissionChange(KvoEventIntent event) {
        if (this.mFacebookState == null || this.mFacebookState.permissionState == CheckStatus.UNCHECK) {
            return;
        }
        MLog.info((Object)TAG, (String)"onFacebookPermissionChange state: %s", (Object[])new Object[]{this.mFacebookState.permissionState});
        if (this.mFacebookState.permissionState == CheckStatus.EXPIRE) {
            this.mFbState.setValue((Object)4);
        } else if (this.mFacebookState.permissionState == CheckStatus.UNAUTH) {
            this.mFbState.setValue((Object)2);
        } else if (this.mFacebookState.permissionState == CheckStatus.AUTH) {
            this.mFbState.setValue((Object)3);
        } else {
            this.mFbState.setValue((Object)1);
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onZaloPermissionChange(KvoEventIntent event) {
        if (this.mZaloCheckStatus == null || this.mZaloCheckStatus.permissionState == CheckStatus.UNCHECK) {
            return;
        }
        MLog.info((Object)TAG, (String)"onZaloPermissionChange state: %s", (Object[])new Object[]{this.mZaloCheckStatus.permissionState});
        if (this.mZaloCheckStatus.permissionState == CheckStatus.UNAUTH) {
            this.mZaloState.setValue((Object)ZALO_UNAUTHORIZED);
        } else if (this.mZaloCheckStatus.permissionState == CheckStatus.AUTH) {
            this.mZaloState.setValue((Object)ZALO_AUTHORIZED);
        } else {
            this.mZaloState.setValue((Object)0);
        }
    }

    public void goToBindFacebook(IBindFbCallback callback) {
        this.mBindFbCallback = callback;
        if (this.mFacebookState == null) {
            return;
        }
        if (!AccountUtil.isLoginByGuest() && this.mFacebookState.permissionState == CheckStatus.UNAUTH) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindFacebook((Object)this.mBindThirdPartyAccountCallBack);
        }
    }

    private void checkContactPermission() {
        if (this.getAty() != null) {
            ContactUtils.hasContactPermission((Activity)this.getAty(), (ContactUtils.IContactPermissionCheckCallBack)new ContactUtils.IContactPermissionCheckCallBack(){

                public void onHasContactPermissionCallBack(final boolean has) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (ChatSessionViewModel.this.mContactState != null) {
                                ChatSessionViewModel.this.mContactState.setValue((Object)(has ? 2 : 1));
                            }
                        }
                    });
                }
            });
        }
    }

    public void updateDBItem(final ChatSession session) {
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MyBox box2 = ((IDBService)ChatSessionViewModel.this.getService().getService(IDBService.class)).boxForCurUser(ChatSessionDBBean.class);
                if (box2 != null) {
                    box2.updateItem((BaseDBBean)session.getDBBean(), true);
                }
            }
        }, 0L);
    }

    private boolean readShowSuggestFriend() {
        this.mLastCloseSuggestFriendDate = AccountUtil.getAccountSetting().getLong(KEY_NEXT_OPENDATE, 0L);
        return this.mLastCloseSuggestFriendDate <= System.currentTimeMillis();
    }

    private void updateShowSuggestFriendDate(boolean show) {
        long old = this.mLastCloseSuggestFriendDate;
        this.mLastCloseSuggestFriendDate = !show ? System.currentTimeMillis() + 86400000L : 0L;
        if (old != this.mLastCloseSuggestFriendDate) {
            this.writeShowSuggestFriend();
        }
    }

    private void writeShowSuggestFriend() {
        SharedPreferences.Editor editor = AccountUtil.getAccountSetting().edit();
        editor.putLong(KEY_NEXT_OPENDATE, this.mLastCloseSuggestFriendDate);
        editor.apply();
    }

    public static interface IBindContactCallback {
        public void onBindSuccess();
    }

    public static interface IBindFbCallback {
        public void onBindSuccess();
    }

    public static interface IBindZaloCallback {
        public void onBindSuccess();
    }

    public static class SessionDataState {
        public int mFbState;
        public int mSessionState;
        public int mContactState;
        public int mZaloState;

        public SessionDataState(int mFbState, int mSessionState, int mContactState, int zaloState2) {
            this.mFbState = mFbState;
            this.mSessionState = mSessionState;
            this.mContactState = mContactState;
            this.mZaloState = zaloState2;
        }

        public String toString() {
            return "SessionDataState{mFbState=" + this.mFbState + ", mSessionState=" + this.mSessionState + ", mContactState=" + this.mContactState + ", mZaloState=" + this.mZaloState + '}';
        }
    }
}

