/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget.overScroll;

import android.content.Context;
import android.os.Build;
import android.os.Vibrator;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.appbase.ui.widget.overscroll.HorizontalOverScrollBounceEffectDecorator;
import com.yy.appbase.ui.widget.overscroll.IOverScrollDecor;
import com.yy.appbase.ui.widget.overscroll.IOverScrollDecoratorAdapter;
import com.yy.appbase.ui.widget.overscroll.IOverScrollUpdateListener;
import com.yy.appbase.ui.widget.overscroll.RecyclerViewOverScrollDecorAdapter;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.im.base.ImRecommendGameInfoManager;
import com.yy.hiyo.im.base.RecommendGameBean;
import com.yy.im.R;
import com.yy.im.interfaces.IGameInviteListener;
import com.yy.im.ui.adapter.ImDrawerGameListAdapter;
import com.yy.im.ui.adapter.ImMainGameListAdapter;
import com.yy.im.ui.widget.overScroll.ImGameListItemDecoration;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import okhttp3.Call;

public class NewGameListLayout
extends YYLinearLayout {
    private static final String TAG = "NewGameListLayout";
    private static final float DEFAULT_DRAG_MOVE_RATIO = 0.6f;
    private RecyclerView mRecyclerView;
    private DrawerLayout mDrawerLayout;
    private View mDrawerView;
    private View mSeeMoreLayout;
    private View mShadowView;
    private LinearLayout mLayoutGameList;
    private TextView mGameListTip;
    private RecyclerView mImDrawerRecyclerView;
    private View mSpaceShadowView;
    private IServiceManager mServiceManager;
    private IOverScrollDecor mHorizOverScrollEffect;
    private RelativeLayout.LayoutParams mSlideLayoutParams;
    private ImMainGameListAdapter mMainAdapter;
    private ImDrawerGameListAdapter mDrawerAdapter;
    private ImGameListItemDecoration mImGameListItemDecoration;
    private boolean mDraging;
    private boolean mIsFromResultPage;
    private boolean mIsFocusStyle;
    private boolean mIsGameWin;
    private boolean mIsDrawLayoutStateDraging;
    private boolean mIsMainListStateDraging;
    private boolean mIsLeftSlidingOpen;
    private List<GameInfo> mMainData;
    private List<GameInfo> mDrawerData;
    private List<GameInfo> mFocusGameList;
    private int mSeeMoreViewMarginEnd;
    private long mTargetUid;
    IGameInviteListener mListener;
    private int oldFirstViisible;
    private int oldLastViisible;
    private int oldDrawerFirstViisible;
    private int oldDrawerLastViisible;

    public NewGameListLayout(@NonNull Context context) {
        this(context, null);
    }

    public NewGameListLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NewGameListLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater.from((Context)context).inflate(R.layout.im_new_game_list_layout, (ViewGroup)this, true);
        this.setBackgroundResource(R.drawable.ico_im_game_focus_card_shadow);
        this.mLayoutGameList = this;
        this.setOrientation(1);
        this.mGameListTip = (TextView)this.findViewById(R.id.game_list_tip);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.game_list_recyclerview);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, 0, false));
        this.mHorizOverScrollEffect = new HorizontalOverScrollBounceEffectDecorator((IOverScrollDecoratorAdapter)new RecyclerViewOverScrollDecorAdapter(this.mRecyclerView));
    }

    private void initDrawerRV(List<GameInfo> datas) {
        this.mDrawerData = datas;
        if (this.mDrawerAdapter == null) {
            this.mDrawerAdapter = new ImDrawerGameListAdapter(datas);
            GridLayoutManager gridLayoutManager = new GridLayoutManager(this.getContext(), 2);
            this.mImDrawerRecyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
            this.mImDrawerRecyclerView.setAdapter((RecyclerView.Adapter)this.mDrawerAdapter);
        } else {
            this.mDrawerAdapter.updateData(datas);
        }
    }

    private void processFocusState(final List<GameInfo> gameInfos) {
        MLog.info((Object)TAG, (String)("\u521d\u59cb\u5316IM\u9875\u9762\u6a2a\u5411\u5217\u8868\uff1a" + (gameInfos == null ? 0 : gameInfos.size())), (Object[])new Object[0]);
        if (gameInfos == null) {
            return;
        }
        this.initMainRv(gameInfos, false);
        if (this.mIsFromResultPage) {
            MLog.info((Object)TAG, (String)"\u9700\u8981\u89c6\u89c9\u7a81\u51fa", (Object[])new Object[0]);
            if (ImRecommendGameInfoManager.INSTANCE.isCurrentIsRecommend()) {
                MLog.info((Object)TAG, (String)"processFocusState isCurrentIsRecommend", (Object[])new Object[0]);
                RecommendGameBean.GameReason gameReason = ImRecommendGameInfoManager.INSTANCE.getCurrentImRecommendReason();
                if (gameReason != null && !TextUtils.isEmpty((CharSequence)gameReason.reason)) {
                    this.mGameListTip.setText((CharSequence)gameReason.reason);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "reason_show").put("reason_type", gameReason.reatype).put("act_uid", this.getTargetUid()).put("gid", gameReason.gameid));
                }
                if (this.mFocusGameList == null) {
                    this.mFocusGameList = new ArrayList<GameInfo>(3);
                }
                if (this.mFocusGameList.size() != 3 && gameInfos.size() >= 3) {
                    for (int i = 0; i < 3; ++i) {
                        this.mFocusGameList.add(gameInfos.get(i));
                    }
                }
                this.initMainRv(gameInfos, true);
            } else {
                ((IUserInfoService)this.mServiceManager.getService(IUserInfoService.class)).getMineGameHistoryCacheFirst(new OnGameHistoryCallback(){

                    public void onUISuccess(List<GameHistoryBean> historyList, int id2) {
                        MLog.info((Object)NewGameListLayout.TAG, (String)("\u83b7\u53d6\u5230\u5386\u53f2\u8bb0\u5f55\u505a\u89c6\u89c9\u7a81\u51fa\uff1a" + (historyList == null ? 0 : historyList.size())), (Object[])new Object[0]);
                        NewGameListLayout.this.processGameInfos(gameInfos, historyList);
                    }

                    public void onError(Call call, Exception e, int id2) {
                        MLog.info((Object)NewGameListLayout.TAG, (String)("\u8bf7\u6c42\u6e38\u620f\u5386\u53f2\u5931\u8d251" + e.toString()), (Object[])new Object[0]);
                    }

                    public void onResponseError(int id2, String message, String response) {
                        MLog.info((Object)NewGameListLayout.TAG, (String)"\u8bf7\u6c42\u6e38\u620f\u5386\u53f2\u5931\u8d252", (Object[])new Object[0]);
                    }
                });
            }
        }
    }

    private void processGameInfos(List<GameInfo> gameInfos, List<GameHistoryBean> historyList) {
        GameInfo gameInfo;
        int i;
        String gameTip = "";
        ArrayList<GameHistoryBean> historyListTemp = new ArrayList<GameHistoryBean>(historyList.size());
        this.mFocusGameList = new ArrayList<GameInfo>(3);
        block0: for (i = 0; i < gameInfos.size(); ++i) {
            String gid;
            gameInfo = gameInfos.get(i);
            if (gameInfo == null || TextUtils.isEmpty((CharSequence)(gid = gameInfo.getGid()))) continue;
            for (int j = 0; j < historyList.size(); ++j) {
                GameHistoryBean gameHistoryBean = historyList.get(j);
                if (gameHistoryBean == null || !gid.equals(gameHistoryBean.gameId)) continue;
                historyListTemp.add(gameHistoryBean);
                continue block0;
            }
        }
        if (historyListTemp.size() > 0) {
            this.mIsFocusStyle = true;
            gameTip = this.mIsGameWin ? ResourceUtils.getString((int)R.string.tips_im_try_good_game_on_win) : ResourceUtils.getString((int)R.string.tips_im_try_good_game_on_fail);
            Collections.sort(historyListTemp, new Comparator<GameHistoryBean>(){

                @Override
                public int compare(GameHistoryBean o1, GameHistoryBean o2) {
                    if (o1.winCount == o2.winCount) {
                        return 0;
                    }
                    return o1.winCount > o2.winCount ? -1 : 1;
                }
            });
            block2: for (i = 0; i < historyListTemp.size() && this.mFocusGameList.size() < 3; ++i) {
                GameHistoryBean gameHistoryBean = (GameHistoryBean)historyListTemp.get(i);
                if (gameHistoryBean == null) continue;
                for (int j = 0; j < gameInfos.size(); ++j) {
                    GameInfo gameInfo2 = gameInfos.get(j);
                    if (gameInfo2 == null || TextUtils.isEmpty((CharSequence)gameInfo2.getGid()) || !gameInfo2.getGid().equals(gameHistoryBean.gameId) || gameInfo2.isFixing() || gameInfo2.isFull()) continue;
                    this.mFocusGameList.add(gameInfo2);
                    continue block2;
                }
            }
            if (this.mFocusGameList.size() > 0) {
                for (i = 0; i < this.mFocusGameList.size(); ++i) {
                    gameInfos.remove(this.mFocusGameList.get(i));
                }
                gameInfos.addAll(0, this.mFocusGameList);
            }
        } else {
            for (i = 0; i < gameInfos.size(); ++i) {
                gameInfo = gameInfos.get(i);
                if (this.mFocusGameList.size() == 3) break;
                if (!this.isNewGame(gameInfo)) continue;
                this.mFocusGameList.add(gameInfo);
            }
            if (this.mFocusGameList.size() > 0) {
                this.mIsFocusStyle = true;
                gameTip = ResourceUtils.getString((int)R.string.tips_im_try_new_game);
                for (i = 0; i < this.mFocusGameList.size(); ++i) {
                    gameInfos.remove(this.mFocusGameList.get(i));
                }
                gameInfos.addAll(0, this.mFocusGameList);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)gameTip)) {
            this.mGameListTip.setText((CharSequence)gameTip);
        }
        this.initMainRv(gameInfos, this.mIsFocusStyle);
    }

    private boolean isNewGame(GameInfo gameInfo) {
        String gid = gameInfo.getGid();
        return !RuntimeContext.isStartAtFirstInstalled() && !SettingFlags.getBoolean((String)("home_game_mark_not_new_" + gid), (boolean)false) && gameInfo.getAsNewTime() > 0L && (gameInfo.getAsNewTime() <= TimeUtils.getServiceRealTime() / 1000L || TimeUtils.getServiceRealTime() == 0L) && !gameInfo.isFixing() && !gameInfo.isFull() && !gameInfo.isHot() && !gameInfo.isBetaTest();
    }

    private void initMainRv(List<GameInfo> datas, boolean isFocusStyle) {
        MLog.info((Object)TAG, (String)("\u5f00\u59cb\u521d\u59cb\u5316RV\uff1a" + (datas == null ? 0 : datas.size())), (Object[])new Object[0]);
        if (!isFocusStyle) {
            this.mFocusGameList = null;
        }
        this.mMainData = datas;
        if (this.mMainAdapter == null) {
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
            linearLayoutManager.setOrientation(0);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
            this.mMainAdapter = new ImMainGameListAdapter(datas, isFocusStyle);
            this.mImGameListItemDecoration = new ImGameListItemDecoration(isFocusStyle);
            this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.mImGameListItemDecoration);
            this.mMainAdapter.setFocusItemSize(this.mFocusGameList == null ? 0 : this.mFocusGameList.size());
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mMainAdapter);
            this.setGameInviteListener();
        } else {
            this.mMainAdapter.setFocusItemSize(this.mFocusGameList == null ? 0 : this.mFocusGameList.size());
            this.mMainAdapter.updateData(datas, isFocusStyle);
        }
        this.showFocusCard(isFocusStyle);
        this.mRecyclerView.postDelayed(new Runnable(){

            @Override
            public void run() {
                NewGameListLayout.this.reportGameListEvent();
            }
        }, 200L);
    }

    private void showFocusCard(boolean focus) {
        if (this.mImGameListItemDecoration != null) {
            this.mImGameListItemDecoration.setIsFocusStyle(focus);
        }
        if (!focus) {
            this.mGameListTip.setVisibility(8);
            this.mLayoutGameList.setPadding(0, 0, 0, 0);
            this.mLayoutGameList.setBackgroundResource(R.color.white);
            this.mSlideLayoutParams.topMargin = ResolutionUtils.dip2Px((float)0.0f);
            this.mSeeMoreLayout.setLayoutParams((ViewGroup.LayoutParams)this.mSlideLayoutParams);
            this.mSpaceShadowView.setVisibility(0);
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.mGameListTip.getText())) {
                this.mGameListTip.setVisibility(0);
            } else {
                this.mGameListTip.setVisibility(8);
            }
            this.mLayoutGameList.setPadding(ResolutionUtils.dip2Px((float)15.0f), ResolutionUtils.dip2Px((float)15.0f), ResolutionUtils.dip2Px((float)15.0f), ResolutionUtils.dip2Px((float)15.0f));
            this.mLayoutGameList.setBackgroundResource(R.drawable.ico_im_game_focus_card_shadow);
            this.mSlideLayoutParams.topMargin = ResolutionUtils.dip2Px((float)50.0f);
            this.mSeeMoreLayout.setLayoutParams((ViewGroup.LayoutParams)this.mSlideLayoutParams);
            this.mSpaceShadowView.setVisibility(8);
        }
    }

    private void initListener() {
        this.mHorizOverScrollEffect.setOverScrollUpdateListener(new IOverScrollUpdateListener(){

            public void onOverScrollUpdate(IOverScrollDecor decor, int state2, float offset) {
                if (offset > 0.0f && !LanguageUtils.isRtl()) {
                    return;
                }
                if (offset < 0.0f && LanguageUtils.isRtl()) {
                    return;
                }
                if (NewGameListLayout.this.mDrawerLayout == null && NewGameListLayout.this.mDrawerView == null) {
                    return;
                }
                if (NewGameListLayout.this.mDraging) {
                    return;
                }
                float distance = (float)NewGameListLayout.this.mSeeMoreLayout.getWidth() * 0.6f - (float)ResolutionUtils.dip2Px((float)30.0f);
                NewGameListLayout.this.mHorizOverScrollEffect.setMaxLeftSlideDistance((int)distance);
                if ((float)Math.abs((int)offset) >= distance) {
                    try {
                        Vibrator vib = (Vibrator)NewGameListLayout.this.getContext().getSystemService("vibrator");
                        vib.vibrate(100L);
                    }
                    catch (Exception e) {
                        MLog.info((Object)NewGameListLayout.TAG, (String)"initListener ex: %s", (Object[])new Object[]{e});
                    }
                    NewGameListLayout.this.mIsLeftSlidingOpen = true;
                    NewGameListLayout.this.openImGameDrawer();
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "sliding_more_show"));
                }
                NewGameListLayout.this.setSeeMoreViewSize(NewGameListLayout.this.mSeeMoreViewMarginEnd, LanguageUtils.isRtl() ? -offset : offset);
            }
        });
        this.mSeeMoreLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewGameListLayout.this.openImGameDrawer();
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "more_game_click").put("ent_id", "0"));
            }
        });
        this.mDrawerLayout.addDrawerListener(new DrawerLayout.DrawerListener(){

            public void onDrawerSlide(@NonNull View view, float v) {
                NewGameListLayout.this.mDraging = true;
                NewGameListLayout.this.setSeeMoreViewSize(NewGameListLayout.this.mSeeMoreViewMarginEnd, (float)(-view.getWidth()) * v);
                NewGameListLayout.this.setShadowAlpha(v);
                if (v == 0.0f) {
                    NewGameListLayout.this.mDraging = false;
                }
            }

            public void onDrawerOpened(@NonNull View view) {
                NewGameListLayout.this.mDraging = true;
                NewGameListLayout.this.reportDrawerGameListEvent();
                NewGameListLayout.this.mDrawerAdapter.setDrawerOpenWay(NewGameListLayout.this.mIsLeftSlidingOpen);
                NewGameListLayout.this.mIsLeftSlidingOpen = false;
            }

            public void onDrawerClosed(@NonNull View view) {
                NewGameListLayout.this.mDraging = false;
            }

            public void onDrawerStateChanged(int state2) {
                switch (state2) {
                    case 0: {
                        NewGameListLayout.this.mIsDrawLayoutStateDraging = false;
                        break;
                    }
                    case 1: {
                        if (!NewGameListLayout.this.mIsDrawLayoutStateDraging) {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "right_sliding"));
                        }
                        NewGameListLayout.this.mIsDrawLayoutStateDraging = true;
                        break;
                    }
                }
            }
        });
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView2, int newState) {
                super.onScrollStateChanged(recyclerView2, newState);
                switch (newState) {
                    case 0: {
                        NewGameListLayout.this.setSeeMoreBg(R.drawable.ico_im_sidebar_static);
                        NewGameListLayout.this.mIsMainListStateDraging = false;
                        NewGameListLayout.this.reportGameListEvent();
                        break;
                    }
                    case 1: {
                        NewGameListLayout.this.setSeeMoreBg(R.drawable.ico_im_sidebar_sliding);
                        if (!NewGameListLayout.this.mIsMainListStateDraging) {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "list_sliding"));
                        }
                        NewGameListLayout.this.mIsMainListStateDraging = false;
                        break;
                    }
                }
            }
        });
        this.mImDrawerRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView2, int newState) {
                super.onScrollStateChanged(recyclerView2, newState);
                switch (newState) {
                    case 0: {
                        NewGameListLayout.this.reportDrawerGameListEvent();
                        break;
                    }
                }
            }
        });
    }

    private void openImGameDrawer() {
        if (this.mDrawerLayout != null && this.mDrawerView != null) {
            this.mDrawerLayout.openDrawer(this.mDrawerView, true);
        }
    }

    private void setSeeMoreViewSize(int marginEnd, float offset) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.mSlideLayoutParams.setMarginEnd((int)((float)marginEnd - offset));
        } else {
            this.mSlideLayoutParams.rightMargin = (int)((float)marginEnd - offset);
        }
        this.mSeeMoreLayout.setLayoutParams((ViewGroup.LayoutParams)this.mSlideLayoutParams);
    }

    private void setSeeMoreBg(int resId) {
        if (this.mSeeMoreLayout == null) {
            return;
        }
        this.mSeeMoreLayout.setBackgroundResource(resId);
    }

    private void setShadowAlpha(float alpha) {
        this.mShadowView.setAlpha(alpha);
    }

    public boolean canCloseImGameDrawer() {
        if (this.mDrawerLayout != null && this.mDrawerView != null && this.mDrawerLayout.isDrawerOpen(this.mDrawerView)) {
            this.mDrawerLayout.closeDrawer(this.mDrawerView, true);
            return true;
        }
        return false;
    }

    private void initGuideAnimate() {
        boolean aBoolean = SettingFlags.getBoolean((String)"key_im_guide_animate_show", (boolean)false);
        if (aBoolean) {
            return;
        }
        SettingFlags.setBoolean((String)"key_im_guide_animate_show", (boolean)true);
    }

    public void setGameList(List<GameInfo> datas, String gameId, IGameInviteListener listener) {
        this.mListener = listener;
        this.processFocusState(datas);
    }

    public void setDrawerGameList(List<GameInfo> gameInfos) {
        this.initDrawerRV(gameInfos);
        this.initGuideAnimate();
    }

    public void startDownloadGame(GameInfo gameInfo) {
        if (this.mMainAdapter != null) {
            this.mMainAdapter.startDownloadGame(gameInfo);
        }
        if (this.mDrawerAdapter != null) {
            this.mDrawerAdapter.startDownloadGame(gameInfo);
        }
    }

    public void gameDownloadFailed(BasicGameInfo gameInfo) {
        if (this.mMainAdapter != null) {
            this.mMainAdapter.gameDownloadFailed(gameInfo);
        }
        if (this.mDrawerAdapter != null) {
            this.mDrawerAdapter.gameDownloadFailed(gameInfo);
        }
    }

    public void gameDownloadSucceed(GameInfo gameInfo) {
        if (this.mMainAdapter != null) {
            this.mMainAdapter.gameDownloadSucceed(gameInfo);
        }
        if (this.mDrawerAdapter != null) {
            this.mDrawerAdapter.gameDownloadSucceed(gameInfo);
        }
    }

    public void setSendingInviteState(String gameId, boolean sendingInvite) {
        if (this.mMainAdapter != null) {
            this.mMainAdapter.setSendingInviteState(gameId, sendingInvite);
        }
        if (this.mDrawerAdapter != null) {
            this.mDrawerAdapter.setSendingInviteState(gameId, sendingInvite);
        }
    }

    public void show(boolean isAnim) {
        if (isAnim) {
            this.setVisibility(0);
            Animation anim2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.game_list_layout_enter_anim);
            DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
            anim2.setInterpolator((Interpolator)decelerateInterpolator);
            this.startAnimation(anim2);
            anim2.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    NewGameListLayout.this.mSpaceShadowView.setVisibility(8);
                }

                public void onAnimationEnd(Animation animation) {
                    NewGameListLayout.this.mSpaceShadowView.setVisibility(NewGameListLayout.this.mIsFocusStyle ? 8 : 0);
                    NewGameListLayout.this.mSeeMoreLayout.setVisibility(0);
                    NewGameListLayout.this.mDrawerLayout.setDrawerLockMode(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        } else {
            this.setVisibility(0);
        }
    }

    public void hide(boolean isAnim) {
        if (isAnim) {
            Animation exitAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.game_list_layout_exit_anim);
            DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
            exitAnim.setInterpolator((Interpolator)decelerateInterpolator);
            this.startAnimation(exitAnim);
            exitAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    NewGameListLayout.this.mSpaceShadowView.setVisibility(8);
                    NewGameListLayout.this.mDrawerLayout.setDrawerLockMode(1);
                }

                public void onAnimationEnd(Animation animation) {
                    NewGameListLayout.this.setVisibility(8);
                    NewGameListLayout.this.mSeeMoreLayout.setVisibility(8);
                    NewGameListLayout.this.mSpaceShadowView.setVisibility(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        } else {
            this.setVisibility(8);
        }
    }

    private void setGameInviteListener() {
        if (this.mMainAdapter != null) {
            this.mMainAdapter.setGameInviteListener(this.mListener);
        }
        if (this.mDrawerAdapter != null) {
            this.mDrawerAdapter.setGameInviteListener(this.mListener);
        }
    }

    private void reportGameListEvent() {
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearManager = (LinearLayoutManager)layoutManager;
            int lastItemPosition = linearManager.findLastVisibleItemPosition();
            int firstItemPosition = linearManager.findFirstVisibleItemPosition();
            if (this.mMainData == null) {
                return;
            }
            if (firstItemPosition > lastItemPosition) {
                return;
            }
            if (firstItemPosition == this.oldFirstViisible && lastItemPosition == this.oldLastViisible) {
                return;
            }
            ArrayList<String> gidList = new ArrayList<String>();
            ArrayList<String> gTypeList = new ArrayList<String>();
            for (int i = 0; i < this.mMainData.size(); ++i) {
                GameInfo gameInfo;
                if (i < firstItemPosition || i > lastItemPosition || (gameInfo = this.mMainData.get(i)) == null) continue;
                gidList.add(gameInfo.getGid());
                int focusSize = this.mFocusGameList == null ? 0 : this.mFocusGameList.size();
                gTypeList.add(i < focusSize ? "1" : "2");
            }
            if (gidList.size() != gTypeList.size()) {
                return;
            }
            StringBuilder gidSB = new StringBuilder();
            int position = 0;
            for (int i = 0; i < gidList.size(); ++i) {
                position = firstItemPosition + i + 1;
                if (i == gidList.size() - 1) {
                    gidSB.append((String)gidList.get(i) + ":" + (String)gTypeList.get(i) + ":" + position + ":" + 1);
                    gidSB.append(":");
                    gidSB.append(NewGameListLayout.urlEncoderContent(ImRecommendGameInfoManager.INSTANCE.getToken(this.mTargetUid)));
                    continue;
                }
                gidSB.append((String)gidList.get(i) + ":" + (String)gTypeList.get(i) + ":" + position + ":" + 1);
                gidSB.append(":");
                gidSB.append(NewGameListLayout.urlEncoderContent(ImRecommendGameInfoManager.INSTANCE.getToken(this.mTargetUid)));
                gidSB.append("#");
            }
            this.oldFirstViisible = firstItemPosition;
            this.oldLastViisible = lastItemPosition;
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "list_game_show").put("gid_type", NewGameListLayout.urlEncoderContent(gidSB.toString())).put("act_uid", this.getTargetUid()));
        }
    }

    public boolean isFocusGame(GameInfo gameInfo) {
        if (this.mFocusGameList != null && this.mFocusGameList.size() > 0 && gameInfo != null) {
            for (GameInfo info : this.mFocusGameList) {
                if (info == null || info.gid == null || !info.gid.equals(gameInfo.gid)) continue;
                return true;
            }
        }
        return false;
    }

    private void reportDrawerGameListEvent() {
        RecyclerView.LayoutManager layoutManager = this.mImDrawerRecyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager linearManager = (GridLayoutManager)layoutManager;
            int lastItemPosition = linearManager.findLastVisibleItemPosition();
            int firstItemPosition = linearManager.findFirstVisibleItemPosition();
            if (this.mDrawerData == null) {
                return;
            }
            if (firstItemPosition > lastItemPosition) {
                return;
            }
            if (firstItemPosition == this.oldDrawerFirstViisible && lastItemPosition == this.oldDrawerLastViisible) {
                return;
            }
            ArrayList<String> gidList = new ArrayList<String>();
            ArrayList<String> gTypeList = new ArrayList<String>();
            for (int i = 0; i < this.mDrawerData.size(); ++i) {
                GameInfo gameInfo;
                if (i < firstItemPosition || i > lastItemPosition || (gameInfo = this.mDrawerData.get(i)) == null) continue;
                gidList.add(gameInfo.getGid());
                int focusSize = this.mFocusGameList == null ? 0 : this.mFocusGameList.size();
                gTypeList.add(i < focusSize ? "1" : "2");
            }
            if (gidList.size() != gTypeList.size()) {
                return;
            }
            StringBuilder gidSB = new StringBuilder();
            StringBuilder gidTypeSB = new StringBuilder();
            int rowId = 0;
            int columnId = 0;
            for (int i = 0; i < gidList.size(); ++i) {
                rowId = firstItemPosition + i / 2 + 1;
                columnId = i % 2 == 0 ? 1 : 2;
                if (i == gidList.size() - 1) {
                    gidSB.append((String)gidList.get(i));
                    gidTypeSB.append((String)gidList.get(i));
                    gidTypeSB.append(":");
                    gidTypeSB.append((String)gTypeList.get(i));
                    gidTypeSB.append(":");
                    gidTypeSB.append(rowId);
                    gidTypeSB.append(":");
                    gidTypeSB.append(columnId);
                    gidTypeSB.append(":");
                    gidTypeSB.append(NewGameListLayout.urlEncoderContent(ImRecommendGameInfoManager.INSTANCE.getToken(this.mTargetUid)));
                    continue;
                }
                gidSB.append((String)gidList.get(i));
                gidSB.append("#");
                gidTypeSB.append((String)gidList.get(i));
                gidTypeSB.append(":");
                gidTypeSB.append((String)gTypeList.get(i));
                gidTypeSB.append(":");
                gidTypeSB.append(rowId);
                gidTypeSB.append(":");
                gidTypeSB.append(columnId);
                gidTypeSB.append(":");
                gidTypeSB.append(NewGameListLayout.urlEncoderContent(ImRecommendGameInfoManager.INSTANCE.getToken(this.mTargetUid)));
                gidTypeSB.append("#");
            }
            this.oldDrawerFirstViisible = firstItemPosition;
            this.oldDrawerLastViisible = lastItemPosition;
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "sliding_game_show").put("gid", gidSB.toString()).put("gid_type", NewGameListLayout.urlEncoderContent(gidTypeSB.toString())).put("more_show_type", this.mIsLeftSlidingOpen ? "1" : "2").put("act_uid", this.getTargetUid()));
        }
    }

    private String getTargetUid() {
        try {
            return String.valueOf(this.mTargetUid);
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"getTargetUid exception=%s", (Object[])new Object[]{e});
            return "";
        }
    }

    private static String urlEncoderContent(String token) {
        if (StringUtils.isEmpty((String)token)) {
            return "null";
        }
        try {
            return URLEncoder.encode(token, "UTF-8");
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"urlEncoderContent e=%s", (Object[])new Object[]{e.toString()});
            return token;
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mMainAdapter != null) {
            this.mMainAdapter.clearAnimator(this.mRecyclerView);
        }
        super.onDetachedFromWindow();
    }
}

