/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget.joinedchannel;

import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.hiyo.channel.base.bean.MyChannelControlConfig;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.im.ui.widget.joinedchannel.IJoinedChannelCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JoinedChannelManager
implements INotify {
    public static final String TAG = "JoinedChannelManager";
    private int mCount;
    private IJoinedChannelCallback mCallback;

    public JoinedChannelManager(int count, IJoinedChannelCallback callback) {
        this.mCount = count;
        this.mCallback = callback;
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_INVITATION_HANDLE_RESULT, (INotify)this);
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.mCallback.clear();
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            Boolean isForeground = (Boolean)notification.extObj;
            if (isForeground.booleanValue() && this.mCallback.isPageShow()) {
                this.getGroupData();
            }
        } else if (notification.id == NotificationIdDef.CHANNEL_INVITATION_HANDLE_RESULT && notification.extObj instanceof Boolean && ((Boolean)notification.extObj).booleanValue()) {
            ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getMyJoinedChannels(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

                public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                    JoinedChannelManager.this.handleChannelData(groupSummays);
                }

                public void onError(int errorCode, Exception e) {
                }
            }, true);
        }
    }

    public void getGroupData() {
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getMyJoinedChannels(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                JoinedChannelManager.this.handleChannelData(groupSummays);
            }

            public void onError(int errorCode, Exception e) {
            }
        }, false);
    }

    private void handleChannelData(final ArrayList<MyJoinChannelItem> groupSummays) {
        MLog.info((Object)TAG, (String)"handleChannelData, size = %s", (Object[])new Object[]{FP.size(groupSummays)});
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!FP.empty((Collection)groupSummays)) {
                    JoinedChannelManager.this.mCallback.show();
                    List list = JoinedChannelManager.this.convertTo(groupSummays);
                    JoinedChannelManager.this.mCallback.updateData(list);
                    ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(JoinedChannelManager.this.getUidList(groupSummays), new OnProfileCallback(){

                        public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                            if (!FP.empty(userInfoKSList)) {
                                JoinedChannelManager.this.mCallback.updateUserInfo(userInfoKSList);
                            }
                        }

                        public void onFail(int id2, String msg, String response) {
                        }

                        public int id() {
                            return 0;
                        }
                    });
                } else {
                    JoinedChannelManager.this.mCallback.hide();
                }
            }
        });
    }

    private List<Long> getUidList(List<MyJoinChannelItem> list) {
        ArrayList<Long> uids = new ArrayList<Long>();
        if (!FP.empty(list)) {
            for (MyJoinChannelItem summary : list) {
                uids.add(summary.ownerUid);
            }
        }
        return uids;
    }

    public void getBackground() {
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getControlConfig(new IChannelCenterService.IGetControlConfigCallBack(){

            public void onSuccess(final MyChannelControlConfig controlConfig) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (controlConfig != null) {
                            JoinedChannelManager.this.mCallback.updateBackground(controlConfig.bgcolors);
                        }
                    }
                });
            }

            public void onError(int errorCode, String errorTips, Exception e) {
            }
        });
    }

    private List<JoinedChannelInfo> convertTo(List<MyJoinChannelItem> list) {
        ArrayList<JoinedChannelInfo> groupInfoList = null;
        if (!FP.empty(list)) {
            groupInfoList = new ArrayList<JoinedChannelInfo>();
            for (int i = 0; i < list.size(); ++i) {
                MyJoinChannelItem summary = list.get(i);
                JoinedChannelInfo groupInfo = new JoinedChannelInfo(summary);
                groupInfoList.add(groupInfo);
            }
        }
        return groupInfoList;
    }
}

