/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.base.logger.MLog;

public class MyViewPager
extends ViewPager {
    private static final String TAG = "MyViewPager";
    private VelocityTracker mVelocityTracker;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;

    public MyViewPager(@NonNull Context context) {
        this(context, null);
    }

    public MyViewPager(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean result = super.onTouchEvent(ev);
        PagerAdapter adapter2 = this.getAdapter();
        if (adapter2 == null || adapter2.getCount() == 0) {
            return false;
        }
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                    break;
                }
                this.mVelocityTracker.clear();
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                }
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker == null) break;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                int initialVelocityX = (int)velocityTracker.getXVelocity();
                if (Math.abs(initialVelocityX) <= this.mMinimumFlingVelocity || Math.abs(initialVelocityX) <= 6000) break;
                this.startFling(initialVelocityX);
                result = true;
                break;
            }
            case 3: {
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                }
                this.mVelocityTracker = null;
                break;
            }
        }
        return result;
    }

    public void startFling(int initialVelocityX) {
        if (initialVelocityX == 0) {
            return;
        }
        if (this.beginFakeDrag()) {
            this.fakeDragBy((float)initialVelocityX * 0.4f);
            MLog.info((Object)TAG, (String)("initialVelocityX=" + initialVelocityX + ",getCurrentItem=" + this.getCurrentItem()), (Object[])new Object[0]);
            this.endFakeDrag();
        }
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        int result = -1;
        try {
            result = super.getChildDrawingOrder(childCount, i);
        }
        catch (IndexOutOfBoundsException e) {
            String error = "MyViewPager getChildDrawingOrder count:" + childCount + " i:" + i + " ";
            MLog.error((Object)TAG, (String)(error + " msg:" + e.getMessage()), (Object[])new Object[0]);
            result = Integer.MAX_VALUE;
        }
        return result;
    }
}

