/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.SpannableString;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.edit.FixEditTextView;
import com.yy.appbase.ui.widget.indicator.CirclePageIndicator;
import com.yy.base.keyevent.OwnKeyEvent;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.emotion.base.emoji.EmojiEntity;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.im.R;
import com.yy.im.module.room.adapter.EmotionAdapter;
import com.yy.im.module.room.adapter.InteractiveFacePagerAdapter;
import com.yy.im.module.room.adapter.SmileFacePagerAdapter;
import com.yy.im.module.room.callback.InputCallback;
import com.yy.im.module.room.data.EmojiTypeData;
import com.yy.im.module.room.data.InteractiveEmojiTypeHelper;
import com.yy.im.module.room.emoji.DressEmojiBean;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class EmojiEmotionsView
extends YYRelativeLayout
implements InputCallback.EmotionDataCallback,
InputCallback.EmotionViewCallback {
    public static final int EMOJI_NORMAL = 0;
    public static final int EMOJI_INTERACTIVE = 1;
    public static final int EMOJI_DRESSUP = 2;
    ViewPager viewPager;
    CirclePageIndicator pageIndicator;
    static final int COLUMN = 7;
    static final int ROW = 3;
    static final int VERTICAL_SPACING = 20;
    Context activity;
    FixEditTextView inputEditText;
    long mClientUid;
    int entId;
    int emojiType;
    EmojiEmotionCallback mEmojiEmotionCallback;
    OnDresupEmojiClickListener mDresupEmojiClickListener;
    InteractiveFacePagerAdapter adapter;
    public View.OnClickListener interactiveEmojiClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v.getTag() != null) {
                EmojiTypeData data2 = (EmojiTypeData)v.getTag();
                if (EmojiEmotionsView.this.mEmojiEmotionCallback != null) {
                    EmojiEmotionsView.this.mEmojiEmotionCallback.clickEmoji(data2);
                }
            }
        }
    };

    public EmojiEmotionsView(Context context, FixEditTextView inputEditText, int emojiType) {
        super(context);
        this.inputEditText = inputEditText;
        this.emojiType = emojiType;
        this.init();
    }

    public void setEmojiEmotionCallback(EmojiEmotionCallback callback) {
        this.mEmojiEmotionCallback = callback;
    }

    public void setOnDresupEmojiClickListener(OnDresupEmojiClickListener listener) {
        this.mDresupEmojiClickListener = listener;
    }

    private void init() {
        this.activity = this.getContext();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_im_emotions, (ViewGroup)this, true);
        this.genEmojiPager();
    }

    private void genEmojiPager() {
        this.viewPager = (ViewPager)this.findViewById(R.id.vp_msg_input_emoticon);
        this.pageIndicator = (CirclePageIndicator)this.findViewById(R.id.page_indicator);
        if (this.emojiType == 0) {
            ArrayList emojiArray = new ArrayList();
            emojiArray.addAll(EmojiManager.INSTANCE.getEmojiData());
            int onePageNumber = 20;
            int page2 = (int)Math.ceil(((float)emojiArray.size() + 0.0f) / (float)onePageNumber);
            int star = 0;
            int end = 0;
            ArrayList<View> gridViews = new ArrayList<View>();
            for (int i = 0; i < page2; ++i) {
                List<EmojiEntity> array = new ArrayList();
                if (i == page2 - 1) {
                    array = emojiArray.subList(end, emojiArray.size());
                } else {
                    star = i * onePageNumber;
                    end = (i + 1) * onePageNumber;
                    array.addAll(emojiArray.subList(star, end));
                }
                array.add(new EmojiEntity(0));
                GridView gridView = new GridView(this.activity);
                gridView.setSelector((Drawable)new ColorDrawable(0));
                gridView.setNumColumns(7);
                gridView.setGravity(17);
                gridView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
                EmotionAdapter adapter2 = new EmotionAdapter(this.activity);
                gridView.setAdapter((ListAdapter)adapter2);
                adapter2.setDatas(array);
                EmojiItemClickListener itemClickListener = new EmojiItemClickListener(array);
                gridView.setOnItemClickListener((AdapterView.OnItemClickListener)itemClickListener);
                gridViews.add((View)gridView);
            }
            this.viewPager.setAdapter((PagerAdapter)new SmileFacePagerAdapter(gridViews));
            this.pageIndicator.setViewPager(this.viewPager);
        } else if (this.emojiType == 1) {
            DResource[] emotionArray = InteractiveEmojiTypeHelper.getInteractiveEmotionArray();
            this.adapter = new InteractiveFacePagerAdapter(this.activity, emotionArray, new InteractiveFacePagerAdapter.InteractiveFaceCallback(){

                @Override
                public void clickInteractiveFace(EmojiTypeData data2) {
                    if (EmojiEmotionsView.this.mEmojiEmotionCallback != null) {
                        EmojiEmotionsView.this.mEmojiEmotionCallback.clickEmoji(data2);
                    }
                }
            });
            this.viewPager.setAdapter((PagerAdapter)this.adapter);
            this.pageIndicator.setViewPager(this.viewPager);
            this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                }

                public void onPageSelected(int position) {
                    if (EmojiEmotionsView.this.adapter != null) {
                        EmojiEmotionsView.this.adapter.showAnimation(position);
                    }
                }

                public void onPageScrollStateChanged(int state2) {
                }
            });
        } else if (this.emojiType == 2) {
            // empty if block
        }
    }

    @Override
    public void setData(long mClientUid, int entId) {
        this.mClientUid = mClientUid;
        this.entId = entId;
    }

    @Override
    public void setCurrentItem(int position) {
        if (this.viewPager.getAdapter().getCount() > position && this.viewPager.getCurrentItem() != position) {
            this.viewPager.setCurrentItem(position);
        }
    }

    @Override
    public void toLastItem() {
        if (this.viewPager.getAdapter().getCount() > 0 && this.viewPager.getCurrentItem() != this.viewPager.getAdapter().getCount() - 1) {
            this.viewPager.setCurrentItem(this.viewPager.getAdapter().getCount() - 1);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.adapter != null) {
            this.adapter.stopAnimation();
        }
    }

    public static interface OnDresupEmojiClickListener {
        public void clickDressupEmoji(DressEmojiBean var1);

        public void clickDressupGoAhead(View var1);
    }

    public static interface EmojiEmotionCallback {
        public void clickEmoji(EmojiTypeData var1);
    }

    public class EmojiItemClickListener
    implements AdapterView.OnItemClickListener {
        List<EmojiEntity> emojiArray;
        Activity context;

        public EmojiItemClickListener(List<EmojiEntity> emojiArray) {
            this.emojiArray = emojiArray;
            this.context = (Activity)EmojiEmotionsView.this.inputEditText.getContext();
        }

        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
            EmojiEmotionsView.this.inputEditText.requestFocus();
            EmojiEntity emojiEntity = this.emojiArray.get(i);
            if (emojiEntity.getId() == 0) {
                this.context.dispatchKeyEvent((KeyEvent)new OwnKeyEvent(0, 67, false));
                this.context.dispatchKeyEvent((KeyEvent)new OwnKeyEvent(1, 67, false));
            } else {
                int index = EmojiEmotionsView.this.inputEditText.getSelectionStart();
                Editable editText = EmojiEmotionsView.this.inputEditText.getEditableText();
                SpannableString emojiStr = EmojiManager.INSTANCE.getNewEmojiImage(emojiEntity.getCode());
                if (index < 0 || index >= editText.length()) {
                    editText.append((CharSequence)emojiStr);
                } else {
                    editText.insert(index, (CharSequence)emojiStr);
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EmojiType {
    }
}

