/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.RoundedImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.widget.GameLabelView;
import com.yy.im.R;
import com.yy.im.ui.widget.ClickAndScaleAutoFixButton;
import com.yy.im.ui.widget.ClickAndScaleButton;
import com.yy.im.ui.widget.GameHeaderView;
import com.yy.im.ui.widget.NewGameCountdownView;
import java.util.Locale;
import java.util.Map;

public class ComplexGameInviteCardLayout
extends YYRelativeLayout
implements NewGameCountdownView.ICountdownFinishListener,
View.OnClickListener {
    private ClickAndScaleButton mBtnCancel;
    private ClickAndScaleAutoFixButton mBtnDecline;
    private ClickAndScaleAutoFixButton mBtnJoin;
    private View mGameOverIcon;
    private NewGameCountdownView mCountdownView;
    private YYTextView mGameTitle;
    private RecycleImageView mRivGameCover;
    private RoundedImageView mGameCoverIv;
    private RoundedImageView mGameTransView;
    private RoundedImageView mMaskLayout;
    private YYImageView mIvLight;
    private View mJoinLayout;
    private GameLabelView mGameLabel;
    private int mState = 1;
    private GameInfo mData;
    private IInviteOperateListener mOperateListener;
    private String mPkId;
    private String mGameModeName;
    private Map<String, Object> mExtend;
    private boolean mIsDownloading = false;
    private boolean mHadJoinGame = false;
    private Animation mLightAnim;
    private YYImageView mStateMask;
    private YYTextView mStateTip;
    private GameHeaderView mGameHeaderView;
    private GameHeaderView mOtherGameHeaderView;
    private YYTextView mWinCountTv;

    public ComplexGameInviteCardLayout(Context context) {
        this(context, null);
    }

    public ComplexGameInviteCardLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ComplexGameInviteCardLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ComplexGameInviteCardLayout.inflate((Context)context, (int)R.layout.layout_im_game_card, (ViewGroup)this);
        this.mCountdownView = (NewGameCountdownView)this.findViewById(R.id.countdown_view);
        this.mBtnCancel = (ClickAndScaleButton)this.findViewById(R.id.btn_cancel);
        this.mBtnDecline = (ClickAndScaleAutoFixButton)this.findViewById(R.id.btn_decline);
        this.mBtnJoin = (ClickAndScaleAutoFixButton)this.findViewById(R.id.btn_join);
        this.mGameTitle = (YYTextView)this.findViewById(R.id.game_title_tv);
        this.mGameHeaderView = (GameHeaderView)this.findViewById(R.id.gameHeaderView);
        this.mOtherGameHeaderView = (GameHeaderView)this.findViewById(R.id.gameOtherHeaderView);
        this.mStateMask = (YYImageView)this.findViewById(R.id.mGameMask);
        this.mStateTip = (YYTextView)this.findViewById(R.id.mGameMaskTip);
        this.mGameCoverIv = (RoundedImageView)this.findViewById(R.id.rciv_game_cover);
        this.mGameTransView = (RoundedImageView)this.findViewById(R.id.rciv_zhezhao);
        this.mRivGameCover = (RecycleImageView)this.findViewById(R.id.game_cover_iv);
        this.mMaskLayout = (RoundedImageView)this.findViewById(R.id.mask_layout);
        this.mJoinLayout = this.findViewById(R.id.fl_join);
        this.mIvLight = (YYImageView)this.findViewById(R.id.iv_light);
        this.mGameLabel = (GameLabelView)this.findViewById(R.id.game_label);
        this.mGameOverIcon = this.findViewById(R.id.mGameOverTip);
        this.mWinCountTv = (YYTextView)this.findViewById(R.id.tv_win_count);
        this.mCountdownView.setCountdownFinishListener(this);
        this.mBtnCancel.setOnClickListener(this);
        this.mBtnDecline.setOnClickListener(this);
        this.mBtnJoin.setOnClickListener(this);
        this.mCountdownView.setBackgroundColor(0x4DFFFFFF);
        this.mStateTip.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoTitle));
        this.modifyJoinTextInRussian();
        this.changeJoinTextSize();
    }

    public void setOperateListener(IInviteOperateListener operateListener) {
        this.mOperateListener = operateListener;
    }

    public void setState(int state2) {
        this.mState = state2;
        this.mCountdownView.setState(state2);
        if (state2 == 2) {
            this.resetGameState();
            this.mBtnCancel.setVisibility(8);
            this.mBtnDecline.setVisibility(0);
            this.mBtnJoin.setVisibility(0);
            this.mJoinLayout.setVisibility(0);
            this.startLightAnim();
        } else if (state2 == 1) {
            this.resetGameState();
            this.mBtnCancel.setVisibility(0);
            this.mBtnDecline.setVisibility(8);
            this.mBtnJoin.setVisibility(8);
            this.mJoinLayout.setVisibility(8);
        } else {
            this.mBtnCancel.setVisibility(8);
            this.mBtnDecline.setVisibility(8);
            this.mBtnJoin.setVisibility(8);
            this.mJoinLayout.setVisibility(8);
            this.mGameOverIcon.setVisibility(0);
        }
    }

    public void setData(GameInfo data2, String pkId, String gameModeName, Map<String, Object> ext) {
        this.mData = data2;
        this.mPkId = pkId;
        this.mGameModeName = gameModeName;
        this.mExtend = ext;
        ImageLoader.loadImage((ImageView)this.mGameCoverIv, (String)data2.getImIconUrl());
        if (!StringUtils.isEmpty((String)this.mGameModeName)) {
            this.mGameTitle.setText((CharSequence)(data2.getGname() + "-" + this.mGameModeName));
        } else {
            this.mGameTitle.setText((CharSequence)data2.getGname());
        }
        this.mGameLabel.setGameLabel(data2.getGameLabel());
    }

    public void setWinCount(int winCount) {
        if (winCount > 0) {
            this.mWinCountTv.setVisibility(0);
            this.mWinCountTv.setText((CharSequence)ResourceUtils.getString((int)R.string.game_match_win_count_title, (Object[])new Object[]{winCount}));
            this.mGameCoverIv.setNoRadius();
            this.mGameTransView.setNoRadius();
            this.mMaskLayout.setNoRadius();
        } else {
            this.mWinCountTv.setVisibility(8);
            this.mGameCoverIv.setRadius((float)ResolutionUtils.dip2Px((float)12.0f), (float)ResolutionUtils.dip2Px((float)3.0f), 0.0f, 0.0f);
            this.mGameTransView.setRadius((float)ResolutionUtils.dip2Px((float)12.0f), (float)ResolutionUtils.dip2Px((float)3.0f), 0.0f, 0.0f);
            this.mMaskLayout.setRadius((float)ResolutionUtils.dip2Px((float)12.0f), (float)ResolutionUtils.dip2Px((float)3.0f), 0.0f, 0.0f);
        }
    }

    public void startCountdown() {
        if (!this.mHadJoinGame) {
            this.mGameTransView.setVisibility(8);
            this.mMaskLayout.setVisibility(0);
            this.mCountdownView.setVisibility(0);
            this.mCountdownView.startCountdown();
        }
    }

    public void stopCountDown() {
        if (this.mCountdownView != null) {
            this.mCountdownView.stopCountDown();
        }
    }

    @Override
    public void countdownFinish() {
        if (this.mState == 1) {
            this.operateCallback(0, true);
        } else if (this.mState == 2) {
            this.operateCallback(1, true);
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.btn_cancel) {
            MLog.info((Object)"GameInviteCardLayout", (String)"\u70b9\u51fbcancel", (Object[])new Object[0]);
            this.operateCallback(0, false);
            this.disableBtnAWhile(view);
        } else if (view.getId() == R.id.btn_decline) {
            this.operateCallback(1, false);
            this.disableBtnAWhile(view);
        } else if (view.getId() == R.id.btn_join) {
            if (this.mIsDownloading) {
                return;
            }
            if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                return;
            }
            this.mBtnJoin.setText(R.string.im_game_launching);
            this.operateCallback(2, false);
            this.disableBtnAWhile(view);
        }
    }

    private void disableBtnAWhile(final View btn) {
        btn.setEnabled(false);
        btn.postDelayed(new Runnable(){

            @Override
            public void run() {
                btn.setEnabled(true);
            }
        }, 1000L);
    }

    private void operateCallback(int opr, boolean isTimeout) {
        this.mGameTransView.setVisibility(0);
        this.mCountdownView.setVisibility(8);
        this.mMaskLayout.setVisibility(8);
        this.mCountdownView.destroy();
        if (this.mOperateListener != null) {
            this.mOperateListener.gameInviteOperate(opr, isTimeout, this.mData, this.mPkId, this, this.mExtend);
        }
    }

    public GameInfo getData() {
        return this.mData;
    }

    public String getPkId() {
        return this.mPkId;
    }

    public int getState() {
        return this.mState;
    }

    public void setStartTime(long startTime) {
        this.mCountdownView.setStartTime(startTime);
    }

    private void startLightAnim() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ComplexGameInviteCardLayout.this.initLightAnim(ComplexGameInviteCardLayout.this.mBtnJoin.getMeasuredWidth() + ComplexGameInviteCardLayout.this.mIvLight.getMeasuredWidth());
                if (ComplexGameInviteCardLayout.this.mLightAnim != null) {
                    ComplexGameInviteCardLayout.this.mIvLight.startAnimation(ComplexGameInviteCardLayout.this.mLightAnim);
                }
            }
        });
    }

    private void stopLightAnim() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ComplexGameInviteCardLayout.this.mLightAnim != null) {
                    ComplexGameInviteCardLayout.this.mLightAnim.cancel();
                }
            }
        });
    }

    private void initLightAnim(int width) {
        if (this.mLightAnim == null) {
            if (width <= 0) {
                return;
            }
            if (LanguageUtils.isRtl()) {
                width = -width;
            }
            this.mLightAnim = new TranslateAnimation(0.0f, (float)width, 0.0f, 0.0f);
            this.mLightAnim.setFillAfter(false);
            this.mLightAnim.setRepeatCount(-1);
            this.mLightAnim.setDuration(300L);
            this.mLightAnim.setStartOffset(1000L);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopLightAnim();
    }

    public void setJoinBtnStatus(boolean enable) {
        if (this.mBtnJoin != null) {
            this.mBtnJoin.setEnabled(enable);
        }
    }

    private void modifyJoinTextInRussian() {
        String joinStr = this.mBtnJoin.getText().toString();
        if (TextUtils.isEmpty((CharSequence)joinStr)) {
            return;
        }
        if (joinStr.equalsIgnoreCase(ResourceUtils.getString((int)R.string.join)) && "ru".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            this.mBtnJoin.setText(ResourceUtils.getString((int)R.string.accept));
        }
    }

    private void changeJoinTextSize() {
        if ("ru".equalsIgnoreCase(Locale.getDefault().getLanguage()) || "pt".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            this.mBtnJoin.setAutoFit(true);
            this.mBtnDecline.setAutoFit(true);
        } else {
            this.mBtnJoin.setAutoFit(false);
            this.mBtnDecline.setAutoFit(false);
        }
    }

    public void setWinState(String headUrl) {
        this.mStateMask.setVisibility(0);
        this.mStateTip.setVisibility(0);
        this.mStateTip.setText((CharSequence)ResourceUtils.getString((int)R.string.im_game_win));
        this.mGameHeaderView.setVisibility(0);
        this.mGameHeaderView.updateHeader(headUrl + YYImageUtils.getThumbnailPostfix((int)75));
        this.mGameHeaderView.updateResultStatus(1);
        this.mGameHeaderView.updateWinMarkStatus(true);
        this.mStateMask.setImageResource(R.drawable.im_game_result_win_mask);
        this.mCountdownView.setVisibility(8);
    }

    public void setWinState(String headUrl, String otherHeadUrl) {
        this.mStateMask.setVisibility(0);
        this.mStateTip.setVisibility(0);
        this.mStateTip.setText((CharSequence)ResourceUtils.getString((int)R.string.im_game_win));
        this.mGameHeaderView.setVisibility(0);
        this.mGameHeaderView.updateHeader(headUrl + YYImageUtils.getThumbnailPostfix((int)75));
        this.mGameHeaderView.updateResultStatus(1);
        this.mGameHeaderView.updateWinMarkStatus(false);
        this.mOtherGameHeaderView.setVisibility(0);
        this.mOtherGameHeaderView.updateHeader(otherHeadUrl + YYImageUtils.getThumbnailPostfix((int)75));
        this.mOtherGameHeaderView.updateResultStatus(1);
        this.mOtherGameHeaderView.updateWinMarkStatus(true);
        this.mStateMask.setImageResource(R.drawable.im_game_result_win_mask);
        this.mCountdownView.setVisibility(8);
    }

    public void setLostState(String headUrl) {
        this.mStateMask.setVisibility(0);
        this.mStateTip.setVisibility(0);
        this.mStateTip.setText((CharSequence)ResourceUtils.getString((int)R.string.im_game_lost));
        this.mGameHeaderView.setVisibility(0);
        this.mGameHeaderView.updateHeader(headUrl + YYImageUtils.getThumbnailPostfix((int)75));
        this.mGameHeaderView.updateResultStatus(2);
        this.mGameHeaderView.updateWinMarkStatus(false);
        this.mStateMask.setImageResource(R.drawable.im_game_result_lost_mask);
        this.mCountdownView.setVisibility(8);
    }

    public void setLostState(String headUrl, String otherHeadUrl) {
        this.mStateMask.setVisibility(0);
        this.mStateTip.setVisibility(0);
        this.mStateTip.setText((CharSequence)ResourceUtils.getString((int)R.string.im_game_lost));
        this.mGameHeaderView.setVisibility(0);
        this.mGameHeaderView.updateHeader(headUrl + YYImageUtils.getThumbnailPostfix((int)75));
        this.mGameHeaderView.updateResultStatus(2);
        this.mGameHeaderView.updateWinMarkStatus(false);
        this.mOtherGameHeaderView.setVisibility(0);
        this.mOtherGameHeaderView.updateHeader(otherHeadUrl + YYImageUtils.getThumbnailPostfix((int)75));
        this.mOtherGameHeaderView.updateResultStatus(2);
        this.mOtherGameHeaderView.updateWinMarkStatus(false);
        this.mStateMask.setImageResource(R.drawable.im_game_result_lost_mask);
        this.mCountdownView.setVisibility(8);
    }

    public void setTieState(String headUrl) {
        this.mStateMask.setVisibility(0);
        this.mStateTip.setVisibility(0);
        this.mStateTip.setText((CharSequence)ResourceUtils.getString((int)R.string.im_game_tie));
        this.mGameHeaderView.setVisibility(0);
        this.mGameHeaderView.updateHeader(headUrl + YYImageUtils.getThumbnailPostfix((int)75));
        this.mGameHeaderView.updateResultStatus(3);
        this.mGameHeaderView.updateWinMarkStatus(false);
        this.mStateMask.setImageResource(R.drawable.im_game_result_tie_mask);
        this.mCountdownView.setVisibility(8);
    }

    public void setTieState(String headUrl, String otherHeadUrl) {
        this.mStateMask.setVisibility(0);
        this.mStateTip.setVisibility(0);
        this.mStateTip.setText((CharSequence)ResourceUtils.getString((int)R.string.im_game_tie));
        this.mGameHeaderView.setVisibility(0);
        this.mGameHeaderView.updateHeader(headUrl + YYImageUtils.getThumbnailPostfix((int)75));
        this.mGameHeaderView.updateResultStatus(3);
        this.mGameHeaderView.updateWinMarkStatus(false);
        this.mOtherGameHeaderView.setVisibility(0);
        this.mOtherGameHeaderView.updateHeader(otherHeadUrl + YYImageUtils.getThumbnailPostfix((int)75));
        this.mOtherGameHeaderView.updateResultStatus(3);
        this.mOtherGameHeaderView.updateWinMarkStatus(false);
        this.mStateMask.setImageResource(R.drawable.im_game_result_tie_mask);
        this.mCountdownView.setVisibility(8);
    }

    public void resetGameState() {
        this.mStateMask.setVisibility(8);
        this.mGameHeaderView.setVisibility(8);
        this.mOtherGameHeaderView.setVisibility(8);
        this.mGameOverIcon.setVisibility(8);
        this.mStateTip.setVisibility(8);
        this.mStateTip.setText((CharSequence)"");
    }

    public static interface IInviteOperateListener {
        public void gameInviteOperate(int var1, boolean var2, GameInfo var3, String var4, ComplexGameInviteCardLayout var5, Map<String, Object> var6);
    }
}

