/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.component;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.hiyo.im.base.SuggestFriendData;
import com.yy.im.R;
import com.yy.im.interfaces.IComponent;
import com.yy.im.interfaces.OnInviteMoreFriendsClick;
import com.yy.im.ui.adapter.AddFriendVerticalAdapter;
import com.yy.im.viewmodel.SuggestedFriendViewModel;
import java.util.ArrayList;
import java.util.List;

public class SuggestedFriendVerticalComponent
implements IComponent {
    private View mRoot;
    private MutableLiveData<List<SuggestFriendData>> mSuggestFriends;
    private Observer<List<SuggestFriendData>> mListObserver;
    private List<SuggestFriendData> mSuggestFriendsList = new ArrayList<SuggestFriendData>();
    private AddFriendVerticalAdapter friendVerticalAdapter;

    public SuggestedFriendVerticalComponent(Context ctx, ViewGroup root2, SuggestedFriendViewModel vm, final OnInviteMoreFriendsClick inviteMoreFriendsClick) {
        this.mRoot = LayoutInflater.from((Context)ctx).inflate(R.layout.im_suggested_friend_recyclerview, root2, false);
        this.mSuggestFriends = vm.getSuggestedFriendDatas();
        final RecyclerView rvAddFriend = (RecyclerView)this.mRoot.findViewById(R.id.rv_add_friend);
        rvAddFriend.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(ctx));
        this.mListObserver = new Observer<List<SuggestFriendData>>(){

            public void onChanged(@Nullable List<SuggestFriendData> suggestFriendData) {
                if (suggestFriendData == null || suggestFriendData.isEmpty()) {
                    suggestFriendData = new ArrayList<SuggestFriendData>();
                }
                SuggestedFriendVerticalComponent.this.mSuggestFriendsList.clear();
                SuggestedFriendVerticalComponent.this.mSuggestFriendsList.addAll(suggestFriendData);
                if (SuggestedFriendVerticalComponent.this.friendVerticalAdapter == null) {
                    SuggestedFriendVerticalComponent.this.friendVerticalAdapter = new AddFriendVerticalAdapter(SuggestedFriendVerticalComponent.this.mSuggestFriendsList, inviteMoreFriendsClick);
                    rvAddFriend.setAdapter((RecyclerView.Adapter)SuggestedFriendVerticalComponent.this.friendVerticalAdapter);
                } else {
                    SuggestedFriendVerticalComponent.this.friendVerticalAdapter.notifyDataSetChanged();
                }
            }
        };
        this.mSuggestFriends.observeForever(this.mListObserver);
    }

    @Override
    public View getRoot() {
        return this.mRoot;
    }

    @Override
    public void onWindowAttach() {
    }

    @Override
    public void onWindowDetach() {
        if (this.mSuggestFriends != null) {
            this.mSuggestFriends.removeObserver(this.mListObserver);
        }
    }
}

