/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.component;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.FindFriend;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.im.base.SuggestFriendData;
import com.yy.hiyo.login.base.stat.ZaloStat;
import com.yy.im.R;
import com.yy.im.interfaces.IComponent;
import com.yy.im.ui.SuggestFriendsRecyclerView;
import com.yy.im.ui.adapter.SuggestFriendsAdapter;
import com.yy.im.viewmodel.ChatSessionViewModel;
import com.yy.im.viewmodel.SuggestedFriendViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;

public class SuggestedFriendComponent
implements IComponent {
    private static final String TAG = "SuggestedFriendComponent";
    private View mRoot;
    private YYImageView ivClose;
    private SuggestFriendsRecyclerView rvSuggestFriend;
    private MutableLiveData<List<SuggestFriendData>> mSuggestFriends;
    private Observer<List<SuggestFriendData>> mListObserver;
    private SuggestFriendsAdapter mSuggestFriendsAdapter;
    private List<SuggestFriendData> mSuggestFriendsList = new ArrayList<SuggestFriendData>();
    private SuggestedFriendViewModel mSuggestedFriendViewModel;
    private Runnable refreshSuggesFriendListRunnable = new Runnable(){

        @Override
        public void run() {
            if (null != SuggestedFriendComponent.this.mSuggestedFriendViewModel) {
                SuggestedFriendComponent.this.mSuggestedFriendViewModel.handleSuggestFriendList();
            }
        }
    };

    public SuggestedFriendComponent(final Context context, YYLinearLayout root2, final ChatSessionViewModel vm, SuggestedFriendViewModel suggestedFriendViewModel) {
        this.mRoot = LayoutInflater.from((Context)context).inflate(R.layout.im_view_suggest_friends, (ViewGroup)root2, false);
        this.mSuggestedFriendViewModel = suggestedFriendViewModel;
        this.mSuggestFriends = suggestedFriendViewModel.getSuggestedFriendDatas();
        this.mRoot.setVisibility(this.mSuggestFriends.getValue() == null || ((List)this.mSuggestFriends.getValue()).isEmpty() ? 8 : 0);
        this.ivClose = (YYImageView)this.mRoot.findViewById(R.id.iv_close);
        this.rvSuggestFriend = (SuggestFriendsRecyclerView)this.mRoot.findViewById(R.id.rv_suggest_friends);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context);
        linearLayoutManager.setOrientation(0);
        this.rvSuggestFriend.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.updateSuggestedFriendView(vm.getShowSuggestFriend().get());
        this.ivClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                vm.onClickSuggestArrow(v);
                SuggestedFriendComponent.this.updateSuggestedFriendView(vm.getShowSuggestFriend().get());
            }
        });
        this.mListObserver = new Observer<List<SuggestFriendData>>(){

            public void onChanged(@Nullable List<SuggestFriendData> searchFriends) {
                ChatSessionViewModel.SessionDataState sessionDataState;
                SuggestedFriendComponent.this.mSuggestFriendsList.clear();
                if (searchFriends != null) {
                    if (searchFriends.size() >= 10) {
                        SuggestedFriendComponent.this.mSuggestFriendsList.addAll(searchFriends.subList(0, 10));
                    } else {
                        SuggestedFriendComponent.this.mSuggestFriendsList.addAll(searchFriends);
                    }
                }
                MLog.info((Object)SuggestedFriendComponent.TAG, (String)"mSuggestFriendsList size:%s", (Object[])new Object[]{SuggestedFriendComponent.this.mSuggestFriendsList.size()});
                if (!SuggestedFriendComponent.this.mSuggestFriendsList.isEmpty() && null != (sessionDataState = (ChatSessionViewModel.SessionDataState)vm.getSessionDataState().getValue())) {
                    FindFriend findFriend = null;
                    findFriend = LanguageUtils.isVietnamese() || RuntimeContext.sIsDebuggable ? SuggestedFriendComponent.this.handleVietnam(sessionDataState) : SuggestedFriendComponent.this.handleNormal(sessionDataState);
                    if (null != findFriend) {
                        SuggestFriendData data3 = new SuggestFriendData(3);
                        data3.mFriend = findFriend;
                        SuggestedFriendComponent.this.mSuggestFriendsList.add(0, data3);
                    }
                }
                if (SuggestedFriendComponent.this.mSuggestFriendsAdapter == null) {
                    SuggestedFriendComponent.this.mSuggestFriendsAdapter = new SuggestFriendsAdapter(SuggestedFriendComponent.this.mSuggestFriendsList);
                    SuggestedFriendComponent.this.rvSuggestFriend.setAdapter(SuggestedFriendComponent.this.mSuggestFriendsAdapter);
                } else {
                    SuggestedFriendComponent.this.mSuggestFriendsAdapter.notifyDataSetChanged();
                }
                SuggestedFriendComponent.this.mSuggestFriendsAdapter.setOnItemClickListener((v, data2) -> {
                    FindFriend findFriend;
                    if (data2.type == 3 && null != (findFriend = data2.mFriend)) {
                        long type = findFriend.getType();
                        if (9L == type) {
                            vm.gotoBindZaloCallback(v, () -> SuggestedFriendComponent.this.refreshSuggesFriendListRunnable());
                            ZaloStat.statZaloBindGuideClick();
                        } else if (type == 0L) {
                            vm.goToBindFacebook(() -> SuggestedFriendComponent.this.refreshSuggesFriendListRunnable());
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "fb_guide_click"));
                        } else if (type == 1L) {
                            vm.goToBindContact(v, () -> {
                                ToastUtils.showToast((Context)context, (int)R.string.tips_im_bind_permission_success);
                                SuggestedFriendComponent.this.refreshSuggesFriendListRunnable();
                            });
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "contact_guide_click"));
                        }
                    }
                });
                SuggestedFriendComponent.this.mRoot.setVisibility(searchFriends == null || searchFriends.isEmpty() ? 8 : 0);
            }
        };
        this.mSuggestFriends.observeForever(this.mListObserver);
    }

    private void refreshSuggesFriendListRunnable() {
        YYTaskExecutor.postToMainThread((Runnable)this.refreshSuggesFriendListRunnable, (long)3000L);
    }

    private FindFriend handleVietnam(ChatSessionViewModel.SessionDataState sessionDataState) {
        FindFriend findFriend = null;
        MLog.info((Object)TAG, (String)("Zalo State = " + sessionDataState.mZaloState), (Object[])new Object[0]);
        if (AccountUtil.isShowZaloBind() && sessionDataState.mZaloState == ChatSessionViewModel.ZALO_UNAUTHORIZED) {
            findFriend = new FindFriend();
            findFriend.setType(9L);
            findFriend.setNick(ResourceUtils.getString((int)R.string.tips_im_suggest_virtural_zalo_friend));
            ZaloStat.statZaloBindGuideShow();
        } else if (sessionDataState.mContactState == 1) {
            findFriend = new FindFriend();
            findFriend.setType(1L);
            findFriend.setNick(ResourceUtils.getString((int)R.string.tips_im_suggest_virtural_contact_friend));
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "contact_guide_show"));
        }
        return findFriend;
    }

    private FindFriend handleNormal(ChatSessionViewModel.SessionDataState sessionDataState) {
        FindFriend findFriend = null;
        if (sessionDataState.mFbState == 2) {
            findFriend = new FindFriend();
            findFriend.setType(0L);
            findFriend.setNick(ResourceUtils.getString((int)R.string.tips_im_suggest_virtural_fb_friend));
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "fb_guide_show"));
        } else if (sessionDataState.mContactState == 1) {
            findFriend = new FindFriend();
            findFriend.setType(1L);
            findFriend.setNick(ResourceUtils.getString((int)R.string.tips_im_suggest_virtural_contact_friend));
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "contact_guide_show"));
        }
        return findFriend;
    }

    @Override
    public View getRoot() {
        return this.mRoot;
    }

    private void updateSuggestedFriendView(boolean showSuggestedFriends) {
        this.ivClose.setImageResource(showSuggestedFriends ? R.drawable.icon_arrow_up : R.drawable.icon_arrow_down);
        this.rvSuggestFriend.setVisibility(showSuggestedFriends ? 0 : 8);
    }

    @Override
    public void onWindowAttach() {
    }

    @Override
    public void onWindowDetach() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.refreshSuggesFriendListRunnable);
    }
}

