/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.widget.GameLabelView;
import com.yy.im.R;
import com.yy.im.interfaces.IGameInviteListener;
import com.yy.im.ui.widget.ClickAndScaleButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class GameCardAdapter
extends PagerAdapter {
    private static final String TAG = "GameCardAdapter";
    private Context mContext;
    private IGameInviteListener mGameInviteListener;
    private ArrayList<GameInfo> mGameInfoList;
    private LinkedList<View> mDestroyViewList;
    private ArrayList<View> mShownViewList;
    private HashMap<String, Boolean> mDownloadingMap;
    private HashMap<String, Boolean> mSendGameInviteMap;
    private int count = 0;

    public GameCardAdapter(Context ctx) {
        this.mContext = ctx;
        this.mDestroyViewList = new LinkedList();
        this.mGameInfoList = new ArrayList();
        this.mShownViewList = new ArrayList();
        this.mDownloadingMap = new HashMap();
        this.mSendGameInviteMap = new HashMap();
    }

    public void setDatas(List<GameInfo> datas) {
        if (datas != null && datas.size() > 0) {
            MLog.info((Object)TAG, (String)"game card notify data change", (Object[])new Object[0]);
            this.mGameInfoList.clear();
            this.mGameInfoList.addAll(datas);
            this.notifyDataSetChanged();
        }
    }

    public void setGameInviteListener(IGameInviteListener gameInviteListener2) {
        this.mGameInviteListener = gameInviteListener2;
    }

    public int getStartPageIndex(String gameId) {
        int index = 400;
        int remainder = index % (this.mGameInfoList.size() > 0 ? this.mGameInfoList.size() : 1);
        index -= remainder;
        for (int i = 0; i < this.mGameInfoList.size(); ++i) {
            if (TextUtils.isEmpty((CharSequence)this.mGameInfoList.get(i).getGid()) || !this.mGameInfoList.get(i).getGid().equals(gameId)) continue;
            index += i;
            break;
        }
        return index;
    }

    public String getGameIdByPosition(int position) {
        int index;
        if (this.mGameInfoList.size() > 0 && (index = position % this.mGameInfoList.size()) < this.mGameInfoList.size()) {
            GameInfo gameInfo = this.mGameInfoList.get(index);
            return gameInfo.getGid();
        }
        return null;
    }

    public int getCount() {
        return this.mGameInfoList == null || this.mGameInfoList.size() == 0 ? 0 : Math.max(this.mGameInfoList.size(), 1000);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public int getItemPosition(@NonNull Object object) {
        if (this.count > 0) {
            --this.count;
            return -2;
        }
        return super.getItemPosition(object);
    }

    public void notifyDataSetChanged() {
        if (this.mGameInfoList != null) {
            this.count = this.mGameInfoList.size();
        }
        super.notifyDataSetChanged();
    }

    public Object instantiateItem(ViewGroup container2, int position) {
        int index;
        ViewHolder viewHolder;
        View layout2;
        View view = layout2 = this.mDestroyViewList.size() > 0 ? this.mDestroyViewList.removeFirst() : null;
        if (layout2 == null) {
            layout2 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.im_game_card_item, container2, false);
            viewHolder = new ViewHolder(layout2);
            layout2.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)layout2.getTag();
        }
        container2.addView(layout2, 0);
        this.mShownViewList.add(layout2);
        if (this.mGameInfoList.size() > 0 && (index = position % this.mGameInfoList.size()) < this.mGameInfoList.size()) {
            GameInfo gameInfo = this.mGameInfoList.get(index);
            MLog.info((Object)TAG, (String)("game info:" + gameInfo.getGname() + " " + gameInfo.isFixing() + " " + gameInfo.isFull() + " " + gameInfo.isBetaTest() + " " + gameInfo.isWaitingOffline()), (Object[])new Object[0]);
            this.updateItemData(viewHolder, gameInfo);
        }
        return layout2;
    }

    private void updateItemData(ViewHolder viewHolder, GameInfo gameInfo) {
        viewHolder.setGameInfo(gameInfo);
        ImageLoader.loadBitmap((ImageView)viewHolder.mGameCoverIv, (String)gameInfo.getImIconUrl(), (int)R.drawable.shape_game_default_cover);
        viewHolder.mTitleTv.setText((CharSequence)gameInfo.getGname());
        viewHolder.setState(gameInfo, this.isDownloading(gameInfo.getGid()));
        viewHolder.setSendingInvite(gameInfo, this.isSendingInvite(gameInfo.getGid()));
        viewHolder.mGameLabelView.setGameLabel(gameInfo.getGameLabel());
    }

    public void setPrimaryItem(@NonNull ViewGroup container2, int position, @NonNull Object object) {
        super.setPrimaryItem(container2, position, object);
    }

    public void destroyItem(@NonNull ViewGroup container2, int position, @NonNull Object object) {
        container2.removeView((View)object);
        this.mDestroyViewList.add((View)object);
        this.mShownViewList.remove((View)object);
    }

    public void update(GameInfo gameInfo) {
        String gameId;
        String string2 = gameId = gameInfo != null ? gameInfo.getGid() : null;
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameId)) {
            return;
        }
        if (this.mShownViewList != null && !this.mShownViewList.isEmpty()) {
            for (View view : this.mShownViewList) {
                if (view == null || !(view.getTag() instanceof ViewHolder)) continue;
                ViewHolder vh = (ViewHolder)view.getTag();
                if (gameInfo == null || !gameId.equals(gameInfo.getGid())) continue;
                this.updateItemData(vh, gameInfo);
                break;
            }
        }
    }

    public void startDownloadGame(GameInfo gameInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid())) {
            return;
        }
        int index = this.getGameInfo(gameInfo.getGid());
        if (index == -1) {
            return;
        }
        this.mDownloadingMap.put(gameInfo.getGid(), true);
        this.initCurrGameCard((BasicGameInfo)gameInfo, true);
    }

    public void gameDownloadFailed(BasicGameInfo gameInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid())) {
            return;
        }
        int index = this.getGameInfo(gameInfo.getGid());
        if (index == -1) {
            return;
        }
        this.mDownloadingMap.put(gameInfo.getGid(), false);
        this.initCurrGameCard(gameInfo, false);
    }

    public void gameDownloadSucceed(GameInfo gameInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid())) {
            return;
        }
        int index = this.getGameInfo(gameInfo.getGid());
        if (index == -1) {
            return;
        }
        this.mDownloadingMap.put(gameInfo.getGid(), false);
        this.initCurrGameCard((BasicGameInfo)gameInfo, false);
    }

    public void setSendingInviteState(String gameId, boolean sendingInvite) {
        if (StringUtils.isEmpty((String)gameId)) {
            return;
        }
        int index = this.getGameInfo(gameId);
        if (index == -1) {
            return;
        }
        this.mSendGameInviteMap.put(gameId, sendingInvite);
        this.setGameCardSendInviteState(gameId, sendingInvite);
    }

    private void setGameCardSendInviteState(String gameId, boolean sendingInvite) {
        for (int i = 0; i < this.mShownViewList.size(); ++i) {
            View view = this.mShownViewList.get(i);
            ViewHolder viewHolder = (ViewHolder)view.getTag();
            if (viewHolder == null || viewHolder.mGameInfo == null || !gameId.equals(viewHolder.mGameInfo.getGid())) continue;
            viewHolder.setSendingInvite(viewHolder.mGameInfo, sendingInvite);
            break;
        }
    }

    private void initCurrGameCard(BasicGameInfo gameInfo, boolean downloading) {
        for (int i = 0; i < this.mShownViewList.size(); ++i) {
            View view = this.mShownViewList.get(i);
            ViewHolder viewHolder = (ViewHolder)view.getTag();
            if (viewHolder == null || viewHolder.mGameInfo == null || !gameInfo.isGameIdEquals(viewHolder.mGameInfo)) continue;
            viewHolder.setState(viewHolder.mGameInfo, downloading);
            break;
        }
    }

    private int getGameInfo(String gid) {
        int index = -1;
        for (int i = 0; i < this.mGameInfoList.size(); ++i) {
            if (TextUtils.isEmpty((CharSequence)this.mGameInfoList.get(i).getGid()) || !this.mGameInfoList.get(i).getGid().equals(gid)) continue;
            index = i;
            break;
        }
        return index;
    }

    private boolean isDownloading(String gid) {
        boolean ret = false;
        if (this.mDownloadingMap.containsKey(gid) && this.mDownloadingMap.get(gid).booleanValue()) {
            ret = true;
        }
        return ret;
    }

    private boolean isSendingInvite(String gid) {
        boolean ret = false;
        if (this.mSendGameInviteMap.containsKey(gid) && this.mSendGameInviteMap.get(gid).booleanValue()) {
            ret = true;
        }
        return ret;
    }

    class ViewHolder {
        RecycleImageView mGameCoverIv;
        ClickAndScaleButton mBtnPk;
        YYTextView mTitleTv;
        ProgressBar mProgressBar;
        GameLabelView mGameLabelView;
        GameInfo mGameInfo;

        public void setGameInfo(GameInfo gameInfo) {
            this.mGameInfo = gameInfo;
        }

        ViewHolder(View convertView) {
            this.mGameCoverIv = (RecycleImageView)convertView.findViewById(R.id.game_cover_iv);
            this.mBtnPk = (ClickAndScaleButton)convertView.findViewById(R.id.btn_pk);
            this.mTitleTv = (YYTextView)convertView.findViewById(R.id.game_title_tv);
            this.mProgressBar = (ProgressBar)convertView.findViewById(R.id.loading_pb);
            this.mProgressBar.setIndeterminateDrawable(ResourceUtils.getDrawable((int)R.drawable.im_send_game_invite_loading_pb));
            Typeface typeface = FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi);
            this.mGameLabelView = (GameLabelView)convertView.findViewById(R.id.game_label);
            this.mTitleTv.setTypeface(typeface);
            this.mBtnPk.setTypeface(typeface);
            this.mBtnPk.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ViewHolder.this.mGameInfo == null) {
                        return;
                    }
                    MLog.info((Object)GameCardAdapter.TAG, (String)"on pk click! gameId=%s", (Object[])new Object[]{ViewHolder.this.mGameInfo.getGid()});
                    if (ViewHolder.this.mGameInfo.isBetaTest()) {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_beta_test_game), (int)1);
                    } else {
                        if (ViewHolder.this.mGameInfo.isFull()) {
                            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)1);
                            return;
                        }
                        if (ViewHolder.this.mGameInfo.isFixing()) {
                            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)1);
                            return;
                        }
                    }
                    if (GameCardAdapter.this.isDownloading(ViewHolder.this.mGameInfo.getGid())) {
                        return;
                    }
                    if (GameCardAdapter.this.isSendingInvite(ViewHolder.this.mGameInfo.getGid())) {
                        return;
                    }
                    ViewHolder.this.mBtnPk.setEnabled(false);
                    ViewHolder.this.mBtnPk.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ViewHolder.this.mBtnPk.setEnabled(true);
                        }
                    }, 1000L);
                    if (GameCardAdapter.this.mGameInviteListener != null) {
                        GameCardAdapter.this.mGameInviteListener.sendInvite(ViewHolder.this.mGameInfo, -1, -1, -1);
                    }
                }
            });
        }

        public void setState(GameInfo gameInfo, boolean downloading) {
            if (gameInfo.isBetaTest()) {
                int res = R.string.game_card_play;
                this.mBtnPk.setText(downloading ? R.string.im_download : res);
                this.mBtnPk.setDownloading(downloading);
            } else if (gameInfo.isFull()) {
                this.mBtnPk.setText(R.string.btn_full);
                this.mBtnPk.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.selector_game_card_mentaining_btn_bg));
            } else if (gameInfo.isFixing()) {
                this.mBtnPk.setText(R.string.maintaining);
                this.mBtnPk.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.selector_game_card_mentaining_btn_bg));
            } else {
                int res = R.string.game_card_play;
                this.mBtnPk.setText(downloading ? R.string.im_download : res);
                this.mBtnPk.setDownloading(downloading);
            }
        }

        public void setSendingInvite(GameInfo info, boolean sendingInvite) {
            if (info.isBetaTest()) {
                int res = R.string.game_card_play;
                this.mBtnPk.setText(sendingInvite ? "" : ResourceUtils.getString((int)res));
                this.mBtnPk.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.selector_game_card_positive_btn_bg));
            } else if (info.isFull()) {
                this.mBtnPk.setText(R.string.btn_full);
                this.mBtnPk.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.selector_game_card_mentaining_btn_bg));
            } else if (info.isFixing()) {
                this.mBtnPk.setText(R.string.maintaining);
                this.mBtnPk.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.selector_game_card_mentaining_btn_bg));
            } else {
                int res = R.string.game_card_play;
                this.mBtnPk.setText(sendingInvite ? "" : ResourceUtils.getString((int)res));
                this.mBtnPk.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.selector_game_card_positive_btn_bg));
            }
            this.mProgressBar.setVisibility(sendingInvite ? 0 : 8);
        }
    }
}

