/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.SubAccountDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.game.service.IGameOfficialMsgService;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.im.ImEventReporter;
import com.yy.im.ImModuleData;
import com.yy.im.R;
import com.yy.im.hiido.OfficialDataReportManager;
import com.yy.im.model.ChatSession;
import com.yy.im.model.OfficialAccountChatSession;
import com.yy.im.model.OfficialAccountEntranceSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.oas.AosConfig;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.ImOasSessionBean;
import com.yy.im.session.bean.ImOasSessionBeanKt;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ihago.base.api.subaccount.SAType;

public class OfficialAccountSessionPresenter
extends BaseSessionPresenter {
    private static final String TAG = "OfficialAccountSessionPresenter";
    private SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(13, ImMessageDBBean.class, OfficialAccountChatSession.class);
    private Map<String, SubAccountDBBean> mSubAccountDBBeanMap = new ConcurrentHashMap<String, SubAccountDBBean>();

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_ENTER_OFFICIAL_ACCOUNT_SESSION, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_EXIT_OFFICIAL_ACCOUNT_SESSION, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_OFFICIAL_ACCOUNT_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (INotify)this);
        this.getSubAccountInfoDb();
    }

    @Override
    public void notify(Notification notification) {
        ChatSession session;
        if (notification.id == ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE) {
            List list;
            Object msgs = notification.extObj;
            if (msgs instanceof ImMessageDBBean) {
                this.onReceiveImMessage((ImMessageDBBean)msgs);
            } else if (msgs instanceof List && !(list = (List)msgs).isEmpty()) {
                for (ImMessageDBBean msg : list) {
                    this.onReceiveImMessage(msg);
                }
            }
        } else if (notification.id == ImNotificationDef.IM_ENTER_OFFICIAL_ACCOUNT_SESSION) {
            KvoSource moduleData = KvoModuleManager.getModuleData(ImModule.class);
            if (moduleData instanceof ImModuleData) {
                ((ImModuleData)moduleData).mOfficialAccountSessionUnread.setSuperUnread(false);
            }
        } else if (notification.id == ImNotificationDef.IM_EXIT_OFFICIAL_ACCOUNT_SESSION) {
            ChatSession session2 = this.getTargetSession("-8");
            if (session2 instanceof OfficialAccountEntranceSession) {
                KvoSource moduleData = KvoModuleManager.getModuleData(ImModule.class);
                if (moduleData instanceof ImModuleData) {
                    session2.setUnReadCounts(((ImModuleData)moduleData).mOfficialAccountSessionUnread.getCount());
                }
                this.mISessionCallback.updateNormalSession(session2);
            }
        } else if (notification.id == ImNotificationDef.IM_RECEIVE_OFFICIAL_ACCOUNT_MSG) {
            ImMessageDBBean msgDb = ImOasSessionBeanKt.transOasToMsgDb((ImOasSessionBean)notification.extObj);
            this.onReceiveImMessage(msgDb);
        } else if (notification.id == ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD && (session = this.getTargetSession("-6")) != null) {
            session.setUnReadCounts(0);
        }
    }

    private void onReceiveImMessage(ImMessageDBBean msg) {
        if (this.messageFilter(msg)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)msg.getSessionId())) {
            return;
        }
        ImMessageDBBean copy = ImMessageDBBean.copy((ImMessageDBBean)msg);
        String said = copy.getReserve1();
        int type = copy.getReserveInt1();
        OfficialDataReportManager.INSTANCE.reportMsgUp(type == 3 ? said : copy.getReserve5(), copy.getExtra(), String.valueOf(copy.getReserveInt1()), this.mISessionCallback.isShowOfficialAccountEntrance(), 0);
        if (this.mSubAccountDBBeanMap.containsKey(said)) {
            SubAccountDBBean cacheBean = this.mSubAccountDBBeanMap.get(said);
            if (cacheBean != null) {
                MLog.info((Object)TAG, (String)"from cache %s", (Object[])new Object[]{cacheBean.name});
                if (type != 3) {
                    copy.setReserve3(cacheBean.iconUrl);
                    copy.setReserve2(cacheBean.name);
                }
                this.updateChatSession(copy);
            }
        } else {
            this.getSubAccountInfoFromDb(said, subAccountDBBean -> {
                if (subAccountDBBean != null) {
                    MLog.info((Object)TAG, (String)"from db %s", (Object[])new Object[]{subAccountDBBean.name});
                    copy.setReserve2(subAccountDBBean.name);
                    copy.setReserve3(subAccountDBBean.iconUrl);
                    this.updateChatSession(copy);
                } else {
                    this.getSubAccountInfo(said, subAccountBean -> {
                        if (subAccountBean != null) {
                            MLog.info((Object)TAG, (String)"from network %s", (Object[])new Object[]{subAccountBean.name});
                            copy.setReserve2(subAccountBean.name);
                            copy.setReserve3(subAccountBean.iconUrl);
                            this.updateChatSession(copy);
                            this.mSubAccountDBBeanMap.put(said, SubAccountDBBean.copy((SubAccountDBBean)subAccountBean));
                        }
                        YYTaskExecutor.execute(() -> {
                            MyBox accountBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForGlobal(SubAccountDBBean.class);
                            if (accountBox != null) {
                                accountBox.addItem((BaseDBBean)subAccountBean);
                            }
                        });
                    });
                }
            });
        }
    }

    private boolean messageFilter(Object msg) {
        if (msg instanceof ImMessageDBBean) {
            ImMessageDBBean bean = (ImMessageDBBean)msg;
            return bean.getMsgType() != 45 || bean.getReserveInt1() != SAType.Activity.getValue() && bean.getReserveInt1() != SAType.GAME_ALL.getValue();
        }
        return true;
    }

    private void getSubAccountInfo(String id2, final IGetSubAccountCallback callback) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id2);
        ((IGameOfficialMsgService)ServiceManagerProxy.getServiceManager().getService(IGameOfficialMsgService.class)).batchGetSubAccountInfo(ids, (ICommonCallback)new ICommonCallback<List<SubAccountDBBean>>(){

            public void onSuccess(List<SubAccountDBBean> subAccountInfos, Object ... ext) {
                if (!FP.empty(subAccountInfos)) {
                    SubAccountDBBean subAccountDBBean = subAccountInfos.get(0);
                    if (callback != null) {
                        callback.onGetSubAccountInfo(subAccountDBBean);
                    }
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                MLog.info((Object)OfficialAccountSessionPresenter.TAG, (String)"onFail errCode=%s,msg=%s", (Object[])new Object[]{errCode, msg});
            }
        });
    }

    private void getSubAccountInfoFromDb(final String saId, final IGetSubAccountCallback callback) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                MyBox messageBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForCurUser(SubAccountDBBean.class);
                if (messageBox == null) {
                    return;
                }
                messageBox.getAll(datas -> {
                    SubAccountDBBean findBean = null;
                    for (SubAccountDBBean dbBean : datas) {
                        if (StringUtils.isEmpty((String)dbBean.subAccountId) || !dbBean.subAccountId.equals(saId)) continue;
                        findBean = SubAccountDBBean.copy((SubAccountDBBean)dbBean);
                        break;
                    }
                    SubAccountDBBean finalFindBean = findBean;
                    YYTaskExecutor.postToMainThread(() -> {
                        if (callback != null) {
                            callback.onGetSubAccountInfo(finalFindBean);
                        }
                    });
                });
            }
        };
        YYTaskExecutor.execute((Runnable)runnable2);
    }

    private void getSubAccountInfoDb() {
        Runnable runnable2 = () -> {
            MyBox messageBox = ((IDBService)ServiceManagerProxy.getServiceManager().getService(IDBService.class)).boxForGlobal(SubAccountDBBean.class);
            if (messageBox != null) {
                messageBox.getAll(datas -> {
                    for (SubAccountDBBean dbBean : datas) {
                        if (StringUtils.isEmpty((String)dbBean.subAccountId)) continue;
                        this.mSubAccountDBBeanMap.put(dbBean.subAccountId, SubAccountDBBean.copy((SubAccountDBBean)dbBean));
                    }
                });
            }
        };
        YYTaskExecutor.execute((Runnable)runnable2);
    }

    private void updateChatSession(ImMessageDBBean msgBean) {
        String sessionId2 = Utils.appendGameSessionId((String)msgBean.getSessionId(), (String)msgBean.getReserve1());
        ChatSession session = this.getTargetSession(sessionId2);
        boolean isSendByMe = msgBean.isSendByMe();
        if (session == null) {
            if (!isSendByMe) {
                session = new OfficialAccountChatSession(msgBean);
                this.mISessionCallback.updateOfficialAccountSession(session);
            }
        } else {
            session.update(msgBean);
            this.mISessionCallback.updateOfficialAccountSession(session);
        }
        ChatSessionEventReporter.INSTANCE.addReportMessageTimeArrived(session);
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
        OfficialAccountChatSession officialAccountChatSession = (OfficialAccountChatSession)chatSession;
        if (officialAccountChatSession != null && officialAccountChatSession.getLastMessage() != null) {
            int page2;
            ImMessageDBBean bean = (ImMessageDBBean)officialAccountChatSession.getLastMessage();
            if (bean == null || TextUtils.isEmpty((CharSequence)bean.getJumpUrl())) {
                return;
            }
            boolean entryPage = this.mISessionCallback.isShowGamePublicEntrance();
            int type = ((ImMessageDBBean)officialAccountChatSession.getLastMessage()).getReserveInt1();
            int n = page2 = entryPage ? 2 : 1;
            if (bean.getJumpType() == 2) {
                if (NAB.B.equals((Object)NewABDefine.GAME_OFFICIAL_IM_ROUTER.getTest()) && type == 3 && chatSession.getUnReadCounts() > 0) {
                    ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(bean.getJumpUrl());
                } else {
                    if (type == 3) {
                        bean.setReserve3("");
                        bean.setReserve2(ResourceUtils.getString((int)R.string.chat_session_game_all_name));
                    }
                    Message message = Message.obtain();
                    message.what = ImBaseMsgDef.MSG_OPEN_OFFICIAL_ACCOUNT_WINDOW;
                    AosConfig config = AosConfig.fromAction(bean);
                    if (config != null) {
                        message.obj = config;
                        MsgDispatcher.getInstance().sendMessage(message);
                    } else {
                        MLog.error((Object)TAG, (String)"config is null", (Object[])new Object[0]);
                    }
                }
            } else {
                ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(bean.getJumpUrl());
            }
            int satype = bean.getReserveInt1();
            String said = bean.getReserve1();
            if (satype == 3 && chatSession.getUnReadCounts() > 0) {
                page2 = 5;
                entryPage = false;
            }
            OfficialDataReportManager.INSTANCE.reportMsgClick(satype == 3 ? said : bean.getReserve5(), bean.getExtra(), String.valueOf(type), entryPage, page2, bean.getJumpType(), chatSession.getUnReadCounts());
            this.mISessionCallback.ignoreUnRead(chatSession.getSessionId());
        }
    }

    @Override
    public void handleLongClickItem(ChatSession chatSession, View v, int position, int from) {
        this.showDialogBottom(chatSession);
    }

    private void showDialogBottom(ChatSession session) {
        ArrayList<ButtonItem> buttonList = new ArrayList<ButtonItem>();
        ButtonItem deleteButton2 = this.getCommonDeleteBtnItem(() -> {
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "1");
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
            this.reportDeleteClick(session);
            this.deleteMsg(session);
        });
        ButtonItem ignoreButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.button_ignore_unread), () -> {
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "2");
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (Object)session.getSessionId()));
        });
        if (session instanceof SingleChatSession) {
            buttonList.add(deleteButton2);
            if (session.getUnReadCounts() > 0) {
                buttonList.add(ignoreButton2);
            }
        } else if (session instanceof OfficialAccountChatSession) {
            OfficialAccountChatSession officialAccountChatSession = (OfficialAccountChatSession)session;
            String subAccountId = ((ImMessageDBBean)officialAccountChatSession.getLastMessage()).getReserve1();
            int type = ((ImMessageDBBean)officialAccountChatSession.getLastMessage()).getReserveInt1();
            String gid = ((ImMessageDBBean)officialAccountChatSession.getLastMessage()).getReserve5();
            ButtonItem enterButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.btn_enter_activity), () -> {
                ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "8");
                session.setUnReadCounts(0);
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession(session.getSessionId());
                ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(((ImMessageDBBean)officialAccountChatSession.getLastMessage()).getJumpUrl());
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
                ImEventReporter.INSTANCE.reportEnterGameClick(gid);
            });
            ButtonItem unFollowButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.tips_short_unfollow), () -> {
                ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "7");
                ((IGameOfficialMsgService)ServiceManagerProxy.getServiceManager().getService(IGameOfficialMsgService.class)).unSubscribe(subAccountId, "", null);
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
                OfficialDataReportManager.INSTANCE.reportMsgBackClick(subAccountId, ((ImMessageDBBean)officialAccountChatSession.getLastMessage()).getExtra(), String.valueOf(type));
                ImEventReporter.INSTANCE.reportUnFollowClick(gid);
                this.deleteMsg(session);
            });
            ButtonItem feedbackButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.tips_short_qus_fb), () -> {
                SubAccountDBBean subAccountDBBean;
                ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "6");
                String feedbackContent = "";
                if (this.mSubAccountDBBeanMap.containsKey(subAccountId) && (subAccountDBBean = this.mSubAccountDBBeanMap.get(subAccountId)) != null) {
                    feedbackContent = this.mSubAccountDBBeanMap.get((Object)subAccountId).name;
                }
                Message message = new Message();
                Bundle bundle = new Bundle();
                bundle.putString("feedback_content", feedbackContent);
                message.what = MixBaseMsgDef.SHOW_WINDOW_FEEDBACK;
                message.arg1 = 5;
                message.arg2 = 11;
                message.setData(bundle);
                MsgDispatcher.getInstance().sendMessage(message);
                ImEventReporter.INSTANCE.reportFeedbackClick(gid);
            });
            ButtonItem msgNotifyButton2 = new ButtonItem(this.getGameMsgNotifySwitch(session), () -> {
                boolean notify2;
                if (session.getUnReadType() == 0) {
                    ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "4");
                    session.setUnReadType(1);
                    notify2 = false;
                } else {
                    ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "5");
                    session.setUnReadType(0);
                    notify2 = true;
                }
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession(session.getSessionId());
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateGamePublicSession((Object)session);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
                ((IGameOfficialMsgService)ServiceManagerProxy.getServiceManager().getService(IGameOfficialMsgService.class)).doNotDisturb(subAccountId, notify2);
                ImEventReporter.INSTANCE.reportTurnOffNotificationClick(gid);
            });
            if (type != SAType.GAME_ALL.getValue()) {
                buttonList.add(enterButton2);
            }
            buttonList.add(deleteButton2);
            buttonList.add(msgNotifyButton2);
            if (type != SAType.GAME_ALL.getValue()) {
                buttonList.add(feedbackButton2);
            }
            buttonList.add(unFollowButton2);
            ButtonItem stickTopButton = new ButtonItem(ResourceUtils.getString((int)(session.isStickTop() ? R.string.btn_msg_cancel_stick_top : R.string.btn_msg_stick_top)), () -> {
                boolean stickTop = !session.isStickTop();
                session.setStickTop(stickTop);
                session.setPresentationTime(System.currentTimeMillis());
                session.setPresentWeight(stickTop ? 5 : 0);
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession((Object)session);
                ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, session.isStickTop() ? "10" : "9");
            });
            buttonList.add(stickTopButton);
        } else if (session.getUnReadCounts() > 0) {
            buttonList.add(ignoreButton2);
        } else {
            return;
        }
        this.mDialogLinkManager.showCommonPopupDialog(DialogId.GamePublicSessonButtonDialog, buttonList, true, true);
    }

    private void reportDeleteClick(ChatSession session) {
        if (session instanceof OfficialAccountChatSession) {
            OfficialAccountChatSession chatSession = (OfficialAccountChatSession)session;
            String gid = ((ImMessageDBBean)chatSession.getLastMessage()).getReserve5();
            ImEventReporter.INSTANCE.reportDeleteClick(gid);
        }
    }

    private void deleteMsg(ChatSession session) {
        if (session.getLastMessage() instanceof ImMessageDBBean) {
            ImMessageDBBean imMessageDBBean = (ImMessageDBBean)session.getLastMessage();
            Message message = Message.obtain();
            message.what = ImBaseMsgDef.MSG_REMOVE_OFFICIAL_ACCOUNT_MSG;
            message.obj = imMessageDBBean.getReserve1();
            MsgDispatcher.getInstance().sendMessage(message);
        }
    }

    private String getGameMsgNotifySwitch(ChatSession session) {
        boolean isOpen = session.getUnReadType() == 0;
        return isOpen ? ResourceUtils.getString((int)R.string.tips_short_close_msg_notify) : ResourceUtils.getString((int)R.string.tips_short_open_msg_notify);
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    public long getUserUid(ChatSession temp) {
        return 0L;
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    static interface IGetSubAccountCallback {
        public void onGetSubAccountInfo(SubAccountDBBean var1);
    }
}

