/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import com.yy.im.parse.PostParseUtils;
import ikxd.msg.PushSourceType;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerPic
extends IImMsgParse {
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerPic(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        String content = null;
        String tinyGif = null;
        int emojiType = 0;
        int from = 0;
        try {
            JSONObject contentObj = JsonParser.obtainJSONObject((String)msgJson.optString("pic"));
            content = contentObj.optString("url");
            emojiType = contentObj.optInt("emoji_type", 0);
        }
        catch (JSONException e) {
            MLog.error((Object)this.TAG, (Throwable)e);
            return messageBuilder;
        }
        String imageSize = payloadJson.optString("image_size");
        from = payloadJson.optInt("from");
        tinyGif = payloadJson.optString("tinyGif");
        int fromType = payloadJson.optInt("form_type", 0);
        messageBuilder.content(content).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).meojiType(emojiType).contentType(2).reverse5(tinyGif).reverseInt1(from).fromType(fromType).uid(item.getFromUid()).reserve1(imageSize);
        if (msgJson != null && !FP.empty((CharSequence)msgJson.optString("post"))) {
            PostParseUtils.parsePost(messageBuilder, msgJson.optString("post"));
        }
        String pushSource = String.valueOf(PushSourceType.kPushSourceUserChat.getValue());
        if (StringUtils.isNotEmpty((String)item.getPushPayload())) {
            try {
                JSONObject pushPayload = JsonParser.obtainJSONObject((String)item.getPushPayload());
                if (StringUtils.isNotEmpty((String)pushPayload.optString("push_source"))) {
                    pushSource = pushPayload.optString("push_source");
                }
            }
            catch (JSONException e) {
                MLog.error((Object)this.TAG, (String)"parse push payload error", (Object[])new Object[0]);
            }
        }
        this.ctlCallback.showDefaultNotification(item, item.getPushContent(), "", pushSource);
        return messageBuilder;
    }
}

