/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.os.Message;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.data.oas.OfficialAccountsDb;
import com.yy.appbase.data.oas.OfficialAccountsMsgDb;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.hiido.OfficialDataReportManager;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import com.yy.im.session.bean.ImOasSessionBean;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerOfficialAccount
extends IImMsgParse {
    private static final String TAG = "MsgInnerOfficialAccount";
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerOfficialAccount(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        if (msgJson == null) {
            if (SystemUtils.isShowEnvSetting()) {
                throw new IllegalArgumentException("\u5b98\u65b9\u53f7\u4fe1\u606f\u89e3\u6790\u51fa\u9519" + item.getMsg());
            }
            return null;
        }
        String pushPayload = item.getPushPayload();
        JSONObject json = null;
        String pushSource = null;
        try {
            json = JsonParser.obtainJSONObject((String)pushPayload);
            pushSource = json.optString("push_source");
            if (json.has("display_front")) {
                boolean isShowForeground = json.optBoolean("display_front");
                this.ctlCallback.showNotification(item, pushSource, isShowForeground);
            } else {
                this.ctlCallback.showNotification(item, pushSource, false);
            }
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        JSONObject infoObject = msgJson.optJSONObject("info");
        if (infoObject != null) {
            OfficialAccountsDb db = OfficialAccountsDb.fromJson((JSONObject)infoObject);
            ImOasSessionBean bean = new ImOasSessionBean(item.getSessionId(), item.getSendTime(), item.getSeq(), item.getFromUid(), db);
            bean.setPushSource(pushSource);
            final Notification notification = Notification.obtain((int)ImNotificationDef.IM_RECEIVE_OFFICIAL_ACCOUNT_MSG, (Object)bean);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().notify(notification);
                }
            });
            if (db.getSaType() == 3 && NAB.B.equals((Object)NewABDefine.GAME_OFFICIAL_MESSAGE_TOAST.getTest())) {
                this.showToastView(bean);
            }
        }
        return null;
    }

    private void showToastView(final ImOasSessionBean bean) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (bean != null) {
                    Message msg = Message.obtain();
                    msg.what = ImBaseMsgDef.MSG_SHOW_GAME_OFFICIAL_TOAST_NOTIFY;
                    msg.obj = bean;
                    MsgDispatcher.getInstance().sendMessage(msg);
                    if (bean.getOasDb() != null && !FP.empty((Collection)bean.getOasDb().getMsgs())) {
                        OfficialAccountsDb db = bean.getOasDb();
                        OfficialAccountsMsgDb msgDb = (OfficialAccountsMsgDb)db.getMsgs().get(0);
                        OfficialDataReportManager.INSTANCE.reportMsgShow(db.getSaid(), msgDb.getMsgId(), "3", false, 4, 1, 0);
                    }
                }
            }
        });
    }
}

