/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.os.Bundle;
import android.os.Message;
import android.text.Spannable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ChatSessionDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.notify.NotifyPushToastInfo;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.MarginInfo;
import com.yy.appbase.span.TextSpan;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.LoadGiftResult;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.im.R;
import com.yy.im.model.ChatSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import com.yy.im.session.ImModuleImplV1;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class MsgInnerImGift
extends IImMsgParse {
    private static final int GIFT_ICON_SIZE = ResolutionUtils.dip2Px((float)25.0f);
    private IMsgParseCtlCallback ctlCallback;
    private String nickname;
    private String headUrl;
    private CharSequence pushContent;
    private ConcurrentHashMap<Integer, Long> pendingGiftInfo;

    public MsgInnerImGift(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)this.TAG, (String)"MsgInnerImGift item: %s", (Object[])new Object[]{item});
        }
        if (!GiftUtils.canShowImGift()) {
            MLog.info((Object)this.TAG, (String)"MsgInnerImGift boss config switch is close", (Object[])new Object[0]);
            return null;
        }
        final GiftBroResult result = ((IGiftService)this.ctlCallback.getServiceManager().getService(IGiftService.class)).parseGiftBroMsg(item.getMsg());
        if (result == null) {
            MLog.error((Object)this.TAG, (String)"parseMsg parse gift bro result is null", (Object[])new Object[0]);
            return null;
        }
        long fromUid = item.getFromUid();
        long toUid = result.getGiftBroInfo().getRecvUid();
        long amount = result.getGiftAmount();
        if (amount >= 100L && fromUid != AccountUtil.getUid() && ((ImService)this.ctlCallback.getServiceManager().getService(ImService.class)).getCurrChatUid() != fromUid) {
            this.showFloatNotify(result, fromUid);
        }
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        long sendTime = item.getSendTime();
        messageBuilder.sendTime(sendTime).clientSendTime(sendTime).content(item.getMsg()).msgId(StringUtils.parseLong((String)item.getSeq())).extObj((Object)result).msgType(27).contentType(11).status(0).uid(fromUid).toUserId(toUid).toUserName(result.getGiftBroInfo().getRecvNickname()).reserve1(this.giftIconUrl(result)).reserve2(String.valueOf(result.getGiftBroInfo().getPropsCount())).read(false);
        if (result.getGiftInfo() == null) {
            MLog.error((Object)this.TAG, (String)"parseMsg parse  gift info in result is null", (Object[])new Object[0]);
            if (this.pendingGiftInfo == null) {
                this.pendingGiftInfo = new ConcurrentHashMap();
            }
            this.pendingGiftInfo.put(result.getGiftBroInfo().getPropsId(), sendTime);
            this.loadGiftList(result.getGiftBroInfo().getUsedChannel());
        }
        if (fromUid == AccountUtil.getUid()) {
            messageBuilder.sendByMe(true).read(true);
            messageBuilder.sessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)toUid));
            final ImMessageDBBean imMessage = messageBuilder.builder();
            this.addMessageToDb(imMessage);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ADD_NEW_MSG, (Object)imMessage));
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (Object)imMessage));
                    ((IGiftService)MsgInnerImGift.this.ctlCallback.getServiceManager().getService(IGiftService.class)).addGiftBro(result);
                }
            });
            return null;
        }
        messageBuilder.sessionId(item.getSessionId());
        return messageBuilder;
    }

    private String giftIconUrl(GiftBroResult result) {
        String giftLevelUrl = "";
        if (result != null && result.getExpand() != null) {
            giftLevelUrl = result.getGiftInfo().getGradeIcon(String.valueOf(result.getExpand().giftLevel));
        }
        if (result == null) {
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)giftLevelUrl)) {
            return giftLevelUrl;
        }
        if (result.getGiftInfo() != null) {
            return result.getGiftInfo().getStaticIcon();
        }
        if (result.getExpand() != null) {
            return result.getExpand().staticIcon;
        }
        return "";
    }

    private void showFloatNotify(GiftBroResult result, final long fromUid) {
        this.nickname = null;
        this.pushContent = null;
        this.buildContent(result, fromUid);
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(fromUid, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (FP.empty(userInfoKSList)) {
                    return;
                }
                UserInfoKS userInfo = userInfoKSList.get(0);
                if (userInfo == null) {
                    return;
                }
                MsgInnerImGift.this.headUrl = userInfo.avatar;
                MsgInnerImGift.this.nickname = userInfo.nick;
                if (!TextUtils.isEmpty((CharSequence)MsgInnerImGift.this.pushContent)) {
                    MsgInnerImGift.this.showFloatNotify(fromUid, MsgInnerImGift.this.headUrl, MsgInnerImGift.this.nickname, MsgInnerImGift.this.pushContent);
                }
            }

            public void onFail(int id2, String msg, String response) {
            }

            public int id() {
                return 0;
            }
        });
    }

    private void showFloatNotify(long fromUid, String headUrl, String nickname, CharSequence content) {
        Message pushMsg = Message.obtain();
        pushMsg.what = BaseMsgDef.MSG_SHOW_NOTIFY_TOAST;
        NotifyPushToastInfo info = new NotifyPushToastInfo();
        info.addShieldWindow(new int[]{101, 105, 109, 115, 103, 102});
        info.setJumpType(2);
        info.setPushType(2);
        info.setTargetUid(fromUid);
        info.setImgUrl(headUrl);
        info.setPushTittle(nickname);
        info.setPushContent(content);
        info.setButtonText(ResourceUtils.getString((int)R.string.btn_im_send_gift_float_btn_text));
        info.setExtraString1("im_gift");
        Bundle bundle = new Bundle();
        bundle.putSerializable("base_toast_info_type", (Serializable)info);
        pushMsg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(pushMsg);
        this.pushContent = null;
        this.nickname = null;
    }

    private void buildContent(GiftBroResult result, final long fromUid) {
        String iconUrl = this.giftIconUrl(result);
        int count = result.getGiftBroInfo().getPropsCount();
        ChainSpan.of().append((CharSequence)ResourceUtils.getString((int)R.string.summary_im_send_gift, (Object[])new Object[]{String.valueOf(count)}), new Object[]{TextSpan.of().size(13).color(-16777216).build()}).replaceImage("[gift]", iconUrl + YYImageUtils.getThumbnailPostfix((int)75), GIFT_ICON_SIZE, GIFT_ICON_SIZE, R.drawable.im_user_avatar_place_holder, MarginInfo.of()).onFinish((Callback)new Callback<Spannable>(){

            public void onResponse(Spannable data2) {
                MsgInnerImGift.this.pushContent = (CharSequence)data2;
                if (!TextUtils.isEmpty((CharSequence)MsgInnerImGift.this.nickname)) {
                    MsgInnerImGift.this.showFloatNotify(fromUid, MsgInnerImGift.this.headUrl, MsgInnerImGift.this.nickname, MsgInnerImGift.this.pushContent);
                }
            }
        }).build();
    }

    private void addMessageToDb(ImMessageDBBean message) {
        MyBox messageMyBox2 = ((IDBService)this.ctlCallback.getServiceManager().getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class);
        if (messageMyBox2 != null) {
            messageMyBox2.updateItem((BaseDBBean)message, true);
        }
    }

    private void loadGiftList(int channelId) {
        if (this.ctlCallback.getServiceManager().getService(IGiftService.class) == null) {
            return;
        }
        ((IGiftService)this.ctlCallback.getServiceManager().getService(IGiftService.class)).loadGiftList("", AccountUtil.getUid(), channelId, false, (IGiftCallback)new IGiftCallback<LoadGiftResult>(){

            public void onSucceed(LoadGiftResult result) {
                MsgInnerImGift.this.findGiftInfo(result.getGiftList());
            }

            public void onFailed(int code, String msg) {
            }
        });
    }

    private void findGiftInfo(List<GiftItemInfo> result) {
        if (FP.empty(this.pendingGiftInfo) || FP.empty(result)) {
            return;
        }
        for (GiftItemInfo info : result) {
            Long sendTime = this.pendingGiftInfo.remove(info.getPropsId());
            if (sendTime == null || sendTime <= 0L) continue;
            this.updateMsgGiftInfo(sendTime, info);
        }
    }

    private void updateMsgGiftInfo(long sendTime, final GiftItemInfo info) {
        if (this.ctlCallback.getServiceManager().getService(IDBService.class) == null) {
            return;
        }
        MyBox messageMyBox2 = ((IDBService)this.ctlCallback.getServiceManager().getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class);
        if (messageMyBox2 != null) {
            messageMyBox2.getItemByIndex((Object)sendTime, (MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<ImMessageDBBean>(){

                public void onLoaded(ArrayList<ImMessageDBBean> datas) {
                    if (FP.empty(datas)) {
                        return;
                    }
                    ImMessageDBBean dbBean = datas.get(0);
                    if (dbBean == null) {
                        return;
                    }
                    if (dbBean.getExtObj() instanceof GiftBroResult) {
                        ((GiftBroResult)dbBean.getExtObj()).setGiftInfo(info);
                    }
                    dbBean.setReserve1(info.getStaticIcon());
                    MsgInnerImGift.this.addMessageToDb(dbBean);
                    MsgInnerImGift.this.updateSession(dbBean);
                }
            });
        }
    }

    private void updateSession(final ImMessageDBBean msg) {
        if (msg == null || this.ctlCallback.getServiceManager().getService(IDBService.class) == null) {
            return;
        }
        final MyBox box2 = ((IDBService)this.ctlCallback.getServiceManager().getService(IDBService.class)).boxForCurUser(ChatSessionDBBean.class);
        if (box2 != null) {
            box2.getItemByIndex((Object)msg.getSessionId(), (MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<ChatSessionDBBean>(){

                public void onLoaded(ArrayList<ChatSessionDBBean> datas) {
                    if (datas != null && datas.size() > 0) {
                        final ChatSessionDBBean chatSessionDBBean = datas.get(0);
                        if (chatSessionDBBean.getTimestamp() != msg.getSendTime()) {
                            return;
                        }
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                String lastMsg = "";
                                try {
                                    lastMsg = JsonParser.toJson((Object)msg);
                                }
                                catch (Exception e) {
                                    MLog.error((Object)MsgInnerImGift.this.TAG, (String)"updateNormalSession", (Throwable)e, (Object[])new Object[0]);
                                }
                                chatSessionDBBean.setLastMsg(lastMsg);
                                box2.updateItem((BaseDBBean)chatSessionDBBean, false);
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        MsgInnerImGift.this.updateSessionUi(msg.getSessionId(), msg.getReserve1(), StringUtils.safeParseInt((String)msg.getReserve2()));
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
    }

    private void updateSessionUi(String sessionId2, String iconUrl, int count) {
        ChatSession<Object> session;
        ImModule module = (ImModule)KvoModuleManager.getModule(ImModule.class);
        if (module instanceof ImModuleImplV1 && (session = ((ImModuleImplV1)module).getTargetSession(sessionId2)) instanceof SingleChatSession) {
            ((SingleChatSession)session).bindGiftMsg(iconUrl, count);
        }
    }
}

