/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.os.Message;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.service.IDBService;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.msg.ImModuleMsgDef;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONObject;

public class MsgImOnline
extends IImMsgParse {
    private IMsgParseCtlCallback ctlCallback;

    public MsgImOnline(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(final MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        final boolean isExit = payloadJson.optBoolean("isExit");
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Message pushMsg = Message.obtain();
                pushMsg.what = ImModuleMsgDef.IM_ONLINE_MSG;
                pushMsg.obj = item.getFromUid();
                pushMsg.arg1 = isExit ? 1 : 0;
                MsgDispatcher.getInstance().sendMessageSync(pushMsg);
                MsgImOnline.this.saveOnlineMsg(item.getFromUid(), isExit);
            }
        });
        return null;
    }

    private void saveOnlineMsg(long targetUid, boolean isExit) {
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        long currentTime = System.currentTimeMillis();
        final ImMessageDBBean imMessageDBBean = messageBuilder.content(isExit + "").clientSendTime(currentTime).sendTime(currentTime).sendByMe(false).sessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid)).contentType(10).uid(targetUid).msgType(6).builder();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                MyBox myBox = ((IDBService)MsgImOnline.this.ctlCallback.getServiceManager().getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class);
                if (myBox != null) {
                    myBox.addItem((BaseDBBean)imMessageDBBean);
                }
            }
        });
    }
}

