/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.refactor.viewmodel;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.bbs.base.service.IPostService;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.data.IIMdata;
import com.yy.hiyo.im.base.data.ImMsgScreenData;
import com.yy.hiyo.im.base.data.ListDataState;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.im.chatim.IMContext;
import com.yy.im.chatim.IMViewModel;
import com.yy.im.model.ChatMessageData;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import common.Page;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import net.ihago.bbs.srv.mgr.GetUserPostInfoRes;
import net.ihago.room.srv.follow.GetRelationReq;
import net.ihago.room.srv.follow.GetRelationRes;
import net.ihago.room.srv.follow.Relation;

public class UserProfileUpdateVM
extends IMViewModel
implements INotify {
    private static final String TAG = "UserProfileUpdateVM";
    private static final long EDIT_INTERVAL = SystemUtils.isShowEnvSetting() ? 15000L : 259200000L;
    private static final long CLOSE_INTERVAL = SystemUtils.isShowEnvSetting() ? 30000L : 604800000L;

    public void onInit(@NonNull IMContext mvpContext) {
        super.onInit((IMvpContext)mvpContext);
        IAB iab = NewABDefine.BBS_IM_PROFILE_INTRO.getTest();
        MLog.info((Object)TAG, (String)("ab: " + iab), (Object[])new Object[0]);
        if (NAB.B.equals((Object)iab)) {
            NotificationCenter.getGlobalInstance().register(NotificationIdDef.N_IMMSG_LIST_CHANGE, (INotify)this);
        }
    }

    public void notify(Notification notification) {
        Pair pair = (Pair)notification.extObj;
        List imList = (List)pair.getSecond();
        ListDataState state2 = (ListDataState)pair.getFirst();
        MLog.info((Object)TAG, (String)("notify state: " + state2 + ", list: " + (FP.empty((Collection)imList) ? 0 : imList.size())), (Object[])new Object[0]);
        if (FP.empty((Collection)imList) || state2 != ListDataState.ADD && state2 != ListDataState.INSERT) {
            return;
        }
        boolean canShow = false;
        boolean hasMyMessage = false;
        for (int i = imList.size() - 1; i >= 0; --i) {
            IIMdata iiMdata = (IIMdata)imList.get(i);
            ImMessageDBBean imMessageDBBean = iiMdata.getMessageDBBean();
            if (imMessageDBBean == null) {
                MLog.error((Object)TAG, (String)"notify imMessageDBBean null", (Object[])new Object[0]);
                continue;
            }
            int msgType = imMessageDBBean.getMsgType();
            MLog.info((Object)TAG, (String)("notify msgType: " + msgType), (Object[])new Object[0]);
            if (msgType == 77) {
                canShow = false;
                break;
            }
            if (msgType != 0) continue;
            boolean sendByMe = imMessageDBBean.isSendByMe();
            MLog.info((Object)TAG, (String)("notify sendByMe: " + sendByMe), (Object[])new Object[0]);
            if (!sendByMe) {
                canShow = false;
                break;
            }
            if (!hasMyMessage) {
                hasMyMessage = true;
                canShow = true;
                continue;
            }
            canShow = false;
            break;
        }
        MLog.info((Object)TAG, (String)("notify canShow: " + canShow), (Object[])new Object[0]);
        if (canShow) {
            long editTime = SettingFlags.getLongValue((String)("avatar_edit_click_" + AccountUtil.getUid()), (long)0L);
            MLog.info((Object)TAG, (String)("notify editTime: " + editTime), (Object[])new Object[0]);
            if (System.currentTimeMillis() - editTime < EDIT_INTERVAL) {
                return;
            }
            long closeCount = SettingFlags.getLongValue((String)("avatar_edit_close_count_" + AccountUtil.getUid()), (long)0L);
            long closeTime = SettingFlags.getLongValue((String)("avatar_edit_close_time_" + AccountUtil.getUid()), (long)0L);
            boolean resetCloseCount = false;
            long current = System.currentTimeMillis();
            MLog.info((Object)TAG, (String)("notify closeCount: " + closeCount + ", closeTime: " + closeTime + ", current: " + current), (Object[])new Object[0]);
            if (closeCount >= 3L) {
                if (current - closeTime < CLOSE_INTERVAL) {
                    return;
                }
                resetCloseCount = true;
            }
            MLog.info((Object)TAG, (String)("notify resetCloseCount: " + resetCloseCount), (Object[])new Object[0]);
            this.requestRelation(resetCloseCount);
        }
    }

    private void requestRelation(final boolean resetCloseCount) {
        GetRelationReq getRelationReq = new GetRelationReq.Builder().uids(Collections.singletonList(this.getMTargetUid())).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getRelationReq, (IProtoCallback)new SimpleProtoCallback<GetRelationRes>(){

            public void onResponse(GetRelationRes res) {
                super.onResponse((AndroidMessage)res);
                if (res == null || FP.empty((Collection)res.relations)) {
                    return;
                }
                Relation relation = (Relation)res.relations.get(0);
                MLog.info((Object)UserProfileUpdateVM.TAG, (String)("requestRelation relation: " + relation), (Object[])new Object[0]);
                if (relation.relation != 3) {
                    UserProfileUpdateVM.this.requestUserInfo(resetCloseCount);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)UserProfileUpdateVM.TAG, (String)("requestRelation error: " + reason + ", code: " + code), (Object[])new Object[0]);
            }
        });
    }

    private void requestUserInfo(final boolean resetCloseCount) {
        UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        MLog.info((Object)TAG, (String)("requestUserInfo avatar: " + userInfoKS.avatar), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)userInfoKS.avatar) || userInfoKS.avatar.contains("guest")) {
            this.sendMsg(1, resetCloseCount);
            return;
        }
        ((IPostService)ServiceManagerProxy.getService(IPostService.class)).getUserPostInfo(AccountUtil.getUid(), null, new Page.Builder().offset(Long.valueOf(0L)).limit(Long.valueOf(1L)).snap(Long.valueOf(0L)).build(), (ICommonCallback)new ICommonCallback<GetUserPostInfoRes>(){

            public void onSuccess(GetUserPostInfoRes getUserPostInfoRes, Object ... ext) {
                long total = getUserPostInfoRes.page.total;
                MLog.info((Object)UserProfileUpdateVM.TAG, (String)("requestUserInfo total: " + total), (Object[])new Object[0]);
                if (total <= 0L) {
                    UserProfileUpdateVM.this.sendMsg(2, resetCloseCount);
                } else {
                    UserProfileUpdateVM.this.requestImagePostsCount(resetCloseCount);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                MLog.error((Object)UserProfileUpdateVM.TAG, (String)("requestUserInfo error: " + msg + ", code: " + errCode), (Object[])new Object[0]);
            }
        });
    }

    private void requestImagePostsCount(boolean resetCloseCount) {
    }

    private void sendMsg(int type, boolean resetCloseCount) {
        if (resetCloseCount) {
            SettingFlags.setLongValue((String)("avatar_edit_close_count_" + AccountUtil.getUid()), (long)0L);
        }
        long msgSendTime = System.currentTimeMillis();
        ImMessageDBBean imMessageDBBean = new ImMessageDBBean();
        imMessageDBBean.setMsgType(77);
        imMessageDBBean.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)this.getMTargetUid()));
        imMessageDBBean.setUid(this.getMTargetUid());
        imMessageDBBean.setToUserId(AccountUtil.getUid());
        imMessageDBBean.setTag(String.valueOf(type));
        imMessageDBBean.setSource(((IMContext)this.getMvpContext()).mMsgBundle.getMScene());
        imMessageDBBean.setStatus(0);
        imMessageDBBean.setSendByMe(false);
        imMessageDBBean.setClientSendTime(msgSendTime);
        imMessageDBBean.setSendTime(msgSendTime);
        ChatMessageData chatMessageData = new ChatMessageData(imMessageDBBean);
        ((IMContext)this.getMvpContext()).getImMsgVm().addDBMsg(imMessageDBBean);
        ImMsgScreenData imMsgScreenData = new ImMsgScreenData(Collections.singletonList(chatMessageData), ListDataState.ADD);
        YYTaskExecutor.postToMainThread(() -> ((IMContext)this.getMvpContext()).getImMsgVm().notifyMsgListChange(imMsgScreenData));
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "profile_complete_show").put("profile_complete_type", String.valueOf(type)));
    }
}

