/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.im.IMPostData;
import com.yy.hiyo.im.view.IMPostView;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.voice.base.offlinevoice.IVoiceChatView;
import com.yy.hiyo.voice.base.offlinevoice.VoiceChatInfo;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.im.module.room.refactor.viewmodel.ImBottomVM;

public class VoiceChatSendHolder
extends ChatBaseHolder {
    private IVoiceChatView mVoiceChatView;
    private FrameLayout container;
    private YYTextView tvTime;
    private ChatMessageData msgData;
    private YYImageView ivError;
    private View loadingView;
    private YYPlaceHolderView mPostHolder;
    private IMPostView mIMPostView;

    public VoiceChatSendHolder(View itemView, IMvpContext mvpContext) {
        super(itemView, mvpContext);
        this.container = (FrameLayout)itemView.findViewById(R.id.voice_container);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.ivError = (YYImageView)itemView.findViewById(R.id.iv_error);
        this.loadingView = itemView.findViewById(R.id.loading_view);
        this.mPostHolder = (YYPlaceHolderView)itemView.findViewById(R.id.postHolder);
        if (itemView instanceof ViewGroup) {
            View view = ((ImBottomVM)mvpContext.getViewModel(ImBottomVM.class)).createVoiceView(true);
            this.container.addView(view);
            if (view instanceof IVoiceChatView) {
                this.mVoiceChatView = (IVoiceChatView)view;
            }
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (VoiceChatSendHolder.this.msgData != null && VoiceChatSendHolder.this.getEventCallback() != null) {
                        VoiceChatSendHolder.this.getEventCallback().onChatMessageItemLongClick(VoiceChatSendHolder.this.msgData, v);
                    }
                    return false;
                }
            });
        }
    }

    public static BaseItemBinder<ChatMessageData, VoiceChatSendHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, VoiceChatSendHolder>(){

            @NonNull
            protected VoiceChatSendHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new VoiceChatSendHolder(inflater.inflate(R.layout.layout_im_voice_chat_send, parent, false), context);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        this.msgData = data2;
        if (data2.message.getStatus() == 1) {
            this.ivError.setVisibility(0);
            this.loadingView.setVisibility(8);
        } else if (data2.message.getStatus() == 2) {
            this.loadingView.setVisibility(0);
            this.ivError.setVisibility(8);
        } else {
            this.loadingView.setVisibility(8);
            this.ivError.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)data2.message.getReserve1())) {
            VoiceChatInfo info = null;
            info = data2.message.getExtObj() instanceof VoiceChatInfo ? (VoiceChatInfo)data2.message.getExtObj() : new VoiceChatInfo(data2.message.getContent(), StringUtils.parseLong((String)data2.message.getReserve1()));
            info.setMyself(true);
            this.mVoiceChatView.bindVoiceInfo(info);
        }
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        if (!FP.empty((CharSequence)data2.message.getPostId())) {
            this.initPostView(data2.message);
        } else if (null != this.mIMPostView) {
            this.mIMPostView.setVisibility(8);
        }
    }

    private void initPostView(ImMessageDBBean bean) {
        if (null == this.mIMPostView) {
            this.mIMPostView = new IMPostView(this.getContext(), true);
            this.mPostHolder.inflate((View)this.mIMPostView);
        } else {
            this.mIMPostView.setVisibility(0);
        }
        this.mIMPostView.setOnPostEventListener(postId -> {
            if (this.getEventCallback() != null) {
                this.getEventCallback().jumpPostDetail(postId);
            }
        });
        IMPostData postData = new IMPostData();
        postData.setPostId(bean.getPostId());
        postData.setPostType(bean.getPostType());
        postData.setTime(Long.valueOf(bean.getPostTime()));
        postData.setContent(bean.getPostContent());
        postData.setImage(bean.getPostImage());
        this.mIMPostView.setData(postData);
    }
}

