/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.im.IMPostData;
import com.yy.hiyo.im.view.IMPostView;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.voice.base.offlinevoice.IVoiceChatView;
import com.yy.hiyo.voice.base.offlinevoice.VoiceChatInfo;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.im.module.room.refactor.viewmodel.ImBottomVM;

public class VoiceChatReceiveHolder
extends ChatBaseHolder {
    private IVoiceChatView mVoiceChatView;
    private FrameLayout container;
    private YYTextView tvTime;
    private HeadFrameImageView ivAvatar;
    private ChatMessageData msgData;
    private YYPlaceHolderView mPostHolder;
    private IMPostView mIMPostView;

    public VoiceChatReceiveHolder(View itemView, IMvpContext mvpContext) {
        super(itemView, mvpContext);
        this.container = (FrameLayout)itemView.findViewById(R.id.voice_container);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.ivAvatar = (HeadFrameImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.mPostHolder = (YYPlaceHolderView)itemView.findViewById(R.id.postHolder);
        if (itemView instanceof ViewGroup) {
            View view = ((ImBottomVM)mvpContext.getViewModel(ImBottomVM.class)).createVoiceView(false);
            this.container.addView(view);
            if (view instanceof IVoiceChatView) {
                this.mVoiceChatView = (IVoiceChatView)view;
            }
            view.setOnLongClickListener(v -> {
                if (this.msgData != null && this.getEventCallback() != null) {
                    this.getEventCallback().onChatMessageItemLongClick(this.msgData, v);
                    return true;
                }
                return false;
            });
        }
        this.ivAvatar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && VoiceChatReceiveHolder.this.getEventCallback() != null) {
                    VoiceChatReceiveHolder.this.getEventCallback().onUserAvatarClick(((ChatMessageData)v.getTag((int)R.id.chat_message_data)).message.getUid(), 8);
                }
            }
        });
    }

    public static BaseItemBinder<ChatMessageData, VoiceChatReceiveHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, VoiceChatReceiveHolder>(){

            @NonNull
            protected VoiceChatReceiveHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new VoiceChatReceiveHolder(inflater.inflate(R.layout.layout_im_voice_chat_recieve, parent, false), context);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        this.msgData = data2;
        if (!TextUtils.isEmpty((CharSequence)data2.message.getReserve1())) {
            VoiceChatInfo info = null;
            info = data2.message.getExtObj() instanceof VoiceChatInfo ? (VoiceChatInfo)data2.message.getExtObj() : new VoiceChatInfo(data2.message.getContent(), StringUtils.parseLong((String)data2.message.getReserve1()));
            info.setMyself(false);
            this.mVoiceChatView.bindVoiceInfo(info);
        }
        if (data2.message.getUid() == 10L || data2.message.getUid() == 14L) {
            this.ivAvatar.getCircleImageView().setImageResource(R.drawable.icon_public_msg_avatar);
        } else {
            this.showAvatar((RecycleImageView)this.ivAvatar.getCircleImageView(), this.getUserInfo(data2.message.getUid()));
        }
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        HeadFrameType otherHeadFrameType = this.getOtherHeadFrameType();
        if (otherHeadFrameType != null) {
            Kvo.addKvoBinding((KvoSource)otherHeadFrameType, (Object)((Object)this), (String)"onOtherHeadFrameTypeUpdate");
        }
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
        if (!FP.empty((CharSequence)data2.message.getPostId())) {
            this.initPostView(data2.message);
        } else if (null != this.mIMPostView) {
            this.mIMPostView.setVisibility(8);
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onOtherHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.ivAvatar != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame));
        }
    }

    private void initPostView(ImMessageDBBean bean) {
        if (null == this.mIMPostView) {
            this.mIMPostView = new IMPostView(this.getContext(), false);
            this.mPostHolder.inflate((View)this.mIMPostView);
        } else {
            this.mIMPostView.setVisibility(0);
        }
        this.mIMPostView.setOnPostEventListener(postId -> {
            if (this.getEventCallback() != null) {
                this.getEventCallback().jumpPostDetail(postId);
            }
        });
        IMPostData postData = new IMPostData();
        postData.setPostId(bean.getPostId());
        postData.setPostType(bean.getPostType());
        postData.setTime(Long.valueOf(bean.getPostTime()));
        postData.setContent(bean.getPostContent());
        postData.setImage(bean.getPostImage());
        this.mIMPostView.setData(postData);
    }
}

