/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.common.Callback;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.MarginInfo;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.appbase.util.RegexUtils;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.im.IMPostData;
import com.yy.hiyo.im.view.IMPostView;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.im.ImResourceManager;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.data.InteractiveEmojiTypeHelper;
import com.yy.im.module.room.holder.BaseImageMessageHolder;
import java.util.regex.Matcher;
import kotlin.Unit;

@DontProguardClass
public class ChatSentMessageHolder
extends BaseImageMessageHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private YYTextView tvTxtMsg;
    private YYTextView tvTime;
    private YYTextView tvViolatingTips;
    private RoundImageView ivImageMsg;
    private YYImageView ivError;
    private View loadingView;
    private ImageView ivImgLoading;
    private View contentView;
    private View ivLogo;
    private YYPlaceHolderView mPostHolder;
    private IMPostView mIMPostView;
    private static final String IMAGE_THUMBNAIL = YYImageUtils.getThumbnailPostfix((int)75);
    private static final int GIFT_ICON_SIZE = ResolutionUtils.dip2Px((float)25.0f);

    public ChatSentMessageHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.tvTxtMsg = (YYTextView)itemView.findViewById(R.id.tv_txt_msg);
        this.tvTxtMsg.setBackgroundResource(ImResourceManager.INSTANCE.getImSelfBackground());
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.ivImageMsg = (RoundImageView)itemView.findViewById(R.id.iv_image_msg);
        this.ivError = (YYImageView)itemView.findViewById(R.id.iv_error);
        this.loadingView = itemView.findViewById(R.id.loading_view);
        this.ivImgLoading = (ImageView)itemView.findViewById(R.id.iv_img_loading);
        this.contentView = itemView.findViewById(R.id.content);
        this.ivLogo = itemView.findViewById(R.id.iv_logo);
        this.mPostHolder = (YYPlaceHolderView)itemView.findViewById(R.id.postHolder);
    }

    public static BaseItemBinder<ChatMessageData, ChatSentMessageHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatSentMessageHolder>(){

            @NonNull
            protected ChatSentMessageHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatSentMessageHolder(inflater.inflate(R.layout.layout_item_im_chat_sent, parent, false), context);
            }
        };
    }

    public void setData(final ChatMessageData data2) {
        super.setData((Object)data2);
        this.contentView.setTag(R.id.chat_message_data, null);
        this.ivImageMsg.setTag(R.id.chat_message_data, null);
        this.contentView.setOnLongClickListener(null);
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        this.ivLogo.setVisibility(8);
        if (this.tvViolatingTips != null) {
            this.tvViolatingTips.setVisibility(8);
        }
        if (data2.message.getStatus() == 1) {
            this.ivError.setVisibility(0);
            this.loadingView.setVisibility(8);
        } else if (data2.message.getStatus() == 2) {
            this.loadingView.setVisibility(0);
            this.ivError.setVisibility(8);
        } else {
            this.loadingView.setVisibility(8);
            this.ivError.setVisibility(8);
            if (data2.message.getStatus() == 3 && !TextUtils.isEmpty((CharSequence)data2.message.getViolatingMsg())) {
                if (this.tvViolatingTips == null) {
                    this.tvViolatingTips = (YYTextView)this.itemView.findViewById(R.id.tv_violating_tips);
                }
                this.ivError.setVisibility(0);
                this.tvViolatingTips.setVisibility(0);
                this.tvViolatingTips.setText((CharSequence)data2.message.getViolatingMsg());
            }
        }
        if (null != this.mIMPostView) {
            this.mIMPostView.setVisibility(8);
        }
        switch (data2.message.getContentType()) {
            case 1: {
                if (data2.message.getMsgType() == 14) {
                    if (!TextUtils.isEmpty((CharSequence)data2.message.getReserve1())) {
                        int type = StringUtils.safeParseInt((String)data2.message.getReserve1());
                        this.tvTxtMsg.setText((CharSequence)InteractiveEmojiTypeHelper.getSpannableStringByType(type));
                    }
                } else {
                    SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)EmojiManager.INSTANCE.getExpressionString(data2.message.getContent()));
                    Matcher matcher = RegexUtils.INSTANCE.matchUrl((CharSequence)builder);
                    while (matcher.find()) {
                        String url = matcher.group();
                        int start = matcher.start();
                        int end = matcher.end();
                        builder.setSpan((Object)new ChainSpan.ClickSpan(() -> {
                            IServiceManager serviceManager = this.getServiceManager();
                            if (serviceManager != null) {
                                ((IWebService)serviceManager.getService(IWebService.class)).loadUrl(url, "");
                            }
                            return Unit.INSTANCE;
                        }, true, Color.parseColor((String)"#00A8FF")), start, end, 34);
                        MLog.info((Object)"ChatSentMessageHolder", (String)("url = " + url), (Object[])new Object[0]);
                    }
                    this.tvTxtMsg.setText((CharSequence)builder);
                    this.tvTxtMsg.setAutoLinkMask(0);
                    this.tvTxtMsg.setMovementMethod(LinkMovementMethod.getInstance());
                }
                this.tvTxtMsg.setVisibility(0);
                this.ivImageMsg.setVisibility(8);
                this.ivImgLoading.setVisibility(8);
                this.tvTxtMsg.setTag(R.id.chat_message_data, (Object)data2);
                this.tvTxtMsg.setOnLongClickListener((View.OnLongClickListener)this);
                if (FP.empty((CharSequence)data2.message.getPostId())) break;
                this.initPostView(data2.message);
                break;
            }
            case 2: {
                this.tvTxtMsg.setVisibility(8);
                this.ivImageMsg.setVisibility(0);
                this.ivImgLoading.setVisibility(8);
                this.ivImageMsg.setOnLongClickListener((View.OnLongClickListener)this);
                this.ivLogo.setVisibility(data2.message.getReserveInt1() == 1 ? 0 : 4);
                this.ivImageMsg.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ChatSentMessageHolder.this.getEventCallback() != null) {
                            ChatSentMessageHolder.this.getEventCallback().onImageClick(v, data2);
                        }
                    }
                });
                this.showImage(this.ivImgLoading, this.ivImageMsg, data2);
                if (FP.empty((CharSequence)data2.message.getPostId())) break;
                this.initPostView(data2.message);
                break;
            }
            case 11: {
                this.contentView.setTag(R.id.chat_message_data, (Object)data2);
                this.tvTxtMsg.setVisibility(0);
                this.ivImageMsg.setVisibility(8);
                this.ivImgLoading.setVisibility(8);
                this.contentView.setOnLongClickListener((View.OnLongClickListener)this);
                if (data2.message.getExtObj() instanceof GiftBroResult) {
                    GiftBroResult result = (GiftBroResult)data2.message.getExtObj();
                    this.bindGiftMsg(result.getGiftInfo() == null ? "" : result.getGiftInfo().getStaticIcon(), result.getGiftBroInfo().getPropsCount());
                    break;
                }
                this.bindGiftMsg(data2.message.getReserve1(), StringUtils.safeParseInt((String)data2.message.getReserve2()));
                break;
            }
        }
    }

    private void initPostView(ImMessageDBBean bean) {
        if (null == this.mIMPostView) {
            this.mIMPostView = new IMPostView(this.getContext(), true);
            this.mPostHolder.inflate((View)this.mIMPostView);
        } else {
            this.mIMPostView.setVisibility(0);
        }
        this.mIMPostView.setOnPostEventListener(postId -> {
            if (this.getEventCallback() != null) {
                this.getEventCallback().jumpPostDetail(postId);
            }
        });
        IMPostData postData = new IMPostData();
        postData.setPostId(bean.getPostId());
        postData.setPostType(bean.getPostType());
        postData.setTime(Long.valueOf(bean.getPostTime()));
        postData.setContent(bean.getPostContent());
        postData.setImage(bean.getPostImage());
        this.mIMPostView.setData(postData);
    }

    private void bindGiftMsg(String iconUrl, int count) {
        ChainSpan.of().append((CharSequence)ResourceUtils.getString((int)R.string.summary_im_send_gift, (Object[])new Object[]{String.valueOf(count)}), new Object[]{TextSpan.of().size(13).color(-16777216).build()}).replaceImage("[gift]", iconUrl + IMAGE_THUMBNAIL, GIFT_ICON_SIZE, GIFT_ICON_SIZE, R.drawable.icon_gift_box, MarginInfo.of()).onUpdate((Callback)new Callback<Spannable>(){

            public void onResponse(Spannable data2) {
                ChatSentMessageHolder.this.tvTxtMsg.setText((CharSequence)data2);
            }
        }).build();
    }

    public void onClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && this.getEventCallback() != null) {
            this.getEventCallback().onUserAvatarClick(((ChatMessageData)v.getTag((int)R.id.chat_message_data)).message.getUid(), 8);
        }
    }

    public boolean onLongClick(View v) {
        int id2 = v.getId();
        if ((id2 == R.id.content || id2 == R.id.iv_image_msg || id2 == R.id.tv_txt_msg) && v.getTag(R.id.chat_message_data) instanceof ChatMessageData) {
            if (this.getEventCallback() != null) {
                this.getEventCallback().onChatMessageItemLongClick((ChatMessageData)v.getTag(R.id.chat_message_data), v);
            }
            return true;
        }
        return false;
    }
}

