/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.app.Activity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.webservice.WebEnvSettings;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.text.SimpleDateFormat;

@DontProguardClass
public class ChatReportMessageHolder
extends ChatBaseHolder {
    private static final int BANNED_FOREVER = -1;
    private final View background;
    private YYTextView tvTime;
    private static final String TAG = "ChatReportMessageHolder";
    private YYTextView feedbackContent;
    private YYTextView feedbackType;
    private YYTextView feedbackPersionId;
    private YYTextView feedbackPersionName;
    private YYTextView feedbackCause;
    private YYTextView feedbackCauseContent;
    private YYTextView feedbackDate;
    private YYTextView feedbackDateContent;
    private YYView divider;
    private YYTextView feedbackWraming;
    private YYImageView feedbackImg;
    private YYTextView tvApply;
    private YYTextView tvRule;
    private YYLinearLayout llFeedbackModul;
    private YYTextView feedbackModulValue;
    private YYLinearLayout llFeedbackReason;
    private YYTextView feedbackReasonValue;
    private ConstraintLayout imFeedbackBtn;

    public ChatReportMessageHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.background = itemView.findViewById(R.id.feedback_ll);
        this.feedbackContent = (YYTextView)itemView.findViewById(R.id.feedback_content);
        this.feedbackType = (YYTextView)itemView.findViewById(R.id.feedback_type);
        this.feedbackPersionId = (YYTextView)itemView.findViewById(R.id.feedback_persion_id);
        this.feedbackPersionName = (YYTextView)itemView.findViewById(R.id.feedback_persion_name);
        this.feedbackCause = (YYTextView)itemView.findViewById(R.id.feedback_cause);
        this.feedbackCauseContent = (YYTextView)itemView.findViewById(R.id.feedback_cause_content);
        this.feedbackDate = (YYTextView)itemView.findViewById(R.id.feedback_date);
        this.feedbackDateContent = (YYTextView)itemView.findViewById(R.id.feedback_date_content);
        this.divider = (YYView)itemView.findViewById(R.id.divider_line);
        this.feedbackWraming = (YYTextView)itemView.findViewById(R.id.feedback_warming);
        this.feedbackImg = (YYImageView)itemView.findViewById(R.id.feedback_img);
        this.tvApply = (YYTextView)itemView.findViewById(R.id.tv_report_apply);
        this.tvRule = (YYTextView)itemView.findViewById(R.id.tv_report_rule);
        this.llFeedbackModul = (YYLinearLayout)itemView.findViewById(R.id.feedback_module);
        this.feedbackModulValue = (YYTextView)itemView.findViewById(R.id.feedback_module_value);
        this.llFeedbackReason = (YYLinearLayout)itemView.findViewById(R.id.feedback_reason);
        this.feedbackReasonValue = (YYTextView)itemView.findViewById(R.id.feedback_reason_value);
        this.imFeedbackBtn = (ConstraintLayout)itemView.findViewById(R.id.im_feedback_btn);
        itemView.findViewById(R.id.feedback_ll_container).setBackgroundResource(R.drawable.dialog_background_new);
    }

    public static BaseItemBinder<ChatMessageData, ChatReportMessageHolder> getBinder(final IMvpContext provider) {
        return new BaseItemBinder<ChatMessageData, ChatReportMessageHolder>(){

            @NonNull
            protected ChatReportMessageHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatReportMessageHolder(inflater.inflate(R.layout.layout_item_im_new_report, parent, false), provider);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        final ImMessageDBBean message = data2.message;
        if (message == null || message.getReportTitle() == null || message.getReportContent() == null) {
            MLog.error((Object)TAG, (String)"updateItem message is null", (Object[])new Object[0]);
            return;
        }
        String time = DateUtils.getTimeFromMillisecond((Long)message.getSendTime(), (SimpleDateFormat)CommonUtils.getSimpleDateFormat((String)"yyyy/MM/dd"));
        if (message.getMsgType() == 10) {
            this.feedbackImg.setImageResource(R.drawable.img_reported);
            if (!TextUtils.isEmpty((CharSequence)message.getReportNote())) {
                this.feedbackWraming.setVisibility(0);
                this.feedbackWraming.setText((CharSequence)message.getReportNote());
            } else {
                this.feedbackWraming.setVisibility(8);
            }
            this.tvApply.setVisibility(FP.empty((CharSequence)message.getSerial()) ? 8 : 0);
            this.divider.setVisibility(0);
            this.llFeedbackModul.setVisibility(0);
            this.feedbackPersionId.setVisibility(8);
            this.feedbackPersionName.setVisibility(8);
            this.llFeedbackReason.setVisibility(FP.empty((CharSequence)message.getAgainstDesc()) ? 8 : 0);
            this.feedbackModulValue.setText((CharSequence)message.getAgainstSource());
            this.feedbackCause.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_against_content));
            this.feedbackCauseContent.setText((CharSequence)message.getReportReason());
            this.feedbackDate.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_date));
            this.feedbackDateContent.setText((CharSequence)time);
            this.feedbackReasonValue.setText((CharSequence)message.getAgainstDesc());
            this.feedbackContent.setText((CharSequence)message.getReportContent());
            this.feedbackType.setText((CharSequence)message.getReportTitle());
            this.imFeedbackBtn.setVisibility(0);
            this.tvRule.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    WebEnvSettings webEnvSettings = new WebEnvSettings();
                    webEnvSettings.url = UriProvider.getRulesAndPolicies((String)"IMMessage");
                    ((IWebService)ServiceManagerProxy.getService(IWebService.class)).loadUrl(webEnvSettings);
                    ChatReportMessageHolder.this.itemClickEventReport();
                }
            });
            this.tvApply.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ChatReportMessageHolder.this.getEventCallback() != null) {
                        ChatReportMessageHolder.this.getEventCallback().reportApply((Activity)ChatReportMessageHolder.this.getContext(), 3, message.getSerial());
                    }
                }
            });
            this.exposureEventReport();
        } else if (message.getMsgType() == 28) {
            this.imFeedbackBtn.setVisibility(8);
            this.feedbackImg.setImageResource(R.drawable.icon_warning_face);
            this.feedbackContent.setText((CharSequence)message.getReserve1());
            this.feedbackType.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_recharge_detected));
            this.feedbackWraming.setVisibility(8);
            this.divider.setVisibility(8);
            this.feedbackDate.setVisibility(8);
            this.feedbackPersionName.setVisibility(8);
            this.feedbackPersionId.setVisibility(8);
            this.feedbackDate.setVisibility(8);
            this.feedbackDateContent.setVisibility(8);
            if (message.getReportTime() != 0L) {
                String reportTime = DateUtils.getTimeFromMillisecond((Long)(message.getReportTime() * 1000L), (SimpleDateFormat)CommonUtils.getSimpleDateFormat((String)"yyyy/MM/dd HH:mm:ss"));
                if (message.getReportTime() == -1L) {
                    reportTime = ResourceUtils.getString((int)R.string.short_tips_banned);
                }
                this.feedbackCauseContent.setText((CharSequence)reportTime);
                this.feedbackCause.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_unseal_time));
            } else {
                this.feedbackCauseContent.setText((CharSequence)time);
                this.feedbackCause.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_date));
            }
            this.background.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_7950c8));
            this.llFeedbackModul.setVisibility(8);
            this.llFeedbackReason.setVisibility(8);
        } else if (message.getMsgType() == 8) {
            this.imFeedbackBtn.setVisibility(8);
            this.feedbackImg.setImageResource(R.drawable.img_report_success);
            this.feedbackWraming.setVisibility(8);
            this.divider.setVisibility(8);
            this.llFeedbackModul.setVisibility(8);
            this.llFeedbackReason.setVisibility(8);
            this.feedbackPersionId.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_id));
            this.feedbackCause.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_cause));
            this.feedbackDate.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_date));
            this.feedbackContent.setText((CharSequence)message.getReportContent());
            this.feedbackType.setText((CharSequence)message.getReportTitle());
            this.feedbackCauseContent.setText((CharSequence)message.getReportReason());
            this.feedbackPersionName.setText((CharSequence)message.getReportNick());
            this.feedbackDateContent.setText((CharSequence)time);
        }
    }

    private void exposureEventReport() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60006377").put("function_id", "rules_im_entry_show"));
    }

    private void itemClickEventReport() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60006377").put("function_id", "rules_im_entry_click"));
    }
}

