/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.common.Callback;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.MarginInfo;
import com.yy.appbase.span.Size;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.dialog.OkDialog;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.appbase.unifyconfig.config.HyperLinkConfig;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.im.IMPostData;
import com.yy.hiyo.im.UidUtils;
import com.yy.hiyo.im.view.IMPostView;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.im.ImResourceManager;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.data.InteractiveEmojiTypeHelper;
import com.yy.im.module.room.holder.BaseImageMessageHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;
import kotlin.Unit;
import net.ihago.base.srv.msgcheck.LinkLevel;

@DontProguardClass
public class ChatReceivedMessageHolder
extends BaseImageMessageHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private HeadFrameImageView ivAvatar;
    private YYTextView tvTxtMsg;
    private YYTextView tvTime;
    private RoundImageView ivImageMsg;
    private ImageView ivImgLoading;
    private View contentView;
    private View ivLogo;
    private YYPlaceHolderView mPostHolder;
    private IMPostView mIMPostView;
    private static final String IMAGE_THUMBNAIL = YYImageUtils.getThumbnailPostfix((int)75);
    private static final int GIFT_ICON_SIZE = ResolutionUtils.dip2Px((float)25.0f);
    int mColorName = ColorUtils.parseColor((String)"#0b0505");

    public ChatReceivedMessageHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.ivAvatar = (HeadFrameImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.tvTxtMsg = (YYTextView)itemView.findViewById(R.id.tv_txt_msg);
        this.tvTxtMsg.setBackgroundResource(ImResourceManager.INSTANCE.getImOtherBackground());
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.ivImageMsg = (RoundImageView)itemView.findViewById(R.id.iv_image_msg);
        this.ivImgLoading = (ImageView)itemView.findViewById(R.id.iv_img_loading);
        this.contentView = itemView.findViewById(R.id.content);
        this.ivLogo = itemView.findViewById(R.id.iv_logo);
        this.mPostHolder = (YYPlaceHolderView)itemView.findViewById(R.id.postHolder);
        this.tvTxtMsg.setBackgroundResource(ImResourceManager.INSTANCE.getImOtherBackground());
    }

    public static BaseItemBinder<ChatMessageData, ChatReceivedMessageHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatReceivedMessageHolder>(){

            @NonNull
            protected ChatReceivedMessageHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatReceivedMessageHolder(inflater.inflate(R.layout.layout_item_im_chat_received, parent, false), context);
            }
        };
    }

    public void setData(final ChatMessageData data2) {
        super.setData((Object)data2);
        this.contentView.setTag(R.id.chat_message_data, null);
        this.ivImageMsg.setTag(R.id.chat_message_data, null);
        this.contentView.setOnLongClickListener(null);
        if (UidUtils.isSpecialUid((long)data2.message.getUid())) {
            this.ivAvatar.getCircleImageView().setImageResource(R.drawable.icon_public_msg_avatar);
        } else {
            this.showAvatar((RecycleImageView)this.ivAvatar.getCircleImageView(), this.getUserInfo(data2.message.getUid()));
        }
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
        this.ivAvatar.setOnClickListener((View.OnClickListener)this);
        this.ivLogo.setVisibility(8);
        if (null != this.mIMPostView) {
            this.mIMPostView.setVisibility(8);
        }
        switch (data2.message.getContentType()) {
            case 1: {
                if (data2.message.getMsgType() == 14) {
                    if (!TextUtils.isEmpty((CharSequence)data2.message.getReserve1())) {
                        int type = StringUtils.parseInt((String)data2.message.getReserve1());
                        this.tvTxtMsg.setText((CharSequence)InteractiveEmojiTypeHelper.getSpannableStringByType(type));
                    }
                } else if (data2.message.getMsgType() == 66) {
                    this.showGpRateMsg(data2);
                } else {
                    try {
                        this.tvTxtMsg.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(data2.message.getContent()));
                        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)EmojiManager.INSTANCE.getExpressionString(data2.message.getContent()));
                        Map linkMap = data2.message.getLinkMap();
                        if (linkMap != null) {
                            this.setLinkSpan(builder, linkMap);
                        }
                        this.tvTxtMsg.setText((CharSequence)builder);
                        this.tvTxtMsg.setAutoLinkMask(0);
                        this.tvTxtMsg.setMovementMethod(LinkMovementMethod.getInstance());
                    }
                    catch (Exception e) {
                        MLog.error((Object)"ChatReceivedMessageHolder", (Throwable)e);
                    }
                }
                this.tvTxtMsg.setVisibility(0);
                this.ivImageMsg.setVisibility(8);
                this.ivImgLoading.setVisibility(8);
                this.tvTxtMsg.setTag(R.id.chat_message_data, (Object)data2);
                this.tvTxtMsg.setOnLongClickListener((View.OnLongClickListener)this);
                if (FP.empty((CharSequence)data2.message.getPostId())) break;
                this.initPostView(data2.message);
                break;
            }
            case 2: {
                this.tvTxtMsg.setVisibility(8);
                this.ivImageMsg.setVisibility(0);
                this.ivImgLoading.setVisibility(8);
                this.ivImageMsg.setOnLongClickListener((View.OnLongClickListener)this);
                this.ivLogo.setVisibility(data2.message.getReserveInt1() == 1 ? 0 : 8);
                this.ivImageMsg.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ChatReceivedMessageHolder.this.getEventCallback() != null) {
                            ChatReceivedMessageHolder.this.getEventCallback().onImageClick(v, data2);
                        }
                    }
                });
                this.showImage(this.ivImgLoading, this.ivImageMsg, data2);
                if (FP.empty((CharSequence)data2.message.getPostId())) break;
                this.initPostView(data2.message);
                break;
            }
            case 11: {
                this.contentView.setTag(R.id.chat_message_data, (Object)data2);
                this.tvTxtMsg.setVisibility(0);
                this.ivImageMsg.setVisibility(8);
                this.ivImgLoading.setVisibility(8);
                this.contentView.setOnLongClickListener((View.OnLongClickListener)this);
                if (data2.message.getExtObj() instanceof GiftBroResult) {
                    GiftBroResult result = (GiftBroResult)data2.message.getExtObj();
                    this.bindGiftMsg(result.getGiftInfo() == null ? "" : result.getGiftInfo().getStaticIcon(), result.getGiftBroInfo().getPropsCount());
                    break;
                }
                this.bindGiftMsg(data2.message.getReserve1(), StringUtils.safeParseInt((String)data2.message.getReserve2()));
                break;
            }
        }
        HeadFrameType otherHeadFrameType = this.getOtherHeadFrameType();
        if (otherHeadFrameType != null) {
            Kvo.addKvoBinding((KvoSource)otherHeadFrameType, (Object)((Object)this), (String)"onOtherHeadFrameTypeUpdate");
        }
        if (data2.message.getStrategyType() > 0) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "no_action_strategy_msg_show"));
        }
        if (data2.message.getNewGuideStrategyType() > 0) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "new_guide_strategy_msg_show").put("strategy_source", String.valueOf(data2.message.getNewGuideStrategyType())).put("act_uid", String.valueOf(data2.message.getUid())));
        }
    }

    private void setLinkSpan(SpannableStringBuilder builder, Map<String, Integer> linkMap) {
        int nextIndex = 0;
        for (Map.Entry<String, Integer> entry : linkMap.entrySet()) {
            String link = entry.getKey();
            int level = entry.getValue();
            int start = builder.toString().indexOf(link, nextIndex);
            if (start == -1) continue;
            int end = start + link.length();
            int icon = R.drawable.icon_link_unknown;
            int textColor = Color.parseColor((String)"#FF9702");
            String tips = ResourceUtils.getString((int)R.string.tips_link_url_unknown);
            String url = HyperLinkConfig.Companion.getTipUrl(link, level);
            if (TextUtils.isEmpty((CharSequence)url)) break;
            if (level == LinkLevel.LinkLevel_Safe.getValue()) {
                icon = R.drawable.icon_link_safe;
                textColor = Color.parseColor((String)"#00A8FF");
                url = link;
                tips = ResourceUtils.getString((int)R.string.tips_link_url_safe);
            } else if (level == LinkLevel.LinkLevel_Unsafe.getValue()) {
                icon = R.drawable.icon_link_danger;
                textColor = Color.parseColor((String)"#FF5E79");
                tips = ResourceUtils.getString((int)R.string.tips_link_url_danger);
            }
            String finalTips = tips;
            int newStart = start;
            int newEnd = end;
            if (HyperLinkConfig.Companion.needShowLabel()) {
                SpannableStringBuilder imageSpan = ChainSpan.of().beginBlock().append(icon, Size.of((int)ResolutionUtils.dip2Px((float)12.0f), (int)ResolutionUtils.dip2Px((float)12.0f)), MarginInfo.of().right(ResolutionUtils.dip2Px((float)4.0f))).onBlockClick(() -> {
                    OkDialog okDialog = new OkDialog((CharSequence)finalTips, true, null);
                    okDialog.setShowCancel(false);
                    new DialogLinkManager(this.itemView.getContext()).showDialog((BaseDialog)okDialog);
                }).endBlock().buildSync();
                builder.insert(start, (CharSequence)imageSpan);
                newStart += imageSpan.length();
                newEnd += imageSpan.length();
            }
            String finalUrl = url;
            builder.setSpan((Object)new ChainSpan.ClickSpan(() -> {
                IServiceManager serviceManager = this.getServiceManager();
                if (serviceManager != null) {
                    ((IWebService)serviceManager.getService(IWebService.class)).loadUrl(finalUrl, "");
                }
                return Unit.INSTANCE;
            }, true, textColor), newStart, newEnd, 34);
        }
    }

    private void showGpRateMsg(ChatMessageData data2) {
        ChainSpan.of().append((CharSequence)data2.message.getContent()).newLine().beginBlock().append((CharSequence)ResourceUtils.getString((int)R.string.btn_rate_dialog_encourage_text)).onBlockClick(() -> MsgDispatcher.getInstance().sendMessage(MixBaseMsgDef.JUMP_GP_RATE_PAGE), true, ResourceUtils.getColor((int)R.color.color_2bb1ff)).endBlock().newLine().beginBlock().append((CharSequence)ResourceUtils.getString((int)R.string.btn_rate_dialog_complain_text)).onBlockClick(() -> MsgDispatcher.getInstance().sendMessage(MixBaseMsgDef.JUMP_H5_FEEDBACK), true, ResourceUtils.getColor((int)R.color.color_2bb1ff)).endBlock().onFinish(data1 -> YYTaskExecutor.postToMainThread(() -> {
            this.tvTxtMsg.setText((CharSequence)data1);
            this.tvTxtMsg.setMovementMethod(LinkMovementMethod.getInstance());
            MsgDispatcher.getInstance().sendMessage(MixBaseMsgDef.STAT_GP_RATE_MSG_SHOW);
        })).build();
    }

    private void initPostView(ImMessageDBBean bean) {
        if (null == this.mIMPostView) {
            this.mIMPostView = new IMPostView(this.getContext(), false);
            this.mPostHolder.inflate((View)this.mIMPostView);
        } else {
            this.mIMPostView.setVisibility(0);
        }
        this.mIMPostView.setOnPostEventListener(postId -> {
            if (this.getEventCallback() != null) {
                this.getEventCallback().jumpPostDetail(postId);
            }
        });
        IMPostData postData = new IMPostData();
        postData.setPostId(bean.getPostId());
        postData.setPostType(bean.getPostType());
        postData.setTime(Long.valueOf(bean.getPostTime()));
        postData.setContent(bean.getPostContent());
        postData.setImage(bean.getPostImage());
        this.mIMPostView.setData(postData);
    }

    private void bindGiftMsg(String iconUrl, int count) {
        ChainSpan.of().append((CharSequence)ResourceUtils.getString((int)R.string.summary_im_send_gift, (Object[])new Object[]{String.valueOf(count)}), new Object[]{TextSpan.of().size(13).color(-16777216).build()}).replaceImage("[gift]", iconUrl + IMAGE_THUMBNAIL, GIFT_ICON_SIZE, GIFT_ICON_SIZE, R.drawable.icon_gift_box, MarginInfo.of()).onUpdate((Callback)new Callback<Spannable>(){

            public void onResponse(Spannable data2) {
                ChatReceivedMessageHolder.this.tvTxtMsg.setText((CharSequence)data2);
            }
        }).build();
    }

    private void checkLinkFormat(YYTextView textView) {
        CharSequence text = textView.getText();
        int end = text.length();
        SpannableString spannable = text instanceof SpannableString ? (SpannableString)text : new SpannableString(text);
        Linkify.addLinks((Spannable)spannable, (int)15);
        URLSpan[] urlSpans = (URLSpan[])spannable.getSpans(0, end, URLSpan.class);
        if (urlSpans.length != 0) {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(text);
            spannableStringBuilder.clearSpans();
            for (URLSpan uri : urlSpans) {
                String url = uri.getURL();
                if (url.indexOf("http://") != 0 && url.indexOf("https://") != 0) continue;
                MyClickableSpan urlSpan = new MyClickableSpan(url);
                spannableStringBuilder.setSpan((Object)urlSpan, spannable.getSpanStart((Object)uri), spannable.getSpanEnd((Object)uri), 17);
            }
            textView.setAutoLinkMask(0);
            textView.setText((CharSequence)spannableStringBuilder);
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onOtherHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.ivAvatar != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame));
        }
    }

    public void onClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && this.getEventCallback() != null) {
            this.getEventCallback().onUserAvatarClick(((ChatMessageData)v.getTag((int)R.id.chat_message_data)).message.getUid(), 8);
        }
    }

    public boolean onLongClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.content || id2 == R.id.tv_txt_msg) {
            if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData) {
                if (this.getEventCallback() != null) {
                    this.getEventCallback().onChatMessageItemLongClick((ChatMessageData)v.getTag(R.id.chat_message_data), v);
                }
                return true;
            }
        } else if (id2 == R.id.iv_image_msg && v.getTag(R.id.chat_message_data) instanceof ChatMessageData) {
            if (this.getEventCallback() != null) {
                this.getEventCallback().onChatMessageItemLongClick((ChatMessageData)v.getTag(R.id.chat_message_data), v);
            }
            return true;
        }
        return false;
    }

    public static final class MyClickableSpan
    extends ClickableSpan {
        private String url;

        public MyClickableSpan(String url) {
            this.url = url;
        }

        public void onClick(@NonNull View widget) {
            ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(this.url);
        }

        public void updateDrawState(@NonNull TextPaint ds) {
            ds.setColor(-65536);
            ds.setUnderlineText(false);
        }
    }
}

