/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.BaseVH;
import com.yy.im.oas.ui.ImTimeView;

@DontProguardClass
public abstract class ChatBaseHolder
extends BaseVH<ChatMessageData> {
    public static final int DEFAULT_PIC_SIZE_WITH_PX = 90;
    public static final int DEFAULT_PIC_SIZE = ResolutionUtils.dip2Px((float)90.0f);
    public static final int MAX_PIC_SIZE = ResolutionUtils.dip2Px((float)160.0f);
    public static final float MAX_PIC_ASPECT_RATIO = 1.77f;
    public static final float MIN_PIC_ASPECT_RATIO = 0.56f;
    public static final float MAX_SQUARE_PIC_ASPECT_RATIO = 1.33f;
    public static final float MIN_SQUARE_PIC_ASPECT_RATIO = 0.75f;
    public static final int INTERVAL_FOR_SHOWING_TIME_INFO = 60000;
    @Nullable
    private Object mExtend;

    ChatBaseHolder(View itemView, IMvpContext context, @Nullable Object extend) {
        this(itemView, context);
        this.mExtend = extend;
    }

    ChatBaseHolder(View itemView, IMvpContext mvpContext) {
        super(itemView, mvpContext);
        itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChatBaseHolder.this.getEventCallback() != null) {
                    ChatBaseHolder.this.getEventCallback().onItemClick((ChatMessageData)ChatBaseHolder.this.getData());
                }
            }
        });
    }

    protected UserInfoKS getUserInfo(long uid) {
        return ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(uid);
    }

    protected IServiceManager getServiceManager() {
        return ServiceManagerProxy.getServiceManager();
    }

    protected HeadFrameType getOtherHeadFrameType() {
        if (this.getEventCallback() != null) {
            return this.getEventCallback().getHeadFrameType();
        }
        return null;
    }

    void setFormatTimeInfo(TextView tvTime2, ChatMessageData data2) {
        if (this.getEventCallback() == null) {
            return;
        }
        boolean showTime = this.getEventCallback().shouldShowTimeInfo(data2);
        if (showTime) {
            tvTime2.setVisibility(0);
            tvTime2.setText((CharSequence)ImTimeView.Companion.formatTime(data2.message.getSendTime()));
        } else {
            tvTime2.setVisibility(8);
        }
    }

    void showAvatar(RecycleImageView imageView, UserInfoKS bean) {
        if (bean == null) {
            imageView.setImageResource(R.drawable.icon_avatar_default_female);
        } else {
            int defaultAvatar = bean.sex == UserInfoKS.MALE ? R.drawable.icon_avatar_default_male : R.drawable.icon_avatar_default_female;
            ImageLoader.loadImage((ImageView)imageView, (String)(bean.avatar + YYImageUtils.getThumbnailPostfix((int)75)), (int)defaultAvatar, (int)defaultAvatar);
        }
    }

    public Object getExtend() {
        return this.mExtend;
    }
}

